# 機能設計書 20-パッケージメタデータ生成

## 概要

本ドキュメントは、Cookbook（Redox OSパッケージビルドシステム）におけるパッケージメタデータ生成機能の設計を記述する。パッケージ情報（名前、バージョン、blake3ハッシュ、依存関係）をTOML形式で出力する機能を提供する。

### 本機能の処理概要

パッケージメタデータ生成機能は、pkgarアーカイブと併せてstage.tomlファイルを生成し、パッケージの識別情報、バージョン、ハッシュ、依存関係等のメタデータを記録する機能である。

**業務上の目的・背景**：パッケージマネージャがパッケージをインストール・管理するためには、パッケージの名前、バージョン、依存関係等のメタデータが必要である。このメタデータにより、依存関係の自動解決、バージョン管理、アップグレード判定等が可能になる。

**機能の利用シーン**：`repo cook`コマンドでパッケージをビルドした後、pkgarアーカイブ作成と同時に呼び出される。生成されたstage.tomlはリポジトリ管理やパッケージインストール時に使用される。

**主要な処理内容**：
1. パッケージ名とバージョンの決定
2. pkgarファイルからblake3ハッシュの取得
3. 自動依存関係と明示的依存関係のマージ
4. ソース識別子（コミットハッシュ、タイムスタンプ）の取得
5. TOML形式でのメタデータ出力

**関連システム・外部連携**：pkgクレート（Package構造体）、pkgar_keysライブラリと連携する。

**権限による制御**：特別な権限制御はなし。ファイル書き込み権限のみ必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | stage.tomlへのパッケージ情報出力 |

## 機能種別

データ生成処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| toml_path | PathBuf | Yes | 出力先TOMLファイルパス | - |
| recipe | &CookRecipe | Yes | レシピ情報 | - |
| package_file | Option<(&Path, &PathBuf)> | No | (公開鍵パス, pkgarパス) | pkgarファイル存在時 |
| package_deps | Vec<PackageName> | Yes | 明示的依存関係 | - |
| auto_deps | &BTreeSet<PackageName> | Yes | 自動検出された依存関係 | - |

### 入力データソース

- recipe.toml: パッケージバージョン情報
- pkgarファイル: blake3ハッシュ取得用
- auto_deps.toml: 自動依存関係
- source_info.toml: ソース識別子

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| name | PackageName | パッケージ名 |
| version | String | パッケージバージョン |
| target | String | ターゲットトリプル |
| blake3 | String | pkgarファイルのblake3ハッシュ |
| network_size | u64 | ネットワーク転送サイズ |
| storage_size | u64 | ストレージサイズ |
| depends | Vec<PackageName> | 依存パッケージリスト |
| commit_identifier | String | ビルドのコミットハッシュ |
| source_identifier | String | ソースの識別子 |
| time_identifier | String | ビルド時刻 |

### 出力先

- メタデータファイル: `{recipe_dir}/target/{target}/stage.toml`
- オプショナルパッケージ: `{recipe_dir}/target/{target}/stage.{name}.toml`
- TOML形式例:
  ```toml
  name = "example"
  version = "1.0.0"
  target = "x86_64-unknown-redox"
  blake3 = "abc123..."
  network_size = 12345
  storage_size = 12345
  depends = ["libc", "libfoo"]
  commit_identifier = "abc123"
  source_identifier = "def456"
  time_identifier = "2024-01-01T00:00:00Z"
  ```

## 処理フロー

### 処理シーケンス

```
1. 依存関係マージ
   └─ package_depsにauto_depsを追加（重複除外）
2. blake3ハッシュ取得
   └─ pkgarファイルが存在すればヘッダからハッシュを読み取る
3. ファイルサイズ取得
   └─ pkgarファイルのメタデータからサイズを取得
4. ソース識別子取得
   └─ fetch_get_source_info()でsource_info.tomlから読み取る
5. Package構造体構築
   └─ pkgクレートのPackage構造体に値を設定
6. TOMLシリアライズ
   └─ serialize_and_write()でファイル出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[依存関係マージ]
    B --> C{pkgarファイルあり?}
    C -->|Yes| D[pkgar読み込み]
    D --> E[blake3ハッシュ取得]
    E --> F[ファイルサイズ取得]
    C -->|No| G[空ハッシュ/サイズ=0]
    F --> H[ソース識別子取得]
    G --> H
    H --> I[Package構造体構築]
    I --> J[TOMLシリアライズ]
    J --> K[ファイル出力]
    K --> L[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-20-01 | 依存関係マージ | auto_depsとpackage_depsを重複なしでマージ | 常時 |
| BR-20-02 | バージョン推定 | package.version未設定時はソースURLからバージョンを推定 | バージョン未設定時 |
| BR-20-03 | メタパッケージ空ハッシュ | BuildKind::Noneはblake3=""、size=0 | メタパッケージ時 |
| BR-20-04 | オプショナル依存 | オプショナルパッケージはメインパッケージのみに依存 | オプショナル処理時 |
| BR-20-05 | ホスト名除去 | nameにはhost.プレフィックスを含めない | 常時 |

### 計算ロジック

バージョン推定:
```
version = recipe.package.version
        OR guess_version(source.tar URL) // 正規表現でx.y.z形式を抽出
        OR "TODO"
```

## データベース操作仕様

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-META-01 | pkgar読み取り失敗 | pkgarファイル破損 | pkgarの再作成 |
| E-META-02 | 公開鍵読み取り失敗 | 公開鍵ファイル不存在 | ビルドの再実行 |
| E-META-03 | source_info読み取り失敗 | fetchが未実行 | fetchの再実行 |
| E-META-04 | TOMLシリアライズ失敗 | 無効な値 | データの確認 |

### リトライ仕様

自動リトライなし。エラー時はビルド全体が失敗。

## トランザクション仕様

- stage.tomlは直接書き込み
- 失敗時は不完全なファイルが残る可能性あり

## パフォーマンス要件

- pkgarヘッダのみ読み込むため、大きなパッケージでも高速
- 依存関係マージは重複チェック付きで効率的

## セキュリティ考慮事項

- blake3ハッシュによりパッケージの整合性を検証可能
- source_identifierにより、ソースの出所を追跡可能

## 備考

- pkgクレートのPackage構造体はRedox OS全体で共通
- メタパッケージはファイルを含まないため、pkgar/blake3が不要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Package構造体とメタデータの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.rs | `src/cook/package.rs` | package_toml関数内のPackage構造体構築（157-170行目） |

**読解のコツ**: `pkg::Package`はpkgクレートで定義されており、name、version、target、blake3、depends等のフィールドを持つ。

#### Step 2: 依存関係マージを理解する

自動依存関係と明示的依存関係のマージロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | package.rs | `src/cook/package.rs` | package_toml関数内の依存関係マージ（127-131行目） |

**主要処理フロー**:
- **127-131行目**: auto_depsの各要素をpackage_depsに追加（重複チェック付き）

#### Step 3: blake3ハッシュ取得を理解する

pkgarファイルからのハッシュ取得ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | package.rs | `src/cook/package.rs` | package_toml関数内のハッシュ取得（133-153行目） |

**主要処理フロー**:
- **133-153行目**: pkgarファイルが存在すれば公開鍵で検証しながらヘッダを読み込む
- **150行目**: hash_to_hex()でblake3をHex文字列に変換
- **151行目**: メタデータからサイズを取得

#### Step 4: バージョン推定を理解する

バージョンが未設定の場合の推定ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | package.rs | `src/cook/package.rs` | package_version関数（176-190行目） |

**主要処理フロー**:
- **177-178行目**: BuildKind::Noneは空文字列
- **179-180行目**: package.version設定済みならその値
- **181-186行目**: ソースURLから正規表現でバージョン推定
- **187-188行目**: 推定できなければ"TODO"

### プログラム呼び出し階層図

```
package::package() [package.rs:15]
    │
    └─ package_toml() [package.rs:120]
           │
           ├─ 依存関係マージ [package.rs:127-131]
           │      └─ auto_deps + package_deps (重複除外)
           │
           ├─ pkgarハッシュ取得 [package.rs:133-153]
           │      ├─ pkgar_keys::PublicKeyFile::open()
           │      ├─ pkgar::PackageFile::new()
           │      └─ hash_to_hex(header.blake3)
           │
           ├─ fetch_get_source_info() [fetch.rs:672]
           │      └─ source_info.toml読み込み
           │
           ├─ package_version() [package.rs:176]
           │      └─ バージョン決定ロジック
           │
           ├─ Package構造体構築 [package.rs:157-170]
           │
           └─ serialize_and_write() [fs.rs:254]
                  └─ TOML出力
```

### データフロー図

```
[入力]                    [処理]                         [出力]

auto_deps ──────────────▶ 依存関係マージ ───────────────▶ depends[]
package.dependencies          │                          (重複なし)
                              │
                              ▼

stage.pkgar ────────────▶ pkgar読み込み ────────────────▶ blake3
(Ed25519署名済)               │                          network_size
                              │                          storage_size
                              ▼

source_info.toml ───────▶ fetch_get_source_info ───────▶ commit_identifier
                              │                          source_identifier
                              │                          time_identifier
                              ▼

recipe.toml ────────────▶ package_version ─────────────▶ version
  package.version             │
  source.tar URL              │
                              ▼

                         Package構造体構築 ─────────────▶ pkg::Package
                              │
                              ▼

                         serialize_and_write ───────────▶ stage.toml
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| package.rs | `src/cook/package.rs` | ソース | メタデータ生成のメインロジック |
| fetch.rs | `src/cook/fetch.rs` | ソース | fetch_get_source_info |
| blake3.rs | `src/blake3.rs` | ソース | hash_to_hex関数 |
| fs.rs | `src/cook/fs.rs` | ソース | serialize_and_write |
| recipe.rs | `src/recipe.rs` | ソース | SourceRecipe::guess_version |
