# 機能設計書 21-パッケージ署名

## 概要

本ドキュメントは、Redox OS Cookbookシステムにおけるパッケージ署名機能の設計を記述したものである。パッケージ署名機能は、Ed25519鍵ペアを使用してパッケージに電子署名を付与し、パッケージの真正性と完全性を保証する。

### 本機能の処理概要

パッケージ署名機能は、ビルドされたパッケージに対して電子署名を付与することで、配布されるパッケージが改ざんされていないことを検証可能にするセキュリティ機能である。

**業務上の目的・背景**：Redox OSのパッケージ管理において、ユーザーが信頼できるパッケージのみをインストールできるようにする必要がある。署名されていないパッケージや改ざんされたパッケージがインストールされると、システムのセキュリティが脅かされる可能性がある。本機能により、パッケージの配布経路における改ざん検知と発行元の認証が可能となる。

**機能の利用シーン**：パッケージのビルド完了後、`repo cook`コマンドの最終段階でパッケージング処理が実行される際に自動的に呼び出される。パッケージファイル（.pkgar）の作成時に署名が埋め込まれる。また、パッケージのインストール時（`repo push`コマンド）に署名検証が行われる。

**主要な処理内容**：
1. Ed25519鍵ペア（秘密鍵・公開鍵）が存在しない場合、新規に生成して保存
2. pkgar形式のアーカイブ作成時に秘密鍵を使用して署名を生成
3. パッケージメタデータ（stage.toml）にblake3ハッシュを記録
4. パッケージインストール時に公開鍵を使用して署名を検証

**関連システム・外部連携**：pkgar（パッケージアーカイブ）ライブラリ、pkgar-keysライブラリと連携する。リモートパッケージ取得時にはリポジトリサーバー上の公開鍵を参照する。

**権限による制御**：特に権限制御はないが、秘密鍵ファイル（id_ed25519.toml）へのアクセス権限が署名操作に必要となる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | Ed25519鍵ペアでのパッケージ署名 |
| 7 | repo pushコマンド画面 | API連携 | 署名検証によるパッケージ展開 |

## 機能種別

セキュリティ処理 / 暗号化処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| stage_dirs | Vec<PathBuf> | Yes | ステージディレクトリのリスト | ディレクトリが存在すること |
| target_dir | PathBuf | Yes | ターゲットディレクトリ | ディレクトリが存在すること |
| recipe | CookRecipe | Yes | レシピ情報 | 有効なレシピ構造体であること |

### 入力データソース

- ステージディレクトリ（ビルド成果物の配置先）
- 秘密鍵ファイル（build/id_ed25519.toml）
- 公開鍵ファイル（build/id_ed25519.pub.toml）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| package_file | PathBuf | 署名付きpkgarアーカイブファイル |
| package_meta | PathBuf | パッケージメタデータ（stage.toml） |
| secret_key_file | PathBuf | Ed25519秘密鍵ファイル |
| public_key_file | PathBuf | Ed25519公開鍵ファイル |

### 出力先

- パッケージファイル：`{recipe_dir}/target/{target}/stage.pkgar`
- メタデータファイル：`{recipe_dir}/target/{target}/stage.toml`
- 秘密鍵：`build/id_ed25519.toml`
- 公開鍵：`build/id_ed25519.pub.toml`

## 処理フロー

### 処理シーケンス

```
1. 鍵ペアの確認・生成
   └─ 秘密鍵・公開鍵ファイルが存在しない場合、新規生成
2. ステージディレクトリの存在確認
   └─ 存在しない場合、clean_target設定に応じてエラーまたはスキップ
3. パッケージリストの取得
   └─ メインパッケージとオプショナルパッケージを取得
4. 各パッケージに対する署名処理
   └─ pkgar::createで署名付きアーカイブを生成
5. メタデータファイルの生成
   └─ blake3ハッシュ、依存関係情報等をTOML形式で保存
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{鍵ペア存在?}
    B -->|No| C[鍵ペア生成]
    B -->|Yes| D{ステージディレクトリ存在?}
    C --> D
    D -->|No| E{clean_target?}
    E -->|Yes| F[正常終了]
    E -->|No| G[エラー終了]
    D -->|Yes| H[パッケージリスト取得]
    H --> I[各パッケージをループ]
    I --> J{pkgarファイル要更新?}
    J -->|Yes| K[pkgar::create実行]
    J -->|No| L{メタデータ要更新?}
    K --> L
    L -->|Yes| M[package_toml生成]
    L -->|No| N{次のパッケージ?}
    M --> N
    N -->|Yes| I
    N -->|No| F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-21-01 | 鍵ペア自動生成 | 秘密鍵・公開鍵が存在しない場合、自動的に新規生成する | 初回ビルド時 |
| BR-21-02 | ステージ更新検出 | ステージディレクトリがパッケージファイルより新しい場合のみ再署名 | パッケージング時 |
| BR-21-03 | メタパッケージ除外 | BuildKind::Noneのメタパッケージは署名対象外 | ビルドテンプレートがnoneの場合 |

### 計算ロジック

**blake3ハッシュ計算**：
- pkgar::PackageFileからヘッダーのblake3値を取得
- `hash_to_hex`関数で16進数文字列に変換

## データベース操作仕様

### 操作別データベース影響一覧

本機能はファイルシステム操作のみであり、データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | KeySaveError | 鍵ファイルの保存に失敗 | ディスク容量・パーミッション確認 |
| - | StageMissing | ステージディレクトリが存在しない | ビルド処理の完了確認 |
| - | PkgarCreateError | pkgarアーカイブ作成に失敗 | ステージディレクトリ内容確認 |
| - | PublicKeyReadError | 公開鍵の読み込みに失敗 | 鍵ファイルの整合性確認 |

### リトライ仕様

特にリトライ処理は実装されていない。エラー発生時はビルド全体が失敗となる。

## トランザクション仕様

ファイルシステム操作のため、トランザクション制御は行われない。パッケージファイルは一時ファイルを使用せず直接書き込まれる。

## パフォーマンス要件

- Ed25519鍵ペア生成：1回あたり数ミリ秒程度
- pkgarアーカイブ作成：ファイルサイズに依存、通常数秒以内
- blake3ハッシュ計算：ファイルサイズに依存、進捗表示対応

## セキュリティ考慮事項

- 秘密鍵ファイル（id_ed25519.toml）は適切なファイルパーミッションで保護すること
- 秘密鍵はビルドディレクトリ内に保存されるため、リポジトリにコミットしないよう注意
- 公開鍵（id_ed25519.pub.toml）はパッケージインストール時の検証に必要

## 備考

- pkgar形式はRedox OS固有のパッケージアーカイブ形式
- Ed25519はDaniel J. Bernsteinらによって設計された高速かつ安全な署名アルゴリズム
- pkgar-keysライブラリがEd25519鍵の生成・保存・読み込みを担当

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パッケージングに関するデータ構造と、pkgarライブラリのインターフェースを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | CookRecipe構造体、BuildKind列挙型の定義 |
| 1-2 | package.rs | `src/cook/package.rs` | パッケージング関連の型定義 |

**読解のコツ**: `BuildKind::None`はメタパッケージを示し、署名処理がスキップされる。

#### Step 2: エントリーポイントを理解する

パッケージ署名処理の起点となる`package`関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | package.rs | `src/cook/package.rs` | package関数がエントリーポイント |

**主要処理フロー**:
1. **15-33行目**: package関数の開始、BuildKind::Noneチェック
2. **35-48行目**: 鍵ペアの存在確認と生成処理
3. **50-57行目**: ステージディレクトリの存在・更新確認
4. **59-78行目**: 各パッケージに対するpkgar作成ループ
5. **81-114行目**: 依存関係情報の設定とメタデータ生成

#### Step 3: 鍵ペア管理処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | package.rs | `src/cook/package.rs` | 35-48行目の鍵生成ロジック |

**主要処理フロー**:
- **35-36行目**: 秘密鍵・公開鍵のパス定義
- **37行目**: 両ファイルの存在確認
- **38-39行目**: buildディレクトリの作成
- **40行目**: `pkgar_keys::SecretKeyFile::new()`で鍵ペア生成
- **41-47行目**: 公開鍵・秘密鍵をファイルに保存

#### Step 4: pkgarアーカイブ作成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | package.rs | `src/cook/package.rs` | 72-78行目のpkgar::create呼び出し |

**主要処理フロー**:
- **72行目**: パッケージファイル未存在の確認
- **73-78行目**: `pkgar::create`で署名付きアーカイブ生成

#### Step 5: メタデータ生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | package.rs | `src/cook/package.rs` | 120-174行目のpackage_toml関数 |

**主要処理フロー**:
- **127-131行目**: 自動依存関係の追加
- **133-153行目**: blake3ハッシュとファイルサイズの取得
- **155行目**: ソース識別情報の取得
- **157-170行目**: Package構造体の構築
- **172行目**: TOMLシリアライズと書き込み

### プログラム呼び出し階層図

```
package() [src/cook/package.rs:15]
    │
    ├─ pkgar_keys::SecretKeyFile::new() [外部ライブラリ]
    │      └─ Ed25519鍵ペア生成
    │
    ├─ pkgar::create() [外部ライブラリ]
    │      └─ 署名付きアーカイブ作成
    │
    └─ package_toml() [src/cook/package.rs:120]
           │
           ├─ pkgar_keys::PublicKeyFile::open()
           │      └─ 公開鍵読み込み
           │
           ├─ pkgar::PackageFile::new()
           │      └─ パッケージファイル読み込み
           │
           ├─ fetch::fetch_get_source_info()
           │      └─ ソース識別情報取得
           │
           └─ serialize_and_write()
                  └─ TOMLシリアライズ・書き込み
```

### データフロー図

```
[入力]               [処理]                    [出力]

ステージディレクトリ ──┐
                      │
秘密鍵ファイル ───────┼───▶ pkgar::create ───▶ stage.pkgar
(自動生成可)          │          │
                      │          ▼
                      │     Ed25519署名
                      │          │
公開鍵ファイル ───────┼──────────┘
(自動生成可)          │
                      │
ソース情報 ───────────┼───▶ package_toml ───▶ stage.toml
                      │          │
依存関係情報 ─────────┘          ▼
                           blake3ハッシュ
                           Package構造体
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| package.rs | `src/cook/package.rs` | ソース | パッケージング・署名のメイン処理 |
| recipe.rs | `src/recipe.rs` | ソース | CookRecipe、BuildKind定義 |
| fs.rs | `src/cook/fs.rs` | ソース | ファイルシステム操作ユーティリティ |
| fetch.rs | `src/cook/fetch.rs` | ソース | ソース情報取得（fetch_get_source_info） |
| blake3.rs | `src/blake3.rs` | ソース | blake3ハッシュ計算 |
| repo.rs | `src/bin/repo.rs` | ソース | CLIエントリーポイント、package呼び出し |
