# 機能設計書 22-オプショナルパッケージ分離

## 概要

本ドキュメントは、Redox OS Cookbookシステムにおけるオプショナルパッケージ分離機能の設計を記述したものである。本機能は、単一のレシピから複数のパッケージを生成し、メインパッケージから追加パッケージをファイルパターンで分離する。

### 本機能の処理概要

オプショナルパッケージ分離機能は、ビルド成果物を複数のパッケージに分割し、ユーザーが必要なコンポーネントのみをインストールできるようにする機能である。

**業務上の目的・背景**：大規模なソフトウェアパッケージでは、すべてのコンポーネントが常に必要とは限らない。例えば、開発用ヘッダファイル、ドキュメント、追加プラグインなどは、一部のユーザーのみが必要とする。本機能により、パッケージを適切に分割することで、インストールサイズの削減とシステムリソースの効率的な利用が可能となる。

**機能の利用シーン**：レシピのrecipe.tomlで`[optional-packages]`セクションを定義することで利用される。ビルド完了後のパッケージング段階で、ファイルパターンに基づいてステージディレクトリからファイルを分離し、別個のpkgarファイルを生成する。

**主要な処理内容**：
1. recipe.tomlから`optional-packages`セクションを解析
2. ビルド成果物をファイルパターンに基づいて分類
3. オプショナルパッケージ用のステージディレクトリを作成
4. 各オプショナルパッケージに対して個別のpkgarアーカイブを生成
5. 依存関係情報（メインパッケージへの依存）を設定

**関連システム・外部連携**：パッケージング処理（機能No.19, 21）と連携し、複数のpkgarファイルを生成する。依存関係解決（機能No.14）では、オプショナルパッケージも含めた依存関係が処理される。

**権限による制御**：特に権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | 追加パッケージのファイルパターン分離 |

## 機能種別

パッケージング処理 / ファイル操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| recipe.optional_packages | Vec<OptionalPackageRecipe> | No | オプショナルパッケージ定義リスト | 各要素にname, filesが必須 |
| stage_dir | PathBuf | Yes | メインステージディレクトリ | ディレクトリが存在すること |

### 入力データソース

- recipe.tomlの`[optional-packages]`セクション
- ビルド成果物（ステージディレクトリ）

**recipe.toml設定例**：
```toml
[[optional-packages]]
name = "dev"
files = ["usr/include/**", "usr/lib/*.a"]
dependencies = []

[[optional-packages]]
name = "doc"
files = ["usr/share/doc/**", "usr/share/man/**"]
dependencies = []
```

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| stage.{name}.pkgar | File | オプショナルパッケージのアーカイブ |
| stage.{name}.toml | File | オプショナルパッケージのメタデータ |
| stage.{name}/ | Directory | オプショナルパッケージのステージディレクトリ |

### 出力先

- パッケージファイル：`{recipe_dir}/target/{target}/stage.{name}.pkgar`
- メタデータ：`{recipe_dir}/target/{target}/stage.{name}.toml`
- ステージディレクトリ：`{recipe_dir}/target/{target}/stage.{name}/`

## 処理フロー

### 処理シーケンス

```
1. レシピからオプショナルパッケージリストを取得
   └─ get_packages_list()でNone（メイン）とSome（オプショナル）を統合
2. 各オプショナルパッケージに対してループ処理
   └─ package_stage_pathsでステージパス決定
3. ステージディレクトリの構築
   └─ ビルド処理（cook_build）でファイルパターンに基づき分離
4. 各パッケージのpkgarアーカイブ生成
   └─ pkgar::createで署名付きアーカイブ作成
5. 依存関係の設定
   └─ オプショナルパッケージはメインパッケージに依存
6. メタデータファイルの生成
   └─ package_tomlでstage.{name}.tomlを生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[オプショナルパッケージリスト取得]
    B --> C{パッケージあり?}
    C -->|No| D[メインパッケージのみ処理]
    C -->|Yes| E[パッケージリスト作成]
    E --> F[各パッケージをループ]
    F --> G[ステージパス決定]
    G --> H{ステージ存在?}
    H -->|Yes| I{更新必要?}
    H -->|No| J[次のパッケージへ]
    I -->|Yes| K[pkgar::create実行]
    I -->|No| L{メタデータ存在?}
    K --> L
    L -->|No| M[依存関係設定]
    M --> N[package_toml生成]
    L -->|Yes| J
    N --> J
    J --> O{次のパッケージ?}
    O -->|Yes| F
    O -->|No| P[終了]
    D --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-22-01 | メインパッケージ依存 | オプショナルパッケージはメインパッケージに自動的に依存 | オプショナルパッケージ処理時 |
| BR-22-02 | パッケージ名規則 | オプショナルパッケージ名は`{main}.{name}`形式 | パッケージ名生成時 |
| BR-22-03 | 依存関係継承 | オプショナルパッケージ固有の依存関係も指定可能 | recipe.tomlで定義時 |
| BR-22-04 | 空依存名参照 | dependenciesに空名を指定すると同一レシピ内の他サフィックスを参照 | 依存関係解決時 |

### 計算ロジック

**パッケージ名生成**：
```
get_package_name(name, package) =
  if package.is_some() then
    format!("{}.{}", name, package.name)
  else
    name
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はファイルシステム操作のみであり、データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidPackageName | オプショナルパッケージ名が不正 | recipe.tomlのname設定確認 |
| - | StageDirectoryMissing | ステージディレクトリが存在しない | ビルド処理の確認 |
| - | FilePatternError | filesパターンが不正 | globパターン構文の確認 |

### リトライ仕様

特にリトライ処理は実装されていない。

## トランザクション仕様

ファイルシステム操作のため、トランザクション制御は行われない。各パッケージは独立して処理される。

## パフォーマンス要件

- パッケージ分離処理：ファイル数とサイズに依存
- 通常のパッケージングと同等のパフォーマンス

## セキュリティ考慮事項

- オプショナルパッケージも同じ鍵ペアで署名される
- ファイルパターンによる分離のため、意図しないファイルが含まれないよう注意

## 備考

- オプショナルパッケージは`-dev`（開発ヘッダ）、`-doc`（ドキュメント）などの用途で利用される
- メインパッケージは必ず最後に処理される（`get_packages_list`の実装による）
- クロスビルド時はCOOKBOOK_CROSS_TARGETによるパス調整が行われる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

オプショナルパッケージの定義構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | OptionalPackageRecipe構造体の定義（153-159行目） |
| 1-2 | recipe.rs | `src/recipe.rs` | Recipe構造体のoptional_packages フィールド（173行目） |

**読解のコツ**: `OptionalPackageRecipe`は`name`（パッケージサフィックス）、`dependencies`（追加依存）、`files`（ファイルパターン）を持つ。

#### Step 2: パッケージリスト取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.rs | `src/recipe.rs` | get_packages_list関数（218-224行目） |

**主要処理フロー**:
- **219-220行目**: オプショナルパッケージをSome(p)でラップしてリストに追加
- **222行目**: メインパッケージをNoneとして最後に追加
- **223行目**: 全パッケージリストを返却

#### Step 3: パッケージステージパス決定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | package.rs | `src/cook/package.rs` | package_stage_paths関数（200-212行目） |
| 3-2 | package.rs | `src/cook/package.rs` | get_package_name関数（233-244行目） |

**主要処理フロー**:
- **204-209行目**: COOKBOOK_CROSS_TARGETによるパス調整
- **211行目**: package_name_pathsで実際のパスを生成
- **238-243行目**: オプショナルパッケージ名の生成（`{name}.{suffix}`形式）

#### Step 4: パッケージング処理での分離を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | package.rs | `src/cook/package.rs` | package関数内のループ処理（59-115行目） |

**主要処理フロー**:
- **59行目**: get_packages_list()でパッケージリスト取得
- **61-62行目**: 各パッケージのステージパス決定
- **81-85行目**: オプショナルパッケージはメインパッケージに依存設定
- **88-92行目**: パッケージ名の生成（サフィックス付き）

#### Step 5: 依存関係処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | package.rs | `src/cook/package.rs` | 依存関係設定部分（81-106行目） |

**主要処理フロー**:
- **81-85行目**: オプショナルパッケージはメインパッケージ（without_host()）を依存に含む
- **93-106行目**: 空名の依存関係をレシピ内の同一サフィックスに解決

### プログラム呼び出し階層図

```
package() [src/cook/package.rs:15]
    │
    ├─ recipe.get_packages_list() [src/recipe.rs:218]
    │      └─ オプショナル + メインのリスト生成
    │
    ├─ package_stage_paths() [src/cook/package.rs:200]
    │      │
    │      └─ package_name_paths() [src/cook/package.rs:221]
    │             └─ get_package_name() [src/cook/package.rs:233]
    │
    ├─ pkgar::create() [外部ライブラリ]
    │      └─ 各パッケージの署名付きアーカイブ作成
    │
    └─ package_toml() [src/cook/package.rs:120]
           └─ 依存関係情報を含むメタデータ生成
```

### データフロー図

```
[入力]                    [処理]                      [出力]

recipe.toml ─────────────┐
  optional-packages       │
    name: "dev"           │
    files: ["*.h"]        ├──▶ get_packages_list ──▶ パッケージリスト
    dependencies: []      │         │
                         │         │
ステージディレクトリ ─────┘         ▼
  stage/                       package_stage_paths
    usr/                           │
      include/                     ▼
        foo.h    ─────────────▶ stage.dev/         ──▶ stage.dev.pkgar
      lib/                         │                     stage.dev.toml
        libfoo.so ────────────▶ stage/             ──▶ stage.pkgar
                                   │                     stage.toml
                                   ▼
                              依存関係設定
                              dev -> main
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.rs | `src/recipe.rs` | ソース | OptionalPackageRecipe構造体定義、get_packages_list |
| package.rs | `src/cook/package.rs` | ソース | パッケージング処理、ステージパス管理 |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | ビルド処理、ステージディレクトリ分離 |
| repo.rs | `src/bin/repo.rs` | ソース | CLIエントリーポイント |
