# 機能設計書 26-AppStream生成

## 概要

本ドキュメントは、Redox OS Cookbookシステムにおける AppStream生成機能の設計を記述したものである。本機能は、パッケージのメタデータからAppStreamカタログを生成し、アプリケーション検索・表示に必要な情報を提供する。

### 本機能の処理概要

AppStream生成機能は、各パッケージに含まれるAppStreamメタデータ（metainfo.xml等）を収集し、リポジトリ全体のAppStreamカタログを生成する機能である。

**業務上の目的・背景**：AppStreamはLinuxアプリケーション配布のための標準メタデータ形式であり、ソフトウェアセンター等のGUIアプリケーションで使用される。パッケージのアイコン、説明、スクリーンショットなどの情報を統一的に提供することで、ユーザーはインストール前にアプリケーションの詳細を確認できる。

**機能の利用シーン**：リポジトリ公開処理（機能No.23）において、COOKBOOK_APPSTREAM環境変数がtrueに設定されている場合に実行される。AppStreamメタデータを含むパッケージ（usr/share/metainfoディレクトリを持つもの）を検出し、appstreamcliコマンドでカタログを生成する。

**主要な処理内容**：
1. AppStreamメタデータを含むパッケージの検出
2. 一時ディレクトリの準備
3. appstreamcli composeコマンドの実行
4. 生成されたカタログのpkgarパッケージ化
5. リポジトリへの配置

**関連システム・外部連携**：appstreamcliコマンド（外部ツール）、pkgar形式のパッケージアーカイブと連携。

**権限による制御**：特に権限制御はないが、appstreamcliコマンドの実行権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | repo_builderコマンド画面 | 主機能 | AppStreamカタログ生成 |

## 機能種別

メタデータ処理 / カタログ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| appstream | bool | Yes | AppStream生成フラグ | COOKBOOK_APPSTREAM環境変数 |
| appstream_sources | HashMap<String, PathBuf> | Yes | AppStreamメタデータを含むパッケージマップ | - |

### 入力データソース

- 各パッケージのステージディレクトリ内 `usr/share/metainfo/` ディレクトリ
- COOKBOOK_APPSTREAM環境変数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| appstream_root | Directory | AppStreamカタログ出力ディレクトリ |
| repo-appstream.pkgar | File | AppStreamカタログのpkgarパッケージ |

### 出力先

- カタログディレクトリ：`build/{target}/appstream/`
- パッケージファイル：`{repo_dir}/{target}/repo-appstream.pkgar`

## 処理フロー

### 処理シーケンス

```
1. AppStream有効フラグの確認
   └─ COOKBOOK_APPSTREAM=trueの場合のみ実行
2. AppStreamソースの収集
   └─ パッケージ公開処理中にmetainfoディレクトリを検出
3. 出力ディレクトリの準備
   └─ 既存ディレクトリ・ファイルを削除して再作成
4. appstreamcli composeの実行
   └─ 各ソースディレクトリを入力として指定
5. カタログのpkgar化
   └─ pkgar::createで署名付きアーカイブ作成
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{COOKBOOK_APPSTREAM=true?}
    B -->|No| C[スキップ]
    B -->|Yes| D[AppStreamソース確認]
    C --> Z[終了]
    D --> E{ソースあり?}
    E -->|No| F[空のディレクトリで終了]
    E -->|Yes| G[出力ディレクトリ準備]
    F --> Z
    G --> H[既存ファイル削除]
    H --> I[ディレクトリ作成]
    I --> J[appstreamcli compose実行]
    J --> K{成功?}
    K -->|No| L[エラー返却]
    K -->|Yes| M[pkgar::create実行]
    L --> Z
    M --> N[repo-appstream.pkgar生成]
    N --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-26-01 | 環境変数制御 | COOKBOOK_APPSTREAM=trueの場合のみ実行 | 処理開始時 |
| BR-26-02 | metainfo検出 | usr/share/metainfoディレクトリの存在でAppStreamソースを判定 | パッケージ公開時 |
| BR-26-03 | カタログ再生成 | 毎回既存カタログを削除して再生成 | AppStream生成時 |
| BR-26-04 | origin指定 | appstreamcliのoriginは"pkgar"を使用 | appstreamcli実行時 |

### 計算ロジック

**AppStreamソース検出**：
```rust
if stage_dir.join("usr/share/metainfo").exists() {
    appstream_sources.insert(recipe.name().to_string(), stage_dir.clone());
}
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はファイルシステム操作のみであり、データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | AppstreamcliNotFound | appstreamcliコマンドが見つからない | appstreamcliのインストール |
| - | AppstreamcliFailed | appstreamcli composeが失敗 | 入力メタデータの確認 |
| - | PkgarCreateError | pkgarアーカイブ作成失敗 | ディスク容量・権限確認 |

### リトライ仕様

特にリトライ処理は実装されていない。appstreamcliの失敗はエラーとして返却される。

## トランザクション仕様

ファイルシステム操作のため、トランザクション制御は行われない。

## パフォーマンス要件

- AppStreamソース数に依存
- appstreamcli composeの処理時間に依存

## セキュリティ考慮事項

- AppStreamメタデータには任意のURL（スクリーンショット等）が含まれる可能性がある
- メタデータの改ざんに注意

## 備考

- appstreamcliはAppStream標準のカタログ生成ツール
- originパラメータ"pkgar"はRedox OS固有の識別子
- AppStreamカタログ自体もpkgar形式でパッケージ化される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

AppStreamソースの管理構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo_builder.rs | `src/bin/repo_builder.rs` | appstream_sources（91行目） |

**読解のコツ**: appstream_sourcesはHashMap<String, PathBuf>で、パッケージ名からステージディレクトリへのマッピング。

#### Step 2: AppStreamソース検出を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo_builder.rs | `src/bin/repo_builder.rs` | metainfo検出（128-130行目） |

**主要処理フロー**:
- **128行目**: `usr/share/metainfo`ディレクトリの存在確認
- **129行目**: 存在する場合、appstream_sourcesに追加

#### Step 3: AppStream生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo_builder.rs | `src/bin/repo_builder.rs` | AppStream生成（134-174行目） |

**主要処理フロー**:
- **135行目**: COOKBOOK_APPSTREAM=true確認
- **136行目**: ステータスメッセージ出力
- **138-143行目**: appstream_rootパス構築（build/{target}/appstream）
- **144行目**: appstream_pkgパス構築（repo-appstream.pkgar）
- **146-148行目**: 既存ディレクトリ・ファイルの削除と再作成
- **150行目**: appstream_sourcesが空でないことを確認

#### Step 4: appstreamcliコマンド実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repo_builder.rs | `src/bin/repo_builder.rs` | appstreamcli実行（151-166行目） |

**主要処理フロー**:
- **151行目**: Command::new("appstreamcli")
- **153行目**: "compose"サブコマンド
- **154行目**: "--origin=pkgar"オプション
- **155行目**: "--print-report=full"オプション
- **156行目**: "--result-root"で出力先指定
- **158-160行目**: 各ソースディレクトリを引数に追加
- **162-166行目**: コマンド実行と結果確認

#### Step 5: pkgarパッケージ化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | repo_builder.rs | `src/bin/repo_builder.rs` | pkgar::create呼び出し（168-172行目） |

**主要処理フロー**:
- **168-172行目**: pkgar::createでAppStreamカタログをパッケージ化
- 秘密鍵はbuild/id_ed25519.tomlを使用

### プログラム呼び出し階層図

```
publish_packages() [src/bin/repo_builder.rs:56]
    │
    ├─ パッケージ公開処理 [96-132行目]
    │      │
    │      └─ AppStreamソース検出 [128-130行目]
    │             └─ stage_dir.join("usr/share/metainfo").exists()
    │
    └─ AppStream生成処理 [134-174行目]
           │
           ├─ fs::remove_dir_all() / fs::remove_file()
           │      └─ 既存データ削除
           │
           ├─ fs::create_dir_all()
           │      └─ 出力ディレクトリ作成
           │
           ├─ Command::new("appstreamcli")
           │      │
           │      ├─ compose
           │      ├─ --origin=pkgar
           │      ├─ --print-report=full
           │      ├─ --result-root={appstream_root}
           │      └─ {source_paths...}
           │
           └─ pkgar::create()
                  └─ repo-appstream.pkgar生成
```

### データフロー図

```
[入力]                      [処理]                      [出力]

COOKBOOK_APPSTREAM ─────────┐
  = "true"                 │
                           ├──▶ フラグ確認
                           │
stage.{pkg}/ ──────────────┤
  usr/share/metainfo/      │
    *.metainfo.xml         ├──▶ AppStreamソース検出
                           │         │
                           │         ▼
                           │    appstream_sources
                           │    HashMap<pkg, stage_dir>
                           │         │
                           │         ▼
                           │    appstreamcli compose
                           │         │
                           │         ▼
build/id_ed25519.toml ─────┤    build/{target}/appstream/
                           │         │
                           │         ▼
                           │    pkgar::create
                           │         │
                           └─────────▼
                              repo-appstream.pkgar ──▶ {repo}/{target}/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo_builder.rs | `src/bin/repo_builder.rs` | ソース | AppStream生成のメイン処理 |
| package.rs | `src/cook/package.rs` | ソース | pkgar::create呼び出し元参考 |
| 外部ツール | appstreamcli | 外部 | AppStreamカタログ生成コマンド |
