# 機能設計書 28-cookコマンド

## 概要

本ドキュメントは、Redox OS Cookbookシステムにおけるcookコマンドの設計を記述したものである。本機能は、レシピをビルドしてパッケージ化する。

### 本機能の処理概要

cookコマンドは、fetchコマンドでダウンロードしたソースコードをビルドし、パッケージファイル（.pkgar）を生成する統合ビルドコマンドである。

**業務上の目的・背景**：Redox OSのパッケージビルドを自動化するための中核コマンド。ソースの取得（fetch）、ビルド（build）、パッケージング（package）を一連の処理として実行し、最終的にリポジトリへの公開処理も行う。TUIモード対応により、複数パッケージの並列ビルド状況を視覚的に確認可能。

**機能の利用シーン**：`repo cook <recipe>` コマンドで実行。複数のレシピを指定可能。`--filesystem`オプションでインストーラ設定ファイルを指定し、必要なパッケージを一括ビルドすることも可能。

**主要な処理内容**：
1. ソースコードの取得（fetchの実行）
2. ビルド処理（build関数の実行）
3. パッケージング（package関数の実行）
4. リポジトリへの公開（publish_packages）

**関連システム・外部連携**：fetch処理（機能No.27）、ビルドテンプレート処理（Cargo、Configure、CMake、Meson、Custom）、パッケージング（機能No.19）、リポジトリ公開（機能No.23）と連携。

**権限による制御**：特に権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | 主機能 | レシピのビルドとパッケージ化 |

## 機能種別

ビルド処理 / パッケージング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| recipes | Vec<CookRecipe> | Yes | ビルド対象レシピリスト | 1つ以上 |
| config | CliConfig | Yes | CLI設定 | - |

### 入力データソース

- コマンドライン引数（レシピ名）
- recipe.tomlの[build]セクション
- cookbook.tomlの設定

**ビルドテンプレート**：
```toml
# Cargoテンプレート
[build]
template = "cargo"
cargoflags = ""

# Configureテンプレート
[build]
template = "configure"
configureflags = []

# CMakeテンプレート
[build]
template = "cmake"
cmakeflags = []

# Mesonテンプレート
[build]
template = "meson"
mesonflags = []

# Customテンプレート
[build]
template = "custom"
script = "make && make install"
```

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| stage.pkgar | File | 署名付きパッケージファイル |
| stage.toml | File | パッケージメタデータ |
| *.log | File | ビルドログ（ログ有効時） |

### 出力先

- パッケージ：`{recipe_dir}/target/{target}/stage.pkgar`
- メタデータ：`{recipe_dir}/target/{target}/stage.toml`
- ログ：`build/logs/{target}/{recipe}.log`

## 処理フロー

### 処理シーケンス

```
1. レシピリストの構築
   └─ 依存関係を含めて構築
2. 各レシピに対する処理
   └─ TUIモード時は並列、非TUIは逐次
3. fetch処理
   └─ ソースコード取得
4. build処理
   └─ テンプレートに応じたビルド
5. package処理
   └─ pkgarファイル生成
6. publish処理
   └─ リポジトリへの公開
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{TUIモード?}
    B -->|Yes| C[run_tui_cook]
    B -->|No| D[逐次処理ループ]
    C --> E[Fetcher/Cookerスレッド起動]
    D --> F[handle_fetch]
    E --> G{全完了?}
    F --> H[handle_cook]
    G -->|No| I[ステータス更新]
    G -->|Yes| J[publish_packages]
    H --> K{エラー?}
    I --> G
    K -->|Yes| L{nonstop?}
    K -->|No| M[次のレシピ]
    L -->|Yes| N[handle_nonstop_fail]
    L -->|No| O[エラー終了]
    M --> P{全完了?}
    N --> M
    P -->|No| F
    P -->|Yes| J
    J --> Q[終了]
    O --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-28-01 | TUI自動判定 | CI環境変数未設定かつSTDIN開放時にTUI有効 | 処理開始時 |
| BR-28-02 | nonstop継続 | COOKBOOK_NONSTOP=true時はエラーでも継続 | ビルドエラー時 |
| BR-28-03 | 依存関係ビルド | ビルド依存は自動的にビルド対象に含む | レシピ解決時 |
| BR-28-04 | is_deps判定 | 依存としてビルドされるパッケージはis_deps=true | レシピマーク時 |
| BR-28-05 | clean_target | COOKBOOK_CLEAN_TARGET=true時はステージ削除 | ビルド後 |

### 計算ロジック

**ジョブ数**：
```rust
jobs = COOKBOOK_MAKE_JOBS || std::thread::available_parallelism()
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はファイルシステム操作のみであり、データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FetchFailed | ソース取得失敗 | fetch処理の確認 |
| - | BuildFailed | ビルドスクリプト失敗 | ビルドログ確認 |
| - | PackageFailed | パッケージング失敗 | ステージディレクトリ確認 |
| - | PublishFailed | リポジトリ公開失敗 | 権限・ディスク容量確認 |

### リトライ仕様

TUIモードではエラー発生時にRetry/Skip/Exitの選択肢を提供。nonstopモードではSkipのみ。

## トランザクション仕様

ファイルシステム操作のため、トランザクション制御は行われない。nonstopモードでは失敗時にステージディレクトリを削除して次のパッケージへ進む。

## パフォーマンス要件

- パッケージサイズとビルド内容に依存
- TUIモードでfetch/cookの並列実行をサポート
- COOKBOOK_MAKE_JOBSでビルド並列度を制御可能

## セキュリティ考慮事項

- ビルドスクリプトは信頼できるソースから取得すること
- サンドボックス環境でのビルドを推奨

## 備考

- TUIモードはratatuiライブラリを使用
- ビルドログはbuild/logs/に保存される（COOKBOOK_LOGS=true時）
- clean_targetオプションでステージディレクトリを削除し、ディスク使用量を削減可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビルドテンプレートの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | BuildKind列挙型（90-128行目） |
| 1-2 | recipe.rs | `src/recipe.rs` | BuildRecipe構造体（136-144行目） |

**読解のコツ**: BuildKindはNone、Remote、Cargo、Configure、Cmake、Meson、Customの7種類。

#### Step 2: CLIエントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | main_inner関数（182-249行目） |
| 2-2 | repo.rs | `src/bin/repo.rs` | repo_inner関数（286-355行目） |

**主要処理フロー**:
- **190行目**: parse_argsでレシピリスト構築
- **194行目**: TUIモード判定とrun_tui_cook呼び出し
- **292-348行目**: handle_fetch、handle_cookの呼び出し
- **237行目**: publish_packages呼び出し

#### Step 3: cook処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo.rs | `src/bin/repo.rs` | handle_cook関数（568-606行目） |

**主要処理フロー**:
- **576行目**: create_target_dirでターゲットディレクトリ作成
- **577-587行目**: build関数呼び出し
- **589-590行目**: package関数呼び出し
- **592-604行目**: clean_target時のステージ削除

#### Step 4: TUIモードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repo.rs | `src/bin/repo.rs` | run_tui_cook関数（1012-1501行目） |

**主要処理フロー**:
- **1016-1017行目**: work_tx/status_txチャネル作成
- **1027-1110行目**: Cookerスレッド
- **1136-1218行目**: Fetcherスレッド
- **1228-1488行目**: メインループ（イベント処理、UI描画）

#### Step 5: publish処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | repo.rs | `src/bin/repo.rs` | publish_packages関数（357-371行目） |

**主要処理フロー**:
- **358行目**: repo_builderの実行ファイルパス取得
- **359-368行目**: is_deps以外のレシピ名を引数に設定
- **370行目**: repo_builderコマンド実行

### プログラム呼び出し階層図

```
main_inner() [src/bin/repo.rs:182]
    │
    ├─ parse_args() [373行目]
    │      └─ レシピリスト構築、依存関係解決
    │
    ├─ run_tui_cook() [1012行目] (TUIモード)
    │      │
    │      ├─ Cookerスレッド [1027行目]
    │      │      └─ handle_cook()
    │      │
    │      └─ Fetcherスレッド [1136行目]
    │             └─ handle_fetch()
    │
    └─ repo_inner() [286行目] (非TUIモード)
           │
           ├─ handle_fetch() [553行目]
           │      └─ fetch() / fetch_offline()
           │
           └─ handle_cook() [568行目]
                  │
                  ├─ create_target_dir()
                  │
                  ├─ build() [外部]
                  │      └─ テンプレート別ビルド
                  │
                  └─ package() [外部]
                         └─ pkgar生成

publish_packages() [357行目]
    └─ repo_builder実行
```

### データフロー図

```
[入力]                      [処理]                      [出力]

コマンドライン引数 ─────────┐
  recipe names             │
                           ├──▶ parse_args ──▶ Vec<CookRecipe>
--filesystem ──────────────┘         │
                                     │
                                     ▼
source/ ───────────────────▶ handle_fetch ──▶ source_info.toml
                                     │
                                     ▼
source/ + recipe.toml ─────▶ build ──▶ target/{target}/stage/
                                     │
                                     ▼
stage/ + id_ed25519.toml ──▶ package ──▶ stage.pkgar
                                        stage.toml
                                     │
                                     ▼
stage.pkgar ───────────────▶ publish_packages ──▶ repo/{target}/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | CLIエントリーポイント、handle_cook関数 |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | build関数（テンプレート別ビルド） |
| package.rs | `src/cook/package.rs` | ソース | package関数（pkgar生成） |
| recipe.rs | `src/recipe.rs` | ソース | BuildKind、BuildRecipe定義 |
| repo_builder.rs | `src/bin/repo_builder.rs` | ソース | リポジトリ公開処理 |
