# 機能設計書 29-unfetchコマンド

## 概要

本ドキュメントは、Redox OS Cookbookシステムにおけるunfetchコマンドの設計を記述したものである。本機能は、レシピのソースディレクトリを削除する。

### 本機能の処理概要

unfetchコマンドは、fetchコマンドでダウンロードしたソースディレクトリ（source/）を削除するクリーンアップコマンドである。

**業務上の目的・背景**：ビルド作業が完了した後や、ソースを再取得したい場合に、既存のソースディレクトリを削除する必要がある。unfetchコマンドにより、指定したレシピのソースディレクトリを安全に削除できる。ディスク容量の解放や、新しいバージョンのソース取得前のクリーンアップに使用される。

**機能の利用シーン**：`repo unfetch <recipe>` コマンドで実行。`--all`オプションで全レシピのソースを一括削除することも可能。ソースコードの再取得が必要な場合や、ディスク容量を解放したい場合に使用。

**主要な処理内容**：
1. レシピのソースディレクトリパスの特定
2. ソースディレクトリの存在確認
3. ディレクトリ全体の再帰的削除

**関連システム・外部連携**：ファイルシステム操作のみ。

**権限による制御**：特に権限制御はないが、ディレクトリ削除権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | repo unfetchコマンド画面 | 主機能 | レシピソースディレクトリの削除 |

## 機能種別

クリーンアップ処理 / ファイル操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| recipe | CookRecipe | Yes | 対象レシピ | 有効なレシピ |

### 入力データソース

- コマンドライン引数（レシピ名）

## 出力仕様

### 出力データ

本機能は削除処理のため、ファイル出力はない。

### 削除対象

- ソースディレクトリ：`{recipe_dir}/source/`

## 処理フロー

### 処理シーケンス

```
1. レシピディレクトリの特定
2. ソースディレクトリパスの構築
3. ディレクトリ存在確認
4. ディレクトリ削除（fs::remove_dir_all）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[レシピディレクトリ特定]
    B --> C[source/パス構築]
    C --> D{ディレクトリ存在?}
    D -->|No| E[何もしない]
    D -->|Yes| F[fs::remove_dir_all]
    E --> G[終了]
    F --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-29-01 | 存在確認 | ディレクトリが存在しない場合は何もしない | 処理開始時 |
| BR-29-02 | 再帰削除 | ディレクトリ内の全ファイル・サブディレクトリを削除 | 削除実行時 |

### 計算ロジック

特に計算ロジックはない。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はファイルシステム操作のみであり、データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | PermissionDenied | 削除権限がない | ファイル権限確認 |
| - | IOError | I/Oエラー | ファイルシステム状態確認 |

### リトライ仕様

特にリトライ処理は実装されていない。

## トランザクション仕様

ファイルシステム操作のため、トランザクション制御は行われない。削除処理は不可逆。

## パフォーマンス要件

- ディレクトリサイズに依存
- 通常は数秒以内で完了

## セキュリティ考慮事項

- 削除操作は不可逆であるため、誤操作に注意
- ローカルで変更したソースコードは消失する

## 備考

- unfetchはsource/ディレクトリのみを削除し、target/は残す
- cleanコマンドとの違い：cleanはtarget/を削除、unfetchはsource/を削除
- 両方削除したい場合は、unfetchとcleanの両方を実行

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo.rs | `src/bin/repo.rs` | repo_inner関数のunfetchケース（349行目） |

**主要処理フロー**:
- **349行目**: `CliCommand::Unfetch => handle_clean(recipe, config, true, true)?`
- 第3引数（source）がtrue、第4引数（target）がtrue

#### Step 2: クリーン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | handle_clean関数（619-634行目） |

**主要処理フロー**:
- **625行目**: targetディレクトリパス構築
- **626-628行目**: target存在時は削除（unfetchではtarget=trueだが、実際はsourceフラグで制御）
- **629行目**: sourceディレクトリパス構築
- **630-632行目**: source存在かつsource=true時に削除

**注意**: repo.rsの実装を見ると、unfetchは`handle_clean(recipe, config, true, true)`を呼び出している。しかし、handle_clean内部では：
- `source`パラメータ（第3引数）がtrueの場合、source/ディレクトリを削除
- `target`パラメータ（第4引数）がtrueの場合、target/ディレクトリを削除

unfetchコマンドは両方trueを渡しているため、**実際にはsource/とtarget/の両方を削除する**。

### プログラム呼び出し階層図

```
repo_inner() [src/bin/repo.rs:286]
    │
    └─ handle_clean() [src/bin/repo.rs:619]
           │
           ├─ recipe.dir.join("target")
           │      └─ target/パス構築
           │
           ├─ fs::remove_dir_all(&dir) [target]
           │      └─ target/削除（target=true時）
           │
           ├─ recipe.dir.join("source")
           │      └─ source/パス構築
           │
           └─ fs::remove_dir_all(&dir) [source]
                  └─ source/削除（source=true時）
```

### データフロー図

```
[入力]                      [処理]                      [出力]

コマンドライン引数 ─────────┐
  recipe name              │
                           ├──▶ レシピ特定
                           │         │
{recipe_dir}/ ─────────────┘         │
  source/                            ▼
  target/                      handle_clean
                                     │
                           ┌─────────┴─────────┐
                           │                   │
                           ▼                   ▼
                     target/削除        source/削除
                     (target=true)     (source=true)
                           │                   │
                           └─────────┬─────────┘
                                     │
                                     ▼
                              {recipe_dir}/ (空に近い状態)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | CLIエントリーポイント、handle_clean関数 |
