# 機能設計書 30-cleanコマンド

## 概要

本ドキュメントは、Redox OS Cookbookシステムにおけるcleanコマンドの設計を記述したものである。本機能は、レシピのターゲットディレクトリを削除する。

### 本機能の処理概要

cleanコマンドは、ビルドで生成されたターゲットディレクトリ（target/）を削除するクリーンアップコマンドである。

**業務上の目的・背景**：ビルド成果物（中間ファイル、ステージディレクトリ、パッケージファイル等）を削除し、ディスク容量を解放する。再ビルドが必要な場合や、ビルド環境をクリーンな状態に戻したい場合に使用される。unfetchコマンドとは異なり、ソースコードは保持したままビルド成果物のみを削除する。

**機能の利用シーン**：`repo clean <recipe>` コマンドで実行。`--all`オプションで全レシピのターゲットディレクトリを一括削除することも可能。ビルド成果物の削除とディスク容量の解放に使用。

**主要な処理内容**：
1. レシピのターゲットディレクトリパスの特定
2. ターゲットディレクトリの存在確認
3. ディレクトリ全体の再帰的削除

**関連システム・外部連携**：ファイルシステム操作のみ。

**権限による制御**：特に権限制御はないが、ディレクトリ削除権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | repo cleanコマンド画面 | 主機能 | レシピターゲットディレクトリの削除 |

## 機能種別

クリーンアップ処理 / ファイル操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| recipe | CookRecipe | Yes | 対象レシピ | 有効なレシピ |

### 入力データソース

- コマンドライン引数（レシピ名）

## 出力仕様

### 出力データ

本機能は削除処理のため、ファイル出力はない。

### 削除対象

- ターゲットディレクトリ：`{recipe_dir}/target/`
  - ビルド中間ファイル
  - ステージディレクトリ（stage/）
  - パッケージファイル（stage.pkgar、stage.toml）

## 処理フロー

### 処理シーケンス

```
1. レシピディレクトリの特定
2. ターゲットディレクトリパスの構築
3. ディレクトリ存在確認
4. ディレクトリ削除（fs::remove_dir_all）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[レシピディレクトリ特定]
    B --> C[target/パス構築]
    C --> D{ディレクトリ存在?}
    D -->|No| E[何もしない]
    D -->|Yes| F[fs::remove_dir_all]
    E --> G[終了]
    F --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-30-01 | 存在確認 | ディレクトリが存在しない場合は何もしない | 処理開始時 |
| BR-30-02 | 再帰削除 | ディレクトリ内の全ファイル・サブディレクトリを削除 | 削除実行時 |
| BR-30-03 | ソース保持 | cleanはtarget/のみ削除し、source/は保持 | 常時 |

### 計算ロジック

特に計算ロジックはない。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はファイルシステム操作のみであり、データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | PermissionDenied | 削除権限がない | ファイル権限確認 |
| - | IOError | I/Oエラー | ファイルシステム状態確認 |

### リトライ仕様

特にリトライ処理は実装されていない。

## トランザクション仕様

ファイルシステム操作のため、トランザクション制御は行われない。削除処理は不可逆。

## パフォーマンス要件

- ターゲットディレクトリサイズに依存
- 通常は数秒以内で完了

## セキュリティ考慮事項

- 削除操作は不可逆であるため、誤操作に注意
- ビルド成果物（パッケージファイル等）は消失する

## 備考

- cleanはtarget/ディレクトリのみを削除し、source/は残す
- unfetchコマンドとの違い：unfetchはsource/とtarget/の両方を削除、cleanはtarget/のみ削除
- ソースを残したまま再ビルドしたい場合はcleanを使用
- 両方削除したい場合は、unfetchを使用するか、unfetchとcleanの両方を実行

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo.rs | `src/bin/repo.rs` | repo_inner関数のcleanケース（350行目） |

**主要処理フロー**:
- **350行目**: `CliCommand::Clean => handle_clean(recipe, config, false, true)?`
- 第3引数（source）がfalse、第4引数（target）がtrue
- これにより、target/のみが削除対象となる

#### Step 2: クリーン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | handle_clean関数（619-634行目） |

**主要処理フロー**:
- **625行目**: targetディレクトリパス構築（`recipe.dir.join("target")`）
- **626-628行目**: target存在かつtarget=true時に削除（cleanでは実行される）
- **629行目**: sourceディレクトリパス構築
- **630-632行目**: source存在かつsource=true時に削除（cleanではsource=falseなので実行されない）

**handle_clean関数の引数**:
```rust
fn handle_clean(
    recipe: &CookRecipe,
    _config: &CliConfig,
    source: bool,  // cleanではfalse
    target: bool,  // cleanではtrue
) -> anyhow::Result<()>
```

**コマンド別の呼び出し比較**:
| コマンド | source引数 | target引数 | 削除対象 |
|---------|-----------|-----------|---------|
| clean | false | true | target/のみ |
| unfetch | true | true | source/とtarget/ |

### プログラム呼び出し階層図

```
repo_inner() [src/bin/repo.rs:286]
    │
    └─ handle_clean() [src/bin/repo.rs:619]
           │
           ├─ recipe.dir.join("target")
           │      └─ target/パス構築
           │
           ├─ fs::remove_dir_all(&dir) [target]
           │      └─ target/削除（target=true時）
           │
           ├─ recipe.dir.join("source")
           │      └─ source/パス構築（cleanでは使用されない）
           │
           └─ (source削除はsource=falseのためスキップ)
```

### データフロー図

```
[入力]                      [処理]                      [出力]

コマンドライン引数 ─────────┐
  recipe name              │
                           ├──▶ レシピ特定
                           │         │
{recipe_dir}/ ─────────────┘         │
  source/ (保持)                     ▼
  target/ (削除対象)           handle_clean
                                     │
                           ┌─────────┴─────────┐
                           │                   │
                           ▼                   ▼
                     target/削除        source/保持
                     (target=true)     (source=false)
                           │                   │
                           └─────────┬─────────┘
                                     │
                                     ▼
                              {recipe_dir}/
                                source/ (残存)
                                (target/は削除済み)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | CLIエントリーポイント、handle_clean関数 |
