# 機能設計書 31-pushコマンド

## 概要

本ドキュメントは、cookbookシステムにおける`push`コマンド機能の設計を記述する。`push`コマンドは、ビルド済みパッケージをsysrootディレクトリに展開し、システムにインストールする機能を提供する。

### 本機能の処理概要

`push`コマンドは、pkgar形式でアーカイブ化されたパッケージファイルをsysrootディレクトリに展開し、Redoxオペレーティングシステムや開発環境にパッケージをインストールする機能である。

**業務上の目的・背景**：Redox OSの開発において、ビルドしたパッケージを実際の実行環境やテスト環境に配置する必要がある。手動でファイルをコピーするのは煩雑でエラーが発生しやすいため、パッケージの展開を自動化し、整合性を保証しながらインストールを行う仕組みが必要である。本機能はその要求を満たし、Ed25519署名による検証を行いながらパッケージを安全にインストールする。

**機能の利用シーン**：
- 開発者がビルドしたパッケージをローカルのsysrootに展開してテストする場合
- CI/CDパイプラインでビルド成果物をターゲット環境にデプロイする場合
- 複数のパッケージとその依存関係を一括でsysrootに展開する場合

**主要な処理内容**：
1. コマンドライン引数の解析とsysrootディレクトリの決定
2. `--with-package-deps`オプション指定時は依存パッケージを再帰的に解決
3. 各パッケージについてpkgarアーカイブの存在確認
4. Ed25519公開鍵を使用してパッケージ署名を検証
5. pkgarアーカイブをsysrootディレクトリに展開
6. 展開したパッケージサイズの集計と結果表示

**関連システム・外部連携**：
- pkgarライブラリ：パッケージの展開と署名検証に使用
- Ed25519公開鍵ファイル（`build/id_ed25519.pub.toml`）：署名検証に使用

**権限による制御**：本機能に特別な権限制御はないが、sysrootディレクトリへの書き込み権限が必要である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | repo pushコマンド画面 | 主機能 | パッケージのsysrootへの展開実行 |
| 12 | ヘルプ画面 | 補助機能 | pushコマンドの説明表示 |

## 機能種別

データ連携（パッケージファイルからファイルシステムへの展開）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| recipe_names | Vec<PackageName> | Yes | 展開対象のレシピ名リスト | 有効なパッケージ名形式 |
| --sysroot | PathBuf | No | 展開先のsysrootディレクトリ | 有効なディレクトリパス |
| --with-package-deps | bool | No | パッケージ依存関係を含めるか | - |
| --cookbook | PathBuf | No | cookbookディレクトリ | 有効なディレクトリパス |
| --repo | PathBuf | No | リポジトリディレクトリ | 有効なディレクトリパス |

### 入力データソース

- コマンドライン引数
- pkgarアーカイブファイル（`repo/{target}/{package_name}.pkgar`）
- Ed25519公開鍵ファイル（`build/id_ed25519.pub.toml`）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 展開結果 | 成功/失敗 | 各パッケージの展開成否 |
| 展開サイズ | u64 | 展開したパッケージの合計サイズ |
| パッケージ数 | usize | 展開したパッケージの数 |

### 出力先

- sysrootディレクトリ（デフォルト：Redox上では`/`、それ以外では`$PWD/sysroot`）
- 標準出力（成功/失敗メッセージ、サマリー情報）
- 標準エラー出力（エラーメッセージ）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ sysroot、with-package-deps等のオプションを取得

2. 依存関係解決（with-package-deps指定時）
   └─ 対象パッケージの依存関係を再帰的に収集

3. PUSH_SYSROOT_DIR静的変数にsysrootパスを設定

4. 各パッケージについてループ処理
   ├─ pkgarアーカイブファイルの存在確認
   ├─ 署名検証（id_ed25519.pub.toml使用）
   ├─ pkgar::extractでsysrootに展開
   └─ 成功/失敗メッセージ出力

5. サマリー出力
   └─ 合計サイズとパッケージ数を表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{with-package-deps?}
    B -->|Yes| C[依存関係を再帰的に解決]
    B -->|No| D[指定パッケージのみ対象]
    C --> E[パッケージリスト作成]
    D --> E
    E --> F{パッケージあり?}
    F -->|No| G[終了]
    F -->|Yes| H[次のパッケージ取得]
    H --> I{pkgarファイル存在?}
    I -->|No| J[NotBuiltエラー]
    I -->|Yes| K[pkgar::extract実行]
    K --> L{展開成功?}
    L -->|Yes| M[print_success]
    L -->|No| N[print_failed]
    J --> N
    M --> O{nonstop?}
    N --> O
    O -->|Yes| P[次のパッケージへ]
    O -->|No| Q{エラー発生?}
    Q -->|Yes| R[エラー終了]
    Q -->|No| P
    P --> F
    G --> S[サマリー出力]
    S --> T[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-31-1 | デフォルトsysroot | Redox上では"/"、それ以外では"$PWD/sysroot" | sysrootオプション未指定時 |
| BR-31-2 | 依存関係展開 | with-package-deps指定時のみ依存パッケージも展開 | --with-package-depsオプション指定時 |
| BR-31-3 | 署名検証必須 | 展開前にEd25519署名を検証 | 常時 |
| BR-31-4 | nonstopモード継続 | エラー発生時もnonstopモードなら処理継続 | COOKBOOK_NONSTOP=true |

### 計算ロジック

- 合計サイズ計算：各パッケージのpkgarファイルサイズを累積加算

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし（ファイルシステムへの操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NotBuilt | pkgarファイルが存在しない | 先にcookコマンドでビルドを実行 |
| - | 署名検証失敗 | 公開鍵で署名が検証できない | 正しい鍵ペアでパッケージを再作成 |
| - | 展開失敗 | ファイルシステムエラー | sysroot権限や空き容量を確認 |

### リトライ仕様

nonstopモード（COOKBOOK_NONSTOP=true）では、エラー発生時も次のパッケージの処理を継続する。

## トランザクション仕様

ファイルシステム操作のため、トランザクション制御なし。各パッケージの展開は独立して実行される。

## パフォーマンス要件

- 大量のパッケージを処理する場合でも、順次処理で安定して動作すること
- ファイル展開は逐次的に行われ、メモリ使用量は一定に保たれる

## セキュリティ考慮事項

- Ed25519署名による改ざん検知
- 公開鍵ファイル（`build/id_ed25519.pub.toml`）の整合性が前提
- sysrootディレクトリへの書き込み権限管理は運用に委ねる

## 備考

- Redox OS上で実行する場合は、デフォルトでルートディレクトリ（/）に展開される
- 依存関係の解決は`CookRecipe::get_package_deps_recursive`を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、pushコマンドで使用されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | CookRecipe構造体の定義（196-204行目）、パッケージ名・ディレクトリ・ターゲット情報 |
| 1-2 | tree.rs | `src/cook/tree.rs` | WalkTreeEntry列挙型（12-17行目）：Built/NotBuilt/Deduped/Missingの状態 |

**読解のコツ**: `CookRecipe`はパッケージのメタ情報を保持し、`WalkTreeEntry`は依存関係ツリーの各ノードの状態を表す。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | main_inner関数でCliCommand::Pushの分岐（208-209行目） |

**主要処理フロー**:
1. **208-209行目**: `handle_push`関数への分岐
2. **637-733行目**: `handle_push`関数の実装

#### Step 3: pushコマンド処理の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo.rs | `src/bin/repo.rs` | handle_push関数（637-733行目）：メイン処理ロジック |
| 3-2 | tree.rs | `src/cook/tree.rs` | walk_tree_entry関数（38-107行目）：依存関係ツリーの走査 |

**主要処理フロー**:
- **637-644行目**: recipe_mapの作成とsysrootの設定
- **645-682行目**: handle_push_inner クロージャの定義（実際の展開処理）
- **654-658行目**: pkgar::extract呼び出し
- **683-716行目**: with-package-deps有無による処理分岐

#### Step 4: 依存関係解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | recipe.rs | `src/recipe.rs` | get_package_deps_recursive関数（403-420行目） |
| 4-2 | recipe.rs | `src/recipe.rs` | new_recursive関数（285-383行目）：再帰的な依存関係収集 |

### プログラム呼び出し階層図

```
main (repo.rs:174)
    │
    └─ main_inner (repo.rs:182)
           │
           ├─ parse_args (repo.rs:373)
           │      └─ CookRecipe::get_package_deps_recursive (recipe.rs:403)
           │
           └─ handle_push (repo.rs:637)
                  │
                  ├─ walk_tree_entry (tree.rs:38) [with-package-deps時]
                  │      │
                  │      └─ handle_push_inner (repo.rs:645)
                  │             └─ pkgar::extract
                  │
                  └─ handle_push_inner (repo.rs:702) [直接呼び出し]
                         └─ pkgar::extract
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ───▶ parse_args ───▶ CliConfig
                                          │
                                          ▼
レシピファイル群 ───▶ 依存関係解決 ───▶ Vec<CookRecipe>
                                          │
                                          ▼
pkgarアーカイブ ───▶ pkgar::extract ───▶ sysrootディレクトリ
id_ed25519.pub.toml                       │
                                          ▼
                                    サマリー出力 ───▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | pushコマンドのエントリーポイントとメイン処理 |
| tree.rs | `src/cook/tree.rs` | ソース | 依存関係ツリーの走査とサイズ計算 |
| recipe.rs | `src/recipe.rs` | ソース | CookRecipe構造体と依存関係解決 |
| id_ed25519.pub.toml | `build/id_ed25519.pub.toml` | 設定 | パッケージ署名検証用公開鍵 |
