# 機能設計書 33-findコマンド

## 概要

本ドキュメントは、cookbookシステムにおける`find`コマンド機能の設計を記述する。`find`コマンドは、指定されたレシピ名に対応するレシピディレクトリのパスを標準出力に表示する簡潔な機能を提供する。

### 本機能の処理概要

`find`コマンドは、パッケージ名を入力として受け取り、そのパッケージのレシピが格納されているディレクトリの絶対パスを出力する機能である。

**業務上の目的・背景**：Redox OSの開発において、多数のレシピファイルがrecipesディレクトリ内の階層構造に配置されている。開発者がレシピファイルを編集したり、ソースディレクトリを確認したりする際に、正確なパスを素早く取得できることが作業効率向上に寄与する。本機能は、シェルスクリプトやCI/CDパイプラインでの自動化にも利用できる。

**機能の利用シーン**：
- レシピファイル（recipe.toml）を編集するためにエディタで開く際のパス取得
- シェルスクリプトからレシピディレクトリを参照する場合
- ビルドログやアーティファクトの場所を特定する場合
- CI/CDパイプラインでレシピの場所を動的に取得する場合

**主要な処理内容**：
1. コマンドライン引数からパッケージ名を取得
2. pkg::recipes::find関数でレシピディレクトリを検索
3. レシピディレクトリのパスを標準出力に出力

**関連システム・外部連携**：
- pkg::recipesモジュール：レシピディレクトリの検索に使用

**権限による制御**：本機能は情報表示のみであり、特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | repo findコマンド画面 | 主機能 | レシピのパス表示 |
| 12 | ヘルプ画面 | 補助機能 | findコマンドの説明表示 |

## 機能種別

情報表示（レシピディレクトリパスの出力）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| recipe_names | Vec<PackageName> | Yes | 検索対象のレシピ名リスト | 有効なパッケージ名形式 |
| --cookbook | PathBuf | No | cookbookディレクトリ | 有効なディレクトリパス |

### 入力データソース

- コマンドライン引数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| レシピパス | PathBuf | レシピディレクトリの絶対パス |

### 出力先

標準出力

### 出力形式例

```
/path/to/cookbook/recipes/category/package_name
```

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ パッケージ名リストを取得

2. 各パッケージについてループ処理
   ├─ CookRecipe::from_name でレシピ情報を取得
   └─ recipe.dir を標準出力に出力

3. 処理完了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[parse_args]
    B --> C{パッケージあり?}
    C -->|No| D[終了]
    C -->|Yes| E[次のパッケージ取得]
    E --> F[CookRecipe::from_name]
    F --> G{成功?}
    G -->|Yes| H[recipe.dir を出力]
    G -->|No| I[エラー処理]
    H --> J{verbose?}
    I --> K{nonstop?}
    K -->|Yes| L[次のパッケージへ]
    K -->|No| M[エラー終了]
    J -->|Yes| L
    J -->|No| L
    L --> C
    D --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-33-1 | 情報コマンド | verbose出力を抑制 | findコマンド実行時 |
| BR-33-2 | パス出力形式 | displayメソッドでパスを文字列化 | 常時 |

### 計算ロジック

特になし（単純なパス出力）

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | PackageNotFound | 指定されたパッケージのレシピが存在しない | パッケージ名を確認 |

### リトライ仕様

nonstopモード（COOKBOOK_NONSTOP=true）では、エラー発生時も次のパッケージの処理を継続する。

## トランザクション仕様

読み取り専用のため、トランザクション制御なし。

## パフォーマンス要件

- パッケージ名からレシピパスへの解決は即座に完了すること

## セキュリティ考慮事項

- 情報表示のみであり、特別なセキュリティ考慮は不要
- ファイルシステムへの読み取りアクセスのみ

## 備考

- findコマンドは情報表示コマンド（is_informational）として分類され、verbose出力が自動的に抑制される
- 主にシェルスクリプトとの連携や、他のコマンドへのパイプラインで使用されることを想定

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | CookRecipe構造体のdir フィールド（198行目） |

**読解のコツ**: `CookRecipe.dir`がレシピディレクトリのPathBufを保持している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | repo_inner関数のCliCommand::Find分岐（353行目） |

**主要処理フロー**:
1. **353行目**: `println!("{}", recipe.dir.display())` - パス出力

#### Step 3: レシピ検索処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | recipe.rs | `src/recipe.rs` | CookRecipe::from_name関数（262-268行目） |
| 3-2 | recipe.rs | `src/recipe.rs` | pkg::recipes::find呼び出し（263-264行目） |

**主要処理フロー**:
- **263行目**: `recipes::find(name.name())` でディレクトリを検索
- **265行目**: `Recipe::new(&file)` でrecipe.tomlを解析
- **267行目**: `Self::new(name, dir.to_path_buf(), recipe)` でCookRecipe生成

#### Step 4: コマンド分類を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repo.rs | `src/bin/repo.rs` | CliCommand::is_informational関数（102-104行目） |
| 4-2 | repo.rs | `src/bin/repo.rs` | verbose抑制（545-548行目） |

### プログラム呼び出し階層図

```
main (repo.rs:174)
    │
    └─ main_inner (repo.rs:182)
           │
           ├─ parse_args (repo.rs:373)
           │      └─ CookRecipe::from_name (recipe.rs:262)
           │             └─ pkg::recipes::find
           │
           └─ repo_inner (repo.rs:286)
                  │
                  └─ CliCommand::Find (repo.rs:353)
                         └─ println!("{}", recipe.dir.display())
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ───▶ parse_args ───▶ Vec<CookRecipe>
(パッケージ名)                             │
                                          ▼
                                    recipe.dir ───▶ 標準出力
                                    (PathBuf)       (パス文字列)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | findコマンドのエントリーポイントと出力処理 |
| recipe.rs | `src/recipe.rs` | ソース | CookRecipe構造体とfrom_name関数 |
| pkg::recipes | 外部クレート | ライブラリ | レシピディレクトリの検索 |
