# 機能設計書 34-filesystem設定オーバーライド

## 概要

本ドキュメントは、cookbookシステムにおける`filesystem設定オーバーライド`機能の設計を記述する。この機能は、インストーラ設定ファイル（filesystem.toml）を使用して、レシピごとのビルドルール（source/binary/local/ignore）を上書き指定する機能を提供する。

### 本機能の処理概要

`--filesystem`オプションは、redox-installerの設定ファイルを読み込み、各パッケージのビルド方法を動的に変更する機能である。これにより、同じcookbookで異なるビルド構成（全ソースビルド、事前ビルドバイナリ使用、ローカル変更保持など）を柔軟に切り替えられる。

**業務上の目的・背景**：Redox OSの開発・配布において、すべてのパッケージをソースからビルドする場合と、事前にビルドされたバイナリパッケージを利用する場合がある。CI/CDパイプラインでのビルド時間短縮や、開発者がローカルで行った変更を保持しながらビルドしたい場合など、状況に応じてビルド方法を柔軟に切り替える必要がある。本機能はその要求を満たす。

**機能の利用シーン**：
- 事前ビルド済みパッケージを利用して高速にシステムを構築する場合
- 特定のパッケージのみソースからビルドし、他はバイナリを使用する場合
- 開発中のローカル変更を保持したままビルドする場合
- 特定のパッケージをビルド対象から除外する場合

**主要な処理内容**：
1. `--filesystem`オプションで指定されたファイルをredox_installerで解析
2. 各パッケージの設定（PackageConfig）を取得
3. レシピごとにapply_filesystem_configを呼び出してビルドルールを適用
4. source/binary/local/ignoreに応じてレシピの動作を変更

**関連システム・外部連携**：
- redox_installerクレート：設定ファイルの解析に使用
- PackageConfig列挙型：各パッケージのビルドルール指定

**権限による制御**：本機能に特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | 補助機能 | --filesystemでのレシピビルドルール指定 |

## 機能種別

設定管理（ビルドルールのオーバーライド）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --filesystem | PathBuf | No | インストーラ設定ファイルのパス | 有効なファイルパス、TOML形式 |
| --repo-binary | bool | No | デフォルトをbinaryモードに設定 | - |

### 入力データソース

- コマンドライン引数
- インストーラ設定ファイル（filesystem.toml形式）

### 設定ファイル形式

```toml
[general]
repo_binary = true  # デフォルトのビルドルール

[packages]
kernel = "source"     # ソースからビルド
init = "binary"       # 事前ビルド済みを使用
myapp = "local"       # ローカル変更を保持
legacy = "ignore"     # ビルド対象から除外
```

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変更後のレシピ設定 | CookRecipe | ビルドルールが適用されたレシピ |

### 出力先

CookRecipe構造体の内部状態（recipeフィールド）

## 処理フロー

### 処理シーケンス

```
1. parse_args でfilesystemオプションを解析
   └─ redox_installer::Config::from_file でファイル読み込み

2. --repo-binary指定時の処理
   └─ conf.general.repo_binary = Some(true) に設定

3. 各レシピに対してルール適用（revループ）
   ├─ conf.packages から該当パッケージの設定取得
   ├─ last_rule の継承処理
   └─ recipe.apply_filesystem_config(last_rule) 呼び出し

4. apply_filesystem_config 内部処理
   ├─ "source": 通常ビルド（変更なし）
   ├─ "local": source セクションを None に
   ├─ "binary": source を None、build を Remote に
   └─ "ignore": source を None、build を None に
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{--filesystem指定?}
    B -->|No| C[通常処理]
    B -->|Yes| D[Config::from_file]
    D --> E{解析成功?}
    E -->|No| F[エラー終了]
    E -->|Yes| G{--repo-binary?}
    G -->|Yes| H[repo_binary = true]
    G -->|No| I[設定をそのまま使用]
    H --> J[レシピループ rev]
    I --> J
    J --> K{パッケージ設定あり?}
    K -->|Yes| L[last_rule更新]
    K -->|No| M[last_rule継承]
    L --> N[apply_filesystem_config]
    M --> N
    N --> O{ルールは?}
    O -->|source| P[変更なし]
    O -->|local| Q[source=None]
    O -->|binary| R[source=None, build=Remote]
    O -->|ignore| S[source=None, build=None]
    P --> T{次のレシピ?}
    Q --> T
    R --> T
    S --> T
    T -->|Yes| J
    T -->|No| U[終了]
    C --> U
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-1 | source | 通常どおりソースからビルド | rule="source" |
| BR-34-2 | local | ソース取得をスキップし、既存のsourceディレクトリを使用 | rule="local" |
| BR-34-3 | binary | リモートから事前ビルド済みパッケージを取得 | rule="binary" |
| BR-34-4 | ignore | ビルドをスキップ（メタパッケージ向け） | rule="ignore" |
| BR-34-5 | 継承 | 設定がないパッケージは直前のルールを継承（revループのため親から子へ） | packages設定なし時 |
| BR-34-6 | ホストパッケージ除外 | 全てbinaryの場合、ホストツールチェインパッケージを除外 | should_drop_host_packages=true |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル読み込み失敗 | filesystemファイルが存在しないまたは読み取り不可 | ファイルパスを確認 |
| - | 解析エラー | TOMLファイルの形式が不正 | ファイル形式を確認 |
| - | 無効なルール | source/local/binary/ignore以外の値 | 有効な値に修正 |

### リトライ仕様

リトライなし（設定エラーは即座に終了）

## トランザクション仕様

設定の読み込みと適用のみで、トランザクション制御なし。

## パフォーマンス要件

- 設定ファイルの解析は即座に完了すること
- レシピへの適用処理は各レシピに対してO(1)

## セキュリティ考慮事項

- 設定ファイルのパスはユーザーが指定するため、任意のファイルが読み取られる可能性がある
- 信頼できない設定ファイルの使用には注意が必要

## 備考

- revループを使用しているため、設定が明示されていないパッケージは「親」（リスト後方）の設定を継承する
- "local"は開発時に便利で、ローカルで行った変更を保持したままビルドできる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo.rs | `src/bin/repo.rs` | CliConfig構造体のfilesystemフィールド（84行目） |
| 1-2 | recipe.rs | `src/recipe.rs` | CookRecipe構造体のruleフィールド（204行目） |

**読解のコツ**: `CliConfig.filesystem`は`Option<redox_installer::Config>`型で、インストーラ設定全体を保持する。

#### Step 2: コマンドライン解析を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | --filesystemオプション解析（386-390行目） |
| 2-2 | repo.rs | `src/bin/repo.rs` | --repo-binaryオプション処理（435-439行目） |

**主要処理フロー**:
1. **386-390行目**: `redox_installer::Config::from_file`でファイル読み込み
2. **402行目**: `--repo-binary`フラグの保存
3. **435-439行目**: `repo_binary`の上書き設定

#### Step 3: ルール適用処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo.rs | `src/bin/repo.rs` | レシピへのルール適用ループ（511-543行目） |
| 3-2 | recipe.rs | `src/recipe.rs` | apply_filesystem_config関数（441-471行目） |

**主要処理フロー**:
- **514-515行目**: デフォルトルールの決定（repo_binary時はbinary、それ以外はsource）
- **518-529行目**: 各レシピへのルール取得とlast_rule更新
- **534-536行目**: `apply_filesystem_config`呼び出し
- **441-471行目**: ルールに応じたレシピ変更（source/local/binary/ignore）

#### Step 4: 各ルールの効果を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | recipe.rs | `src/recipe.rs` | "source"ルール（444行目）：変更なし |
| 4-2 | recipe.rs | `src/recipe.rs` | "local"ルール（446行目）：source=None |
| 4-3 | recipe.rs | `src/recipe.rs` | "binary"ルール（448-450行目）：source=None, build=Remote |
| 4-4 | recipe.rs | `src/recipe.rs` | "ignore"ルール（455-458行目）：source=None, build=None |

### プログラム呼び出し階層図

```
main (repo.rs:174)
    │
    └─ main_inner (repo.rs:182)
           │
           └─ parse_args (repo.rs:373)
                  │
                  ├─ redox_installer::Config::from_file (386-390)
                  │
                  └─ レシピループ (511-543)
                         │
                         └─ recipe.apply_filesystem_config (534-536)
                                │
                                ├─ "source": 変更なし
                                ├─ "local": source = None
                                ├─ "binary": build.set_as_remote()
                                └─ "ignore": build.set_as_none()
```

### データフロー図

```
[入力]                       [処理]                           [出力]

--filesystem引数 ───▶ Config::from_file ───▶ redox_installer::Config
                                               │
                                               ▼
--repo-binary引数 ────────────────────────▶ repo_binary設定
                                               │
                                               ▼
レシピリスト ─────────────────────────────▶ apply_filesystem_config
                                               │
                                               ▼
                                          変更されたCookRecipe
                                          (source/build設定)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | コマンドライン解析とルール適用ループ |
| recipe.rs | `src/recipe.rs` | ソース | apply_filesystem_config関数とCookRecipe構造体 |
| redox_installer | 外部クレート | ライブラリ | 設定ファイルの解析 |
