# 機能設計書 35-並列ビルドTUI

## 概要

本ドキュメントは、cookbookシステムにおける`並列ビルドTUI`機能の設計を記述する。この機能は、ratatuiベースのターミナルUIでfetch/cookの進捗を表示し、エラー時にリトライ/スキップ/終了を選択可能なインタラクティブなビルド環境を提供する。

### 本機能の処理概要

並列ビルドTUIは、複数のパッケージのfetch（ソース取得）とcook（ビルド）を並列に実行しながら、3分割レイアウトのターミナルUIで進捗状況をリアルタイム表示する機能である。

**業務上の目的・背景**：Redox OSのフルビルドでは多数のパッケージを処理する必要があり、処理時間が長くなる。並列化により処理を高速化しつつ、ユーザーが現在の進捗状況をリアルタイムで把握できることが重要である。また、ビルドエラー発生時に処理を中断するだけでなく、リトライやスキップの選択肢を提供することで、開発者の作業効率を向上させる。

**機能の利用シーン**：
- 多数のパッケージをビルドする際にリアルタイムで進捗を確認したい場合
- fetch（ダウンロード）とcook（ビルド）を並列に実行して時間を短縮したい場合
- ビルドエラー発生時にインタラクティブにリトライ/スキップ/終了を選択したい場合
- ビルドログをスクロールして詳細を確認したい場合

**主要な処理内容**：
1. Fetcherスレッドでソースコードの取得を順次実行
2. Cookerスレッドでビルド処理を並列実行
3. メインスレッドでratatuiベースのUI描画とイベント処理
4. 3分割レイアウト（Fetch Queue / Cook Queue / Log）での表示
5. エラー発生時のFailurePromptダイアログ表示

**関連システム・外部連携**：
- ratatuiクレート：ターミナルUI描画
- termionクレート：ターミナル制御とイベント処理
- PTY（擬似端末）：子プロセスの出力キャプチャ

**権限による制御**：本機能に特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | TUIメイン画面 | 主機能 | ratatuiベースの3分割レイアウトによる並列fetch/cookの進捗表示 |
| 2 | 失敗時プロンプトダイアログ | 主機能 | FailurePrompt構造体によるエラーダイアログ表示 |

## 機能種別

ユーザーインターフェース（ターミナルUI）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --tui | bool | No | TUIモードの有効化（デフォルトでCI環境以外は有効） | - |
| レシピリスト | Vec<CookRecipe> | Yes | ビルド対象のレシピリスト | 有効なレシピ |

### 入力データソース

- コマンドライン引数
- キーボード入力（ナビゲーション、選択）
- マウス入力（スクロール）

### キーバインド

| キー | 機能 |
|-----|------|
| 1 | Fetch Queueパネルのログ表示に切り替え |
| 2 | Cook Queueパネルのログ表示に切り替え |
| c | ビルドを停止（全子プロセス終了） |
| Up/Down | ログを1行スクロール |
| PageUp/PageDown | ログを20行スクロール |
| Home | ログの先頭に移動 |
| End | ログの末尾に追従（自動スクロール有効化） |
| q/Ctrl+C/Esc | 終了（プロンプト表示時） |
| Left/Right/Tab | プロンプトの選択肢間を移動 |
| Enter | プロンプトの選択を確定 |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Fetch Queueパネル | UI | 取得待ち・取得中のパッケージリスト |
| Cook Queueパネル | UI | ビルド待ち・ビルド中・完了のパッケージリスト |
| Logパネル | UI | 現在処理中のパッケージのビルドログ |
| FailurePrompt | UI | エラー時の選択ダイアログ |

### 出力先

- ターミナル（代替スクリーン）
- ログファイル（`build/logs/{target}/{package}.log`）

## 処理フロー

### 処理シーケンス

```
1. TUI初期化
   ├─ ターミナルをrawモードに設定
   ├─ 代替スクリーンに切り替え
   └─ ratatui Terminalを初期化

2. スレッド起動
   ├─ Fetcherスレッド起動
   ├─ Cookerスレッド起動
   └─ 入力イベントスレッド起動

3. メインループ
   ├─ UI描画（100ms間隔）
   ├─ ステータス更新の受信
   ├─ キーボード/マウスイベント処理
   └─ プロンプト表示と応答処理

4. 終了処理
   ├─ 代替スクリーン終了
   ├─ スレッドの終了待ち
   └─ 結果の返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[TUI初期化]
    B --> C[スレッド起動]
    C --> D[メインループ]
    D --> E{running?}
    E -->|No| F[終了処理]
    E -->|Yes| G[UI描画]
    G --> H[ステータス受信]
    H --> I{プロンプト表示?}
    I -->|Yes| J[プロンプト描画]
    I -->|No| K[イベント処理]
    J --> K
    K --> L{cook完了?}
    L -->|Yes| M[running=false]
    L -->|No| D
    M --> E
    F --> N[スレッド終了待ち]
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-35-1 | TUIデフォルト | CI環境変数が設定されていない場合はTUIモードが有効 | CI環境変数未設定 |
| BR-35-2 | 並列実行 | fetchとcookは別スレッドで並列実行 | 常時 |
| BR-35-3 | プロンプト待機 | エラー時はプロンプトでユーザー入力を待つ | nonstopモードでない場合 |
| BR-35-4 | ログ自動スクロール | 新しいログ行が追加されると自動的に末尾にスクロール | auto_scroll=true |
| BR-35-5 | スピナー表示 | 処理中のパッケージにはスピナーアニメーションを表示 | 100ms間隔で更新 |

### 計算ロジック

**スピナーアニメーション**：
```rust
let spinner = ['-', '\\', '|', '/'];
let spin = spinner[spinner_i % spinner.len()];
```

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FetchError | ソース取得失敗 | プロンプトでリトライ/スキップ/終了を選択 |
| - | CookError | ビルド失敗 | プロンプトでリトライ/スキップ/終了を選択 |

### リトライ仕様

FailurePromptでRetryを選択すると、同じパッケージのfetch/cookを再実行する。

### プロンプト選択肢

| 選択肢 | prompting値 | 動作 |
|-------|------------|------|
| Retry | 2 | 同じパッケージを再処理 |
| Skip | 3 | 現在のパッケージをスキップして次へ |
| Exit | 4 | 処理を終了 |

## トランザクション仕様

トランザクション制御なし（各パッケージの処理は独立）

## パフォーマンス要件

- UI更新は100ms間隔（TICK_RATE）
- fetchとcookの並列実行により処理時間を短縮
- ログの大量出力時もUIがフリーズしないこと

## セキュリティ考慮事項

- ターミナルのrawモード使用（終了時に確実に復元する必要あり）
- 子プロセスの出力はPTY経由でキャプチャ

## 備考

- nonstopモードではプロンプトが表示されず自動的にスキップされる
- Fetch完了後はFetch Queueパネルが非表示になり、Cook Queueとログが2分割になる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo.rs | `src/bin/repo.rs` | TuiApp構造体（812-836行目）：TUI状態管理 |
| 1-2 | repo.rs | `src/bin/repo.rs` | RecipeStatus列挙型（772-780行目）：パッケージ状態 |
| 1-3 | repo.rs | `src/bin/repo.rs` | StatusUpdate列挙型（782-794行目）：スレッド間通信 |
| 1-4 | repo.rs | `src/bin/repo.rs` | FailurePrompt構造体（1754-1758行目）：エラーダイアログ |

**読解のコツ**: TuiAppがUI全体の状態を管理し、StatusUpdateでスレッド間の情報をやり取りする。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | TUIモード判定（194-203行目） |
| 2-2 | repo.rs | `src/bin/repo.rs` | run_tui_cook関数（1012-1501行目）：TUIメイン処理 |

**主要処理フロー**:
1. **1016-1017行目**: チャンネル作成（work_tx, status_tx）
2. **1023-1110行目**: Cookerスレッド
3. **1136-1218行目**: Fetcherスレッド
4. **1228-1488行目**: メインループ（UI描画とイベント処理）

#### Step 3: スレッド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo.rs | `src/bin/repo.rs` | Fetcherスレッド（1136-1218行目） |
| 3-2 | repo.rs | `src/bin/repo.rs` | Cookerスレッド（1023-1110行目） |
| 3-3 | repo.rs | `src/bin/repo.rs` | 入力イベントスレッド（1121-1129行目） |

#### Step 4: UI描画を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repo.rs | `src/bin/repo.rs` | レイアウト構築（1234-1243行目） |
| 4-2 | repo.rs | `src/bin/repo.rs` | Fetch Queueパネル（1247-1271行目） |
| 4-3 | repo.rs | `src/bin/repo.rs` | Cook Queueパネル（1274-1340行目） |
| 4-4 | repo.rs | `src/bin/repo.rs` | Logパネル（1356-1443行目） |
| 4-5 | repo.rs | `src/bin/repo.rs` | draw_prompt関数（1635-1707行目） |

#### Step 5: イベント処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | repo.rs | `src/bin/repo.rs` | handle_main_event関数（1517-1597行目） |
| 5-2 | repo.rs | `src/bin/repo.rs` | handle_prompt_input関数（1610-1633行目） |

### プログラム呼び出し階層図

```
main (repo.rs:174)
    │
    └─ main_inner (repo.rs:182)
           │
           └─ run_tui_cook (repo.rs:1012)
                  │
                  ├─ Fetcherスレッド (1136-1218)
                  │      ├─ handle_fetch
                  │      └─ StatusUpdate::Fetched/FailFetch送信
                  │
                  ├─ Cookerスレッド (1023-1110)
                  │      ├─ handle_cook
                  │      └─ StatusUpdate::Cooked/FailCook送信
                  │
                  └─ メインループ (1228-1488)
                         ├─ terminal.draw
                         │      ├─ Fetch Queue描画
                         │      ├─ Cook Queue描画
                         │      ├─ Log描画
                         │      └─ draw_prompt (エラー時)
                         │
                         ├─ app.update_status
                         └─ handle_main_event / handle_prompt_input
```

### データフロー図

```
[Fetcherスレッド]                    [メインスレッド]                    [Cookerスレッド]
       │                                   │                                   │
       │──StatusUpdate::StartFetch──────▶│                                   │
       │──StatusUpdate::Fetched─────────▶│                                   │
       │                                   │◀──StatusUpdate::StartCook────────│
       │                                   │◀──StatusUpdate::Cooked───────────│
       │                                   │                                   │
       │                             TuiApp状態更新                            │
       │                                   │                                   │
       │                             UI描画(ratatui)                           │
       │                                   │                                   │
       │                          キーボードイベント                            │
       │◀──────────prompting変更───────────│─────────prompting変更────────────▶│
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | TUIのメイン実装（全て） |
| pty.rs | `src/cook/pty.rs` | ソース | 擬似端末の管理 |
| config.rs | `src/config.rs` | ソース | TUI設定（cook.tui） |
