# 機能設計書 36-ビルドログ出力

## 概要

本ドキュメントは、cookbookシステムにおける`ビルドログ出力`機能の設計を記述する。この機能は、各パッケージのfetch/cookログを`build/logs/{target}/`以下にファイルとして自動保存する機能を提供する。

### 本機能の処理概要

ビルドログ出力機能は、パッケージのソース取得（fetch）とビルド（cook）の過程で出力されるログをファイルに自動保存する機能である。擬似端末（PTY）とパイプを使用して子プロセスの出力をキャプチャし、TUIやコンソールへの表示と同時にファイルに書き出す。

**業務上の目的・背景**：ビルド処理は長時間にわたることがあり、エラー発生時のトラブルシューティングや、ビルド結果の確認・監査のためにログを保存する必要がある。TUI表示だけではスクロールバックの限界があるため、完全なログをファイルとして残すことが重要である。CI/CDパイプラインでのビルド結果の保存・分析にも利用される。

**機能の利用シーン**：
- ビルドエラー発生時の原因調査
- ビルド成果物の品質監査
- CI/CDパイプラインでのビルドログ収集
- 過去のビルド履歴の確認

**主要な処理内容**：
1. PTY（擬似端末）のセットアップ
2. パイプを使用したログストリームの分岐
3. ログファイルの作成（build/logs/{target}/{package}.log）
4. リアルタイムでのログ書き込み
5. ビルド完了時のログファイルクローズ

**関連システム・外部連携**：
- PTY（擬似端末）：子プロセスの出力キャプチャ
- ファイルシステム：ログファイルの保存

**権限による制御**：本機能に特別な権限制御はないが、ログディレクトリへの書き込み権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | TUIメイン画面 | 補助機能 | TUIのLogパネルとビルドログファイルの連携 |

## 機能種別

ログ出力（ビルドプロセスログの永続化）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| 対象パッケージ | CookRecipe | Yes | ログ出力対象のパッケージ | 有効なレシピ |
| ターゲット | &'static str | Yes | ビルドターゲット（例：x86_64-unknown-redox） | 有効なターゲット文字列 |

### 入力データソース

- 子プロセス（fetch/cook）のstdout/stderr出力

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ログファイル | File | パッケージごとのビルドログファイル |

### 出力先

- `build/logs/{target}/{package_name}.log`

### 出力形式例

```
[2024-01-22 10:30:00] Starting fetch for package: kernel
Cloning into 'source'...
remote: Enumerating objects: 1234, done.
...
[2024-01-22 10:31:00] Fetch completed
[2024-01-22 10:31:01] Starting cook for package: kernel
   Compiling kernel v0.1.0
...
[2024-01-22 10:35:00] Cook completed
```

## 処理フロー

### 処理シーケンス

```
1. ログディレクトリの作成
   └─ build/logs/{target}/ を再帰的に作成

2. ログファイルのオープン
   └─ build/logs/{target}/{package}.log を書き込みモードでオープン

3. PTYとパイプのセットアップ
   ├─ setup_pty() でPTYペアを作成
   └─ パイプ（log_reader, log_writer）を作成

4. ログ読み込みスレッドの起動
   ├─ PTYリーダーからの読み込み
   ├─ パイプリーダーからの読み込み
   └─ ファイルへの書き込み

5. 子プロセスの実行
   └─ PTYをstdout/stderrとして子プロセスを起動

6. ログの収集と書き込み
   ├─ 子プロセス出力をリアルタイムで収集
   └─ ログファイルに書き込み

7. クリーンアップ
   └─ ファイルハンドルのクローズ
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ログディレクトリ作成]
    B --> C[ログファイルオープン]
    C --> D[PTYセットアップ]
    D --> E[パイプ作成]
    E --> F[ログ読み込みスレッド起動]
    F --> G[子プロセス起動]
    G --> H{出力あり?}
    H -->|Yes| I[PTY/パイプから読み込み]
    I --> J[ログファイルに書き込み]
    J --> K[TUI/コンソールに表示]
    K --> H
    H -->|No| L{プロセス終了?}
    L -->|No| H
    L -->|Yes| M[ファイルクローズ]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-36-1 | ログパス構造 | build/logs/{target}/{package}.logの形式 | 常時 |
| BR-36-2 | 上書きモード | 既存のログファイルは上書きされる | 同名ファイル存在時 |
| BR-36-3 | PTY出力キャプチャ | 子プロセスのstdout/stderrをPTY経由でキャプチャ | TUIモード時 |
| BR-36-4 | リアルタイム書き込み | ログは随時ファイルに書き込まれる | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ディレクトリ作成失敗 | 権限不足または親ディレクトリ不在 | 権限とパスを確認 |
| - | ファイルオープン失敗 | 権限不足またはディスク容量不足 | 権限と空き容量を確認 |
| - | 書き込み失敗 | ディスク容量不足 | ディスク空き容量を確保 |

### リトライ仕様

ログ書き込み失敗時のリトライはなし（ビルド処理自体は継続）

## トランザクション仕様

ログ書き込みにトランザクション制御なし（ストリーミング書き込み）

## パフォーマンス要件

- ログ書き込みがビルド処理のボトルネックにならないこと
- バッファリングによる効率的な書き込み
- 大量のログ出力でもUIがフリーズしないこと

## セキュリティ考慮事項

- ログファイルにセンシティブな情報（APIキー、パスワード等）が含まれる可能性がある
- ログファイルのアクセス権限管理が必要

## 備考

- TUIモードではログがLogパネルにも表示される
- log_to_pty!マクロを使用してPTYとパイプ両方に出力可能
- オプションパッケージの場合はサフィックス付きのログファイル名になる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pty.rs | `src/cook/pty.rs` | PtyOut型定義（32行目）：擬似端末とパイプのタプル |
| 1-2 | pty.rs | `src/cook/pty.rs` | UnixMasterPty/UnixSlavePty構造体（303-311行目） |

**読解のコツ**: `PtyOut`は`Option<(&mut UnixSlavePty, &mut PipeWriter)>`型で、ログ出力先を表す。

#### Step 2: PTYセットアップを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pty.rs | `src/cook/pty.rs` | setup_pty関数（34-57行目） |
| 2-2 | pty.rs | `src/cook/pty.rs` | openpty関数（111-153行目） |

**主要処理フロー**:
1. **41-48行目**: PTYペア（master/slave）の作成
2. **49-52行目**: masterからリーダーを取得
3. **54-55行目**: ログ用パイプの作成
4. **56行目**: slaveとlog_writerを返却

#### Step 3: ログ書き込みマクロを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pty.rs | `src/cook/pty.rs` | log_to_pty!マクロ（18-29行目） |

**主要処理フロー**:
- **22-25行目**: loggerがSomeの場合、パイプに書き込み
- **27行目**: loggerがNoneの場合、stderrに出力

#### Step 4: ログファイル作成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repo.rs | `src/bin/repo.rs` | ログファイルパス構築（1038-1050行目） |
| 4-2 | repo.rs | `src/bin/repo.rs` | ログディレクトリ作成（1042行目） |
| 4-3 | repo.rs | `src/bin/repo.rs` | ログファイルオープン（1046-1050行目） |

#### Step 5: ログ収集スレッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | repo.rs | `src/bin/repo.rs` | PTYリーダースレッド（1057-1081行目） |
| 5-2 | repo.rs | `src/bin/repo.rs` | パイプリーダースレッド（1083-1104行目） |

### プログラム呼び出し階層図

```
run_tui_cook (repo.rs:1012)
    │
    ├─ ログディレクトリ作成 (1042)
    │      └─ fs::create_dir_all
    │
    ├─ ログファイルオープン (1046-1050)
    │      └─ File::create
    │
    └─ Cookerスレッド (1023-1110)
           │
           ├─ setup_pty (pty.rs:34)
           │      ├─ openpty (pty.rs:111)
           │      └─ std::io::pipe
           │
           ├─ PTYリーダースレッド (1057-1081)
           │      └─ pty_reader.read → ログ収集
           │
           ├─ パイプリーダースレッド (1083-1104)
           │      └─ log_reader.read → ログ収集
           │
           └─ handle_cook
                  └─ log_to_pty! マクロでログ出力
```

### データフロー図

```
[子プロセス]              [PTY/パイプ]              [出力先]

stdout/stderr ───▶ UnixSlavePty ───▶ PTYリーダースレッド
                                          │
                                          ├───▶ ログファイル
                                          └───▶ TUI Logパネル

log_to_pty! ─────▶ PipeWriter ─────▶ パイプリーダースレッド
                                          │
                                          ├───▶ ログファイル
                                          └───▶ TUI Logパネル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pty.rs | `src/cook/pty.rs` | ソース | PTYセットアップとlog_to_pty!マクロ |
| repo.rs | `src/bin/repo.rs` | ソース | ログファイル作成とログ収集スレッド |
| fs.rs | `src/cook/fs.rs` | ソース | ファイルシステム操作ヘルパー |
| build/logs/{target}/ | ディレクトリ | 出力 | ログファイル保存先 |
