# 機能設計書 37-オフラインモード

## 概要

本ドキュメントは、cookbookシステムにおける`オフラインモード`機能の設計を記述する。この機能は、ネットワーク接続なしで既存のソースおよびパッケージを使用してビルドを行う機能を提供する。

### 本機能の処理概要

オフラインモードは、インターネット接続が利用できない環境で、既にダウンロード済みのソースコードやtarアーカイブを使用してパッケージのビルドを行う機能である。`--offline`オプションまたは`COOKBOOK_OFFLINE`環境変数で有効化される。

**業務上の目的・背景**：ビルド環境がネットワークに接続できない場合（セキュリティ要件、物理的制約、オフィス外での作業など）や、ネットワーク帯域を節約したい場合がある。事前にソースを取得しておけば、オフライン状態でもビルドを実行できることが望ましい。また、再現可能なビルドの観点からも、外部リソースに依存せずにビルドできることは重要である。

**機能の利用シーン**：
- ネットワーク接続のない環境でのビルド
- 飛行機内やオフィス外での開発作業
- ネットワーク帯域の節約
- 再現可能なビルドの実現
- CI/CDでのキャッシュ済みソースを使用した高速ビルド

**主要な処理内容**：
1. `--offline`オプションまたは`COOKBOOK_OFFLINE`環境変数の検出
2. fetch_offline関数による既存ソースの使用
3. git clone/fetchの代わりに既存のsourceディレクトリを確認
4. tarダウンロードの代わりに既存のsource.tarを確認
5. Cargo buildに`--offline`フラグを追加

**関連システム・外部連携**：
- Cargoビルドシステム：`--offline`フラグの伝播
- git：オフライン時は新規クローン/フェッチをスキップ

**権限による制御**：本機能に特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | 主機能 | --offlineオプションによるオフラインビルド |
| 5 | repo fetchコマンド画面 | 主機能 | 既存ソースのみを使用したfetch |

## 機能種別

ビルドモード（ネットワーク無効化モード）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --offline | bool | No | オフラインモードを有効化 | - |
| COOKBOOK_OFFLINE | 環境変数 | No | "1"でオフラインモードを有効化 | - |

### 入力データソース

- コマンドライン引数
- 環境変数
- 既存のソースディレクトリ
- 既存のtarアーカイブ

## 出力仕様

### 出力データ

通常のビルド出力と同じ

### 出力先

通常のビルド出力先と同じ

## 処理フロー

### 処理シーケンス

```
1. オフラインモードフラグの取得
   ├─ --offlineコマンドラインオプションを確認
   └─ COOKBOOK_OFFLINE環境変数を確認

2. fetch処理の分岐
   ├─ オフライン時：fetch_offline関数を使用
   └─ オンライン時：fetch関数を使用

3. fetch_offlineでの処理
   ├─ BuildKind::None → source_dirなしでOK
   ├─ BuildKind::Remote → オフラインfetch_remote
   ├─ SourceRecipe::Git → 既存source dirの確認
   └─ SourceRecipe::Tar → 既存source.tarの確認

4. Cargoビルド時
   └─ --offlineフラグを追加

5. ソースが存在しない場合
   └─ エラー終了（オフラインモードでは取得不可）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{--offline or COOKBOOK_OFFLINE?}
    B -->|No| C[通常fetch]
    B -->|Yes| D[fetch_offline]
    D --> E{BuildKind?}
    E -->|None| F[source不要、成功]
    E -->|Remote| G[offline fetch_remote]
    E -->|Git| H{source dir存在?}
    E -->|Tar| I{source.tar存在?}
    H -->|Yes| J[既存sourceを使用]
    H -->|No| K[エラー: オフラインで取得不可]
    I -->|Yes| L[tarから展開]
    I -->|No| M{source dir存在?}
    M -->|Yes| J
    M -->|No| K
    G --> N{pkgar存在?}
    N -->|Yes| O[成功]
    N -->|No| K
    J --> P[source_info.toml更新]
    L --> P
    F --> Q[cook処理へ]
    O --> Q
    P --> Q
    C --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-37-1 | フラグ優先 | --offlineと環境変数の両方で有効化可能 | オプションまたは環境変数設定時 |
| BR-37-2 | 既存ソース必須 | オフライン時は既存ソースがなければエラー | オフラインモード時 |
| BR-37-3 | Git確認 | Gitソースの場合、.gitディレクトリの存在確認 | SourceRecipe::Git時 |
| BR-37-4 | Tar展開 | 既存tarからの展開はblake3検証後に実行 | SourceRecipe::Tar時 |
| BR-37-5 | Cargo伝播 | Cargoビルドに--offlineを伝播 | BuildKind::Cargo時 |
| BR-37-6 | Remote取得 | リモートパッケージも既存ファイル必須 | BuildKind::Remote時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ソース不在 | オフラインでsourceディレクトリがない | オンラインでfetchを実行 |
| - | Tar不在 | オフラインでsource.tarがない | オンラインでfetchを実行 |
| - | pkgar不在 | オフラインでリモートパッケージがない | オンラインでfetchを実行 |

### リトライ仕様

オフラインモードでのリトライなし（ソースが存在しなければ即エラー）

## トランザクション仕様

トランザクション制御なし

## パフォーマンス要件

- オフラインモードはネットワークアクセスをスキップするため、fetch処理が高速化される
- 既存ソースの存在確認は即座に完了すること

## セキュリティ考慮事項

- blake3ハッシュ検証はオフラインでも実行される
- 信頼できるソースからのtarファイルのみ使用すること

## 備考

- 環境変数COOKBOOK_OFFLINEは"1"で有効化（空文字列は無効）
- Cargo依存関係もローカルキャッシュから解決される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config.rs | `src/config.rs` | CookConfig.offlineフィールド（89行目） |
| 1-2 | recipe.rs | `src/recipe.rs` | BuildKind列挙型（92-128行目）：ビルド種別 |
| 1-3 | recipe.rs | `src/recipe.rs` | SourceRecipe列挙型（20-67行目）：ソース種別 |

**読解のコツ**: `CookConfig.offline`がtrueの場合、fetch処理が`fetch_offline`に切り替わる。

#### Step 2: オフラインフラグの設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | --offlineオプション解析（392行目） |
| 2-2 | config.rs | `src/config.rs` | COOKBOOK_OFFLINE環境変数（91-92行目） |

**主要処理フロー**:
1. **392行目**: `conf.cook.offline = true;`
2. **91-92行目**: `std::env::var("COOKBOOK_OFFLINE").map(|s| s == "1").unwrap_or(false)`

#### Step 3: fetch_offline関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fetch.rs | `src/cook/fetch.rs` | fetch_offline関数（37-115行目） |
| 3-2 | fetch.rs | `src/cook/fetch.rs` | BuildKind::Noneの処理（41-45行目） |
| 3-3 | fetch.rs | `src/cook/fetch.rs` | BuildKind::Remoteの処理（46-49行目） |
| 3-4 | fetch.rs | `src/cook/fetch.rs` | Git/Tarソースの処理（53-109行目） |

**主要処理フロー**:
- **41-45行目**: BuildKind::Noneはsource不要
- **46-49行目**: fetch_remote with offline_mode=true
- **74-77行目**: Gitソースは既存.gitディレクトリを確認
- **83-108行目**: Tarソースはsource.tarまたはsource dirを確認

#### Step 4: オフラインチェック関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fs.rs | `src/cook/fs.rs` | offline_check_exists関数（268-276行目） |

**主要処理フロー**:
- **269-273行目**: パスが存在しなければエラーメッセージを返す

#### Step 5: Cargoへのフラグ伝播を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | script.rs | `src/cook/script.rs` | COOKBOOK_OFFLINEの使用（128-132行目） |

**主要処理フロー**:
- **128-132行目**: `if [ ! -z "${COOKBOOK_OFFLINE}" ] then build_flags+=" --offline"`

### プログラム呼び出し階層図

```
handle_cook (repo.rs)
    │
    ├─ config.offline確認
    │
    └─ {offline ? fetch_offline : fetch}
           │
           └─ fetch_offline (fetch.rs:37)
                  │
                  ├─ BuildKind::None → OK
                  │
                  ├─ BuildKind::Remote
                  │      └─ fetch_remote(offline_mode=true)
                  │             └─ offline_check_exists
                  │
                  ├─ SourceRecipe::Git
                  │      └─ offline_check_exists(source_dir)
                  │
                  └─ SourceRecipe::Tar
                         ├─ offline_check_exists(source.tar) [tarあり]
                         │      └─ blake3検証
                         │      └─ tar展開
                         │
                         └─ offline_check_exists(source_dir) [tarなし]
```

### データフロー図

```
[入力]                       [処理]                           [出力]

--offline / ENV ───────▶ CookConfig.offline設定
                                  │
                                  ▼
既存source dir ───────────▶ fetch_offline
既存source.tar                    │
                                  ▼
                         offline_check_exists
                                  │
                                  ├──▶ 成功: cook処理へ
                                  │
                                  └──▶ 失敗: エラー終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fetch.rs | `src/cook/fetch.rs` | ソース | fetch_offline関数 |
| fs.rs | `src/cook/fs.rs` | ソース | offline_check_exists関数 |
| config.rs | `src/config.rs` | ソース | CookConfig.offlineフィールド |
| script.rs | `src/cook/script.rs` | ソース | COOKBOOK_OFFLINEのCargoへの伝播 |
| repo.rs | `src/bin/repo.rs` | ソース | --offlineオプション解析 |
