# 機能設計書 38-ノンストップモード

## 概要

本ドキュメントは、cookbookシステムにおける`ノンストップモード`機能の設計を記述する。この機能は、ビルドエラー発生時もユーザー確認なしで処理を継続し、失敗したパッケージをスキップする機能を提供する。

### 本機能の処理概要

ノンストップモードは、fetch/cookコマンドの実行中にエラーが発生した場合でも、ユーザーに確認プロンプトを表示せずに自動的に次のパッケージの処理を継続するモードである。`--nonstop`オプションまたは`COOKBOOK_NONSTOP`環境変数で有効化される。

**業務上の目的・背景**：大量のパッケージを一括でビルドする場合、一部のパッケージのエラーで全体の処理が止まってしまうと非効率である。特にCI/CD環境では、エラーが発生しても可能な限り多くのパッケージのビルドを試行し、最後にまとめてエラーを報告することが望ましい。また、夜間バッチ処理など無人環境での実行時にも有効である。

**機能の利用シーン**：
- CI/CDパイプラインでの一括ビルド
- 夜間バッチでの自動ビルド
- 無人環境での長時間ビルド処理
- 大量のパッケージを一括でビルドする場合

**主要な処理内容**：
1. `--nonstop`オプションまたは`COOKBOOK_NONSTOP`環境変数の検出
2. エラー発生時のプロンプト表示スキップ
3. 失敗パッケージの記録
4. 次のパッケージへの自動継続
5. 最終結果でのエラーサマリー表示

**関連システム・外部連携**：
- TUIモード：プロンプト表示の制御
- コンソールモード：エラーメッセージの出力

**権限による制御**：本機能に特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | TUIメイン画面 | 補助機能 | プロンプト表示のスキップ |
| 2 | 失敗時プロンプトダイアログ | 関連機能 | ノンストップ時は表示しない |

## 機能種別

エラーハンドリングモード（自動継続モード）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --nonstop | bool | No | ノンストップモードを有効化 | - |
| COOKBOOK_NONSTOP | 環境変数 | No | "1"でノンストップモードを有効化 | - |

### 入力データソース

- コマンドライン引数
- 環境変数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 成功パッケージ | Vec<PackageName> | 成功したパッケージのリスト |
| 失敗パッケージ | Vec<(PackageName, Error)> | 失敗したパッケージとエラーのリスト |
| エラーサマリー | String | 最終的なエラー一覧 |

### 出力先

- 標準出力（成功/失敗メッセージ、サマリー）
- 標準エラー出力（エラー詳細）

## 処理フロー

### 処理シーケンス

```
1. ノンストップフラグの取得
   ├─ --nonstopコマンドラインオプションを確認
   └─ COOKBOOK_NONSTOP環境変数を確認

2. fetch/cook処理の実行
   └─ 各パッケージについてループ

3. エラー発生時の処理
   ├─ ノンストップ時：エラーを記録して次のパッケージへ
   └─ 通常時：プロンプト表示してユーザー入力待ち

4. TUIモードでの処理
   ├─ ノンストップ時：prompting変数をスキップ値(3)に自動設定
   └─ 通常時：FailurePrompt表示

5. 最終サマリー
   ├─ 成功/失敗カウントを表示
   └─ 失敗パッケージの一覧を表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{--nonstop or COOKBOOK_NONSTOP?}
    B --> C[nonstopフラグ設定]
    C --> D[パッケージ処理ループ]
    D --> E[fetch/cook実行]
    E --> F{エラー発生?}
    F -->|No| G[成功記録]
    F -->|Yes| H{nonstop?}
    H -->|Yes| I[エラー記録]
    I --> J[次のパッケージへ]
    H -->|No| K{TUIモード?}
    K -->|Yes| L[FailurePrompt表示]
    K -->|No| M[エラー終了]
    L --> N{ユーザー選択}
    N -->|Retry| E
    N -->|Skip| J
    N -->|Exit| M
    G --> O{次のパッケージあり?}
    J --> O
    O -->|Yes| D
    O -->|No| P[サマリー表示]
    P --> Q{失敗あり?}
    Q -->|Yes| R[エラーコード1で終了]
    Q -->|No| S[正常終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-38-1 | フラグ優先 | --nonstopと環境変数の両方で有効化可能 | オプションまたは環境変数設定時 |
| BR-38-2 | 自動スキップ | エラー時は自動的にSkip相当の動作 | ノンストップモード時 |
| BR-38-3 | プロンプト非表示 | TUIモードでもプロンプトを表示しない | ノンストップモード時 |
| BR-38-4 | エラー記録 | 失敗したパッケージとエラー理由を記録 | ノンストップモード時 |
| BR-38-5 | サマリー表示 | 処理完了時にエラーサマリーを表示 | ノンストップモード時かつエラーあり |
| BR-38-6 | 終了コード | 失敗があれば終了コード1 | ノンストップモード時かつエラーあり |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 部分失敗 | 一部のパッケージがエラー | サマリーでエラー内容を確認 |

### リトライ仕様

ノンストップモードでは自動リトライなし（常にスキップ）

## トランザクション仕様

トランザクション制御なし

## パフォーマンス要件

- エラー発生時の継続処理は即座に行われること
- エラー記録によるオーバーヘッドは最小限に抑えること

## セキュリティ考慮事項

- 特別なセキュリティ考慮は不要
- エラーログにセンシティブ情報が含まれる可能性に注意

## 備考

- CI環境変数が設定されている場合、TUIは自動的に無効化される
- ノンストップモードはCI/CDでの使用を想定した機能
- prompting変数の値3がSkip相当

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config.rs | `src/config.rs` | CookConfig.nonstopフィールド（90行目） |
| 1-2 | repo.rs | `src/bin/repo.rs` | prompting変数（1758-1766行目）：プロンプト状態管理 |

**読解のコツ**: `CookConfig.nonstop`がtrueの場合、エラー時のプロンプト表示がスキップされる。

#### Step 2: ノンストップフラグの設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | --nonstopオプション解析（391行目） |
| 2-2 | config.rs | `src/config.rs` | COOKBOOK_NONSTOP環境変数（93-94行目） |

**主要処理フロー**:
1. **391行目**: `conf.cook.nonstop = true;`
2. **93-94行目**: `std::env::var("COOKBOOK_NONSTOP").map(|s| s == "1").unwrap_or(false)`

#### Step 3: エラー時の処理分岐を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo.rs | `src/bin/repo.rs` | TUIモードでのノンストップ処理（1459-1462行目） |
| 3-2 | repo.rs | `src/bin/repo.rs` | コンソールモードでのノンストップ処理（627-632行目） |

**主要処理フロー**:
- **1459-1462行目**: nonstop時は`prompting = 3`（Skip）に自動設定
- **627-632行目**: nonstop時はprint_failedを呼び出して継続

#### Step 4: プロンプト状態管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repo.rs | `src/bin/repo.rs` | prompting値の意味（1746-1752行目） |
| 4-2 | repo.rs | `src/bin/repo.rs` | PromptOption列挙型 |

**prompting値**:
- 0: プロンプトなし（通常状態）
- 1: プロンプト表示中
- 2: Retry選択
- 3: Skip選択
- 4: Exit選択

#### Step 5: サマリー出力を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | repo.rs | `src/bin/repo.rs` | 失敗カウントの計算（253-262行目） |
| 5-2 | repo.rs | `src/bin/repo.rs` | サマリー出力（268-280行目） |

### プログラム呼び出し階層図

```
main_inner (repo.rs:182)
    │
    ├─ config.nonstop確認
    │
    └─ {TUI ? run_tui_cook : repo_inner}
           │
           ├─ [TUIモード] run_tui_cook
           │      │
           │      └─ エラー発生時
           │             ├─ nonstop=true: prompting=3(Skip)
           │             └─ nonstop=false: FailurePrompt表示
           │
           └─ [コンソールモード] repo_inner
                  │
                  └─ エラー発生時
                         ├─ nonstop=true: print_failed → continue
                         └─ nonstop=false: エラー終了
```

### データフロー図

```
[入力]                       [処理]                           [出力]

--nonstop / ENV ───────▶ CookConfig.nonstop設定
                                  │
                                  ▼
fetch/cookエラー ─────────▶ ノンストップ判定
                                  │
                         ┌───────┴───────┐
                         │               │
                    nonstop=true    nonstop=false
                         │               │
                         ▼               ▼
                  エラー記録・Skip   プロンプト表示
                         │               │
                         └───────┬───────┘
                                 │
                                 ▼
                          サマリー表示 ───▶ 終了コード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| config.rs | `src/config.rs` | ソース | CookConfig.nonstopフィールド |
| repo.rs | `src/bin/repo.rs` | ソース | ノンストップ処理のメインロジック |
