# 機能設計書 39-cookbook.toml読み込み

## 概要

本ドキュメントは、cookbookシステムにおける`cookbook.toml読み込み`機能の設計を記述する。この機能は、プロジェクトルートのcookbook.tomlファイルを読み込み、グローバル設定を取得する機能を提供する。

### 本機能の処理概要

cookbook.toml読み込み機能は、プロジェクトルートディレクトリに配置されたcookbook.toml設定ファイルを解析し、ビルド設定、TUI設定、ミラーURL設定などのグローバルな設定を取得する機能である。

**業務上の目的・背景**：cookbookシステムには多くの設定項目があり、コマンドラインオプションだけで指定するのは煩雑である。cookbook.tomlファイルにデフォルト設定を記述しておくことで、繰り返し使用する設定を省略でき、プロジェクト固有の設定を管理しやすくなる。また、チーム内での設定共有やCI/CD環境での一貫した設定にも役立つ。

**機能の利用シーン**：
- プロジェクト固有のデフォルト設定を行う場合
- ミラーURLの設定を行う場合
- TUIモードのデフォルト設定を変更する場合
- verboseモードのデフォルト設定を行う場合
- 並列ジョブ数のデフォルト値を設定する場合

**主要な処理内容**：
1. cookbook.tomlファイルの読み込み
2. TOMLパース（tomlクレート使用）
3. CookbookConfig構造体へのデシリアライズ
4. デフォルト値のマージ
5. グローバル設定への反映

**関連システム・外部連携**：
- tomlクレート：TOML形式のパース
- serdeクレート：デシリアライズ

**権限による制御**：本機能に特別な権限制御はないが、cookbook.tomlファイルへの読み取り権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | コマンドラインオプションより前に読み込まれる設定 |

## 機能種別

設定管理（設定ファイル読み込み）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --cookbook | PathBuf | No | cookbook.tomlを含むディレクトリ | 有効なディレクトリパス |

### 入力データソース

- cookbook.tomlファイル（デフォルト：作業ディレクトリのcookbook.toml）

### 設定ファイル形式

```toml
[mirrors]
# GitURLの書き換えルール
"https://github.com/" = "https://my-mirror.com/github/"
"https://gitlab.com/" = "https://my-mirror.com/gitlab/"

[cook]
# ビルド設定
verbose = true
tui = true
nonstop = false
offline = false
jobs = 8
```

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CookbookConfig | 構造体 | パース済みの設定データ |

### 出力先

グローバル設定変数（CONFIG）

## 処理フロー

### 処理シーケンス

```
1. cookbook.tomlのパス解決
   ├─ --cookbookオプションが指定されていればそのパス
   └─ 未指定なら現在の作業ディレクトリ

2. ファイル読み込み
   └─ fs::read_to_string で内容を読み込み

3. TOMLパース
   └─ toml::from_str でCookbookConfigにデシリアライズ

4. デフォルト値の適用
   └─ #[serde(default)] によるデフォルト値の補完

5. グローバル設定への反映
   └─ CONFIG変数に格納
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[cookbook.tomlパス解決]
    B --> C{ファイル存在?}
    C -->|No| D[デフォルト設定を使用]
    C -->|Yes| E[ファイル読み込み]
    E --> F{読み込み成功?}
    F -->|No| G[エラー終了]
    F -->|Yes| H[TOMLパース]
    H --> I{パース成功?}
    I -->|No| G
    I -->|Yes| J[デフォルト値マージ]
    J --> K[CONFIG変数に格納]
    D --> K
    K --> L[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-39-1 | ファイル任意 | cookbook.tomlファイルは必須ではない | 常時 |
| BR-39-2 | デフォルト値 | 未指定の項目はデフォルト値を使用 | ファイル存在時 |
| BR-39-3 | コマンドライン優先 | コマンドラインオプションは設定ファイルを上書き | オプション指定時 |
| BR-39-4 | mirrors完全一致 | ミラー設定はURL前方一致で置換 | mirrors設定あり時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル読み込み失敗 | 権限不足 | 権限を確認 |
| - | パースエラー | TOML形式が不正 | 設定ファイルの形式を確認 |

### リトライ仕様

リトライなし

## トランザクション仕様

トランザクション制御なし（読み取り専用）

## パフォーマンス要件

- 設定ファイルの読み込みは起動時に1回のみ
- パース処理は即座に完了すること

## セキュリティ考慮事項

- 設定ファイルのパスはユーザーが指定できるため、任意のファイルが読み取られる可能性
- 信頼できない設定ファイルの使用には注意

## 備考

- cookbook.tomlが存在しない場合はデフォルト設定が使用される
- 環境変数による設定はcookbook.tomlより優先される
- OnceLockを使用して設定の読み込みは1回のみ

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config.rs | `src/config.rs` | CookbookConfig構造体（66-68行目） |
| 1-2 | config.rs | `src/config.rs` | MirrorsConfig型（40行目）：HashMap<String, String> |
| 1-3 | config.rs | `src/config.rs` | CookConfig構造体（79-96行目） |

**読解のコツ**: `CookbookConfig`は`mirrors`と`cook`の2つのセクションを持つ。

#### Step 2: 設定読み込み処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | config.rs | `src/config.rs` | get_config関数（43-49行目） |
| 2-2 | config.rs | `src/config.rs` | init_config関数（51-64行目） |

**主要処理フロー**:
1. **43行目**: `CONFIG.get_or_init(init_config)` - 初回呼び出し時のみ初期化
2. **53-55行目**: `cookbook.toml`パスの構築
3. **56行目**: `fs::read_to_string`でファイル読み込み
4. **57行目**: `toml::from_str`でパース

#### Step 3: デフォルト値を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | config.rs | `src/config.rs` | CookConfig::default実装（98-110行目） |
| 3-2 | config.rs | `src/config.rs` | 各フィールドのデフォルト値関数（112-148行目） |

**主要デフォルト値**:
- **tui**: CI環境でなければtrue（119-121行目）
- **jobs**: CPUコア数（140-147行目）
- **verbose**: false
- **nonstop**: COOKBOOK_NONSTOP環境変数
- **offline**: COOKBOOK_OFFLINE環境変数

#### Step 4: グローバル変数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | config.rs | `src/config.rs` | CONFIG静的変数（37行目）：OnceLock<CookbookConfig> |

### プログラム呼び出し階層図

```
get_config (config.rs:43)
    │
    └─ CONFIG.get_or_init(init_config)
           │
           └─ init_config (config.rs:51)
                  │
                  ├─ std::env::var("COOKBOOK_PATH")
                  │
                  ├─ fs::read_to_string("cookbook.toml")
                  │
                  └─ toml::from_str::<CookbookConfig>
                         │
                         └─ serde deserialize
                                │
                                └─ CookConfig::default (補完)
```

### データフロー図

```
[入力]                       [処理]                           [出力]

cookbook.toml ─────────▶ fs::read_to_string ───▶ String (TOML)
                                                     │
                                                     ▼
                                               toml::from_str
                                                     │
                                                     ▼
環境変数 ──────────────────────────────────────▶ CookConfig::default
(COOKBOOK_NONSTOP,                                   │
 COOKBOOK_OFFLINE,                                   ▼
 CI)                                           CookbookConfig
                                                     │
                                                     ▼
                                               CONFIG (OnceLock)
                                                     │
                                                     ▼
                                               get_config() で取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| config.rs | `src/config.rs` | ソース | 設定ファイル読み込みと設定構造体 |
| cookbook.toml | プロジェクトルート | 設定 | グローバル設定ファイル |
