# 機能設計書 51-ターゲット判定

## 概要

本ドキュメントは、Cookbookビルドシステムにおけるターゲット判定機能の設計を記述する。パッケージ名からビルドターゲット（Redox OS向けまたはホストOS向け）を判定し、適切なクロスコンパイル環境を選択する機能を定義する。

### 本機能の処理概要

**業務上の目的・背景**：Redox OSのビルドシステムでは、Redox OS向けのパッケージとホストOS（Linux/macOS等）向けのツールチェインパッケージを同一のビルドシステムで管理する必要がある。ターゲット判定機能は、パッケージ名の命名規則に基づいてビルドターゲットを自動的に判定し、適切なコンパイラ設定やsysroot構築を行うための基盤となる重要な機能である。

**機能の利用シーン**：この機能は以下の場面で利用される。
- `repo cook`コマンドでレシピをビルドする際に、ターゲットプラットフォームを決定
- sysrootディレクトリの構築時に、ホスト依存関係とターゲット依存関係を分離
- toolchainディレクトリの構築時に、ホストツールを適切な場所に配置
- cookbook_redoxerコマンド実行時に、クロスコンパイル環境の設定を決定

**主要な処理内容**：
1. パッケージ名からホストパッケージかどうかを判定（`is_host()`メソッド）
2. ホストパッケージの場合は`redoxer::host_target()`でホストターゲットを返却
3. 通常パッケージの場合は`redoxer::target()`でRedoxターゲットを返却

**関連システム・外部連携**：
- redoxerライブラリ：ターゲット文字列（`x86_64-unknown-redox`等）の取得
- pkgライブラリ：PackageName構造体によるパッケージ名のパース

**権限による制御**：本機能は権限による制御を行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | 主画面 | ビルド時のターゲット判定 |
| 11 | cookbook_redoxerコマンド画面 | API連携 | パッケージ名からビルドターゲットの判定 |

## 機能種別

判定処理 / データ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | &PackageName | Yes | パッケージ名オブジェクト | PackageName型として有効であること |

### 入力データソース

- パッケージ名（CookRecipe構造体から取得）
- ホストパッケージは`host_`プレフィックスまたは`.host`サフィックスで識別

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| target | &'static str | ターゲット文字列（例：`x86_64-unknown-redox`, `x86_64-unknown-linux-gnu`） |

### 出力先

- 呼び出し元への戻り値として返却
- ビルドスクリプトのTARGET環境変数として設定

## 処理フロー

### 処理シーケンス

```
1. パッケージ名を受け取る
   └─ PackageName構造体として入力
2. ホストパッケージ判定を実行
   └─ name.is_host()メソッドでホストパッケージかどうかを確認
3. ターゲット文字列を返却
   ├─ ホストパッケージの場合：redoxer::host_target()を返却
   └─ 通常パッケージの場合：redoxer::target()を返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{name.is_host()?}
    B -->|Yes| C[redoxer::host_target()]
    B -->|No| D[redoxer::target()]
    C --> E[ターゲット文字列を返却]
    D --> E
    E --> F[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-51-1 | ホストパッケージ判定 | パッケージ名がホストパッケージ規則に合致する場合、ホストターゲットを使用 | `is_host()`がtrueを返す場合 |
| BR-51-2 | デフォルトターゲット | ホストパッケージでない場合はRedoxターゲットを使用 | `is_host()`がfalseを返す場合 |

### 計算ロジック

ターゲット文字列の例：
- Redoxターゲット：`x86_64-unknown-redox`, `aarch64-unknown-redox`, `i586-unknown-redox`
- ホストターゲット：`x86_64-unknown-linux-gnu`, `aarch64-apple-darwin`

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | なし | 本機能はエラーを発生させない | - |

### リトライ仕様

リトライ処理は不要。

## トランザクション仕様

トランザクション管理は行わない（メモリ上の判定処理のみ）。

## パフォーマンス要件

- 即時応答（ミリ秒以下）
- 判定処理は静的な文字列比較のみで構成

## セキュリティ考慮事項

本機能にセキュリティ上の考慮事項は存在しない。

## 備考

- パッケージ名の命名規則はpkgライブラリのPackageName構造体で定義されている
- ターゲット文字列はredoxerライブラリによって環境から自動検出される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パッケージ名の構造とホスト判定の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PackageName | `pkg`クレート（外部依存） | `is_host()`メソッドの実装を確認 |

**読解のコツ**: PackageNameはpkgクレートで定義される外部型。ホストパッケージは`host_`プレフィックスまたは`.host`サフィックスで識別される。

#### Step 2: エントリーポイントを理解する

ターゲット判定関数の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | package.rs | `src/cook/package.rs` | package_target関数の実装 |

**主要処理フロー**:
1. **192-198行目**: `package_target`関数の定義
2. **193-194行目**: ホストパッケージの場合`redoxer::host_target()`を返却
3. **195-197行目**: 通常パッケージの場合`redoxer::target()`を返却

#### Step 3: 呼び出し元を理解する

ターゲット判定が使用される場所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | ビルド時のTARGET環境変数設定 |
| 3-2 | recipe.rs | `src/recipe.rs` | CookRecipe構造体でのtargetフィールド設定 |

**主要処理フロー**:
- **cook_build.rs 394行目**: `command.env("TARGET", package_target(name))`でビルドスクリプトにターゲットを渡す
- **recipe.rs 229行目**: CookRecipe::newでtargetフィールドを設定

### プログラム呼び出し階層図

```
CookRecipe::new / build()
    │
    └─ package_target(&name)
           │
           ├─ name.is_host() → true
           │      └─ redoxer::host_target()
           │
           └─ name.is_host() → false
                  └─ redoxer::target()
```

### データフロー図

```
[入力]                  [処理]                      [出力]

PackageName ───▶ package_target() ───▶ ターゲット文字列
                       │                ("x86_64-unknown-redox"等)
                       │
                       ▼
                 is_host()判定
                       │
              ┌────────┴────────┐
              ▼                 ▼
       host_target()      target()
       (ホストOS)         (Redox)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| package.rs | `src/cook/package.rs` | ソース | package_target関数の定義 |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | ターゲット判定の呼び出し元（ビルド処理） |
| recipe.rs | `src/recipe.rs` | ソース | CookRecipe構造体でのtarget設定 |
| redoxer | 外部クレート | ライブラリ | target()/host_target()関数の提供 |
| pkg | 外部クレート | ライブラリ | PackageName構造体の定義 |
