# 機能設計書 52-cookbook_redoxer

## 概要

本ドキュメントは、Cookbookビルドシステムにおけるcookbook_redoxer機能の設計を記述する。cookbook_redoxerは、Redox OS向けのクロスコンパイル環境でコマンドを実行するためのラッパーバイナリであり、redoxerライブラリを利用してRedoxターゲット向けのビルドを実現する。

### 本機能の処理概要

**業務上の目的・背景**：Redox OSはLinuxやmacOSとは異なるOSであるため、ホストOS上でRedox OS向けのバイナリをビルドするにはクロスコンパイル環境が必要となる。cookbook_redoxerは、redoxerライブラリをCookbookビルドシステムに統合し、シェルスクリプトから簡単にクロスコンパイルコマンドを実行できるようにするラッパーである。これにより、cargo、cmake、meson等のビルドツールをRedoxターゲット向けに透過的に実行可能となる。

**機能の利用シーン**：この機能は以下の場面で利用される。
- `repo cook`コマンドでCargoテンプレートのレシピをビルドする際
- カスタムビルドスクリプトでRedox向けコマンドを実行する際
- `write-exec`サブコマンドでステージディレクトリにバイナリを書き込む際

**主要な処理内容**：
1. コマンドライン引数を受け取り、redoxer用に変換
2. `write-exec`サブコマンドの場合、COOKBOOK_STAGE環境変数からステージディレクトリを取得
3. `--root`と`--folder`フラグを追加してredoxerに渡す
4. redoxer::main()を呼び出してクロスコンパイルコマンドを実行

**関連システム・外部連携**：
- redoxerライブラリ：クロスコンパイル環境の提供とコマンド実行
- COOKBOOK_STAGE環境変数：ステージディレクトリのパス

**権限による制御**：本機能は権限による制御を行わない。実行にはクロスコンパイルツールチェインが必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | ビルドスクリプトからの呼び出し |
| 11 | cookbook_redoxerコマンド画面 | 主機能 | Redox向けクロスコンパイル環境でのコマンド実行 |

## 機能種別

コマンド実行 / クロスコンパイル環境管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| args | Vec<String> | Yes | コマンドライン引数 | 最低1つの引数が必要 |
| COOKBOOK_STAGE | 環境変数 | No | ステージディレクトリのパス | write-exec時に使用 |

### 入力データソース

- コマンドライン引数（env::args()経由）
- 環境変数COOKBOOK_STAGE

### サブコマンド

| サブコマンド | 説明 |
|-------------|------|
| env | 環境変数を設定してコマンドを実行 |
| write-exec | ステージディレクトリにバイナリを書き込んで実行 |
| install | Cargoパッケージをインストール |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 終了コード | i32 | redoxerコマンドの終了コード |
| 標準出力 | テキスト | 実行コマンドの標準出力 |
| 標準エラー | テキスト | 実行コマンドの標準エラー |

### 出力先

- 標準出力/標準エラー
- ステージディレクトリ（write-exec時）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数を取得
   └─ env::args().collect()
2. 引数の数を確認
   └─ args.len() >= 2の場合、フラグ分離用に"--"を挿入
3. write-execサブコマンドの処理
   ├─ COOKBOOK_STAGE環境変数を取得
   ├─ --rootフラグにステージディレクトリを設定
   └─ --folderフラグにステージディレクトリ/rootを設定
4. redoxer::main()を呼び出し
   └─ 変換済み引数を渡してクロスコンパイルコマンドを実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コマンドライン引数取得]
    B --> C{args.len >= 2?}
    C -->|Yes| D["'--'を引数に挿入"]
    C -->|No| G[redoxer::main呼び出し]
    D --> E{args[1] == 'write-exec'?}
    E -->|Yes| F[COOKBOOK_STAGE取得]
    E -->|No| G
    F --> H{COOKBOOK_STAGEあり?}
    H -->|Yes| I["--root, --folderフラグ追加"]
    H -->|No| G
    I --> G
    G --> J[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-52-1 | フラグ分離 | コマンドに渡すフラグとredoxerフラグを"--"で分離 | 引数が2つ以上ある場合 |
| BR-52-2 | ステージディレクトリ設定 | write-exec時にステージディレクトリを--rootと--folderで指定 | write-execサブコマンド時 |
| BR-52-3 | rootサブディレクトリ | --folderには{stage_dir}/rootを指定 | COOKBOOK_STAGEが設定されている場合 |

### 計算ロジック

引数変換ロジック（write-execの場合）：
```
入力: ["cookbook_redoxer", "write-exec", "arg1", "arg2"]
出力: ["cookbook_redoxer", "write-exec", "--root", "{stage_dir}", "--folder", "{stage_dir}/root", "--", "arg1", "arg2"]
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 環境変数未設定 | COOKBOOK_STAGEが未設定でwrite-exec実行 | フラグなしで続行 |
| - | redoxerエラー | redoxer内部でエラー発生 | redoxerの終了コードを返却 |

### リトライ仕様

本機能はリトライを行わない。ビルドスクリプト側でリトライ制御。

## トランザクション仕様

トランザクション管理は行わない。

## パフォーマンス要件

- 起動オーバーヘッドは最小限
- 実際の処理時間はredoxerおよび実行するコマンドに依存

## セキュリティ考慮事項

- ステージディレクトリのパスは環境変数経由で受け取るため、不正なパスが設定される可能性がある
- redoxerは信頼されたコマンドのみを実行すべき

## 備考

- cookbook_redoxerはCargo.tomlでバイナリターゲットとして定義されている
- redoxerライブラリはRedox OSプロジェクトが提供するクロスコンパイルツール

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本機能は単純なコマンドラッパーであり、主要なデータ構造は引数のVec<String>のみ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cookbook_redoxer.rs | `src/bin/cookbook_redoxer.rs` | 引数の変換ロジックを確認 |

**読解のコツ**: Rustのコマンドライン引数処理とVec操作（insertメソッド）を理解しておくと読みやすい。

#### Step 2: エントリーポイントを理解する

main関数が全ての処理を行う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cookbook_redoxer.rs | `src/bin/cookbook_redoxer.rs` | main関数の全体フロー |

**主要処理フロー**:
1. **4行目**: `env::args().collect()`で引数を取得
2. **6-7行目**: 引数が2つ以上ある場合、インデックス2に"--"を挿入
3. **8-14行目**: write-execの場合、COOKBOOK_STAGEから--rootと--folderを設定
4. **17行目**: `redoxer::main(&args)`でredoxerを呼び出し

#### Step 3: 呼び出し元を理解する

ビルドスクリプトからどのように呼び出されるかを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | COOKBOOK_REDOXER環境変数の設定 |
| 3-2 | script.rs | `src/cook/script.rs` | COOKBOOK_CARGO変数としての使用 |

**主要処理フロー**:
- **cook_build.rs 385-391行目**: cookbook_redoxerバイナリのパスを取得し、コマンドを構築
- **script.rs 135-143行目**: `COOKBOOK_CARGO="${COOKBOOK_REDOXER}"`でcookbook_cargoコマンドがcookbook_redoxerを使用

### プログラム呼び出し階層図

```
repo cook
    │
    └─ build() [cook_build.rs]
           │
           ├─ Command::new(&cookbook_redoxer)
           │      └─ cookbook_redoxer [src/bin/cookbook_redoxer.rs]
           │             │
           │             └─ redoxer::main(&args)
           │
           └─ ビルドスクリプト実行
                  └─ ${COOKBOOK_CARGO} install (= cookbook_redoxer install)
                         │
                         └─ redoxer::main(&args)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

コマンドライン引数 ───▶ main()
                         │
                         ▼
                    引数変換処理
                         │
     COOKBOOK_STAGE ────▶├─ write-exec判定
                         │    └─ --root/--folder追加
                         │
                         ▼
                    redoxer::main()  ───▶ クロスコンパイル実行
                                                    │
                                          ステージディレクトリ
                                          標準出力/エラー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cookbook_redoxer.rs | `src/bin/cookbook_redoxer.rs` | ソース | メインバイナリの実装 |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | cookbook_redoxerの呼び出し元 |
| script.rs | `src/cook/script.rs` | ソース | COOKBOOK_CARGOとしての使用定義 |
| Cargo.toml | `Cargo.toml` | 設定 | バイナリターゲットの定義 |
| redoxer | 外部クレート | ライブラリ | クロスコンパイル機能の実装 |
