# 機能設計書 53-動的/静的リンク切替

## 概要

本ドキュメントは、Cookbookビルドシステムにおける動的/静的リンク切替機能の設計を記述する。DYNAMIC_INIT関数を通じて、ビルドを動的リンクモードに切り替え、共有ライブラリを使用するビルド設定を自動的に適用する機能を定義する。

### 本機能の処理概要

**業務上の目的・背景**：Redox OSでは、パッケージサイズの削減とライブラリの共有を目的として、動的リンクによるビルドをサポートしている。しかし、全てのターゲットアーキテクチャが動的リンクをサポートしているわけではなく（i586やriscv64gcは非対応）、また静的リンクがデフォルトとして設定されている。DYNAMIC_INIT関数は、レシピのビルドスクリプトから呼び出すことで、各ビルドシステム（autotools、CMake、Meson）に対して動的リンク用のフラグを自動的に設定する。

**機能の利用シーン**：この機能は以下の場面で利用される。
- 共有ライブラリとしてビルドする必要があるライブラリパッケージのビルド時
- 動的リンクされたバイナリを生成する際
- パッケージサイズを削減したい場合

**主要な処理内容**：
1. ターゲットアーキテクチャの動的リンクサポートを確認
2. 動的リンク非対応の場合は警告を出力して終了
3. COOKBOOK_CONFIGURE_FLAGSに動的リンク用フラグを設定
4. COOKBOOK_CMAKE_FLAGSにCMake用動的リンクフラグを設定
5. COOKBOOK_MESON_FLAGSにMeson用動的リンクフラグを設定
6. LDFLAGS、RUSTFLAGS、COOKBOOK_DYNAMIC環境変数を設定

**関連システム・外部連携**：
- autotools（configure）：--enable-shared、--disable-staticフラグ
- CMake：BUILD_SHARED_LIBS、ENABLE_SHAREDフラグ
- Meson：default_library=sharedオプション
- Rust/Cargo：-C target-feature=-crt-static

**権限による制御**：本機能は権限による制御を行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | ビルドスクリプトからのDYNAMIC_INIT呼び出し |
| 11 | cookbook_redoxerコマンド画面 | 補助機能 | DYNAMIC_INIT関数での動的リンク設定適用 |

## 機能種別

設定処理 / 環境変数管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TARGET | 環境変数 | Yes | ビルドターゲット文字列 | i586-unknown-redox等のターゲット形式 |
| GNU_TARGET | 環境変数 | Yes | GNU形式のターゲット文字列 | クロスコンパイラのプレフィックス |
| COOKBOOK_SYSROOT | 環境変数 | Yes | sysrootディレクトリのパス | 有効なディレクトリパス |
| COOKBOOK_HOST_SYSROOT | 環境変数 | No | ホストsysrootのパス | autoreconf時に使用 |

### 入力データソース

- 環境変数（cook_build.rsで設定）
- レシピのビルドスクリプト（DYNAMIC_INIT呼び出し）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| COOKBOOK_CONFIGURE_FLAGS | Bash配列 | autotools用フラグ |
| COOKBOOK_CMAKE_FLAGS | Bash配列 | CMake用フラグ |
| COOKBOOK_MESON_FLAGS | Bash配列 | Meson用フラグ |
| LDFLAGS | 環境変数 | リンカフラグ |
| RUSTFLAGS | 環境変数 | Rustコンパイラフラグ |
| COOKBOOK_DYNAMIC | 環境変数 | 動的リンクモードフラグ |

### 出力先

- シェル変数（ビルドスクリプト内）
- 環境変数

## 処理フロー

### 処理シーケンス

```
1. DYNAMIC_INIT関数が呼び出される
   └─ レシピのビルドスクリプトから呼び出し
2. autoreconf関数を定義
   └─ autotools_recursive_regenerate関数として定義
3. ターゲットアーキテクチャを確認
   ├─ i586-unknown-redox：動的リンク非対応、警告出力して終了
   └─ riscv64gc-unknown-redox：動的リンク非対応、警告出力して終了
4. 動的リンクモードメッセージを出力（verbose時）
5. COOKBOOK_CONFIGURE_FLAGSを設定
   └─ --enable-shared、--disable-static
6. COOKBOOK_CMAKE_FLAGSを設定
   └─ BUILD_SHARED_LIBS=True、ENABLE_SHARED=True
7. COOKBOOK_MESON_FLAGSを設定
   └─ -Ddefault_library=shared
8. LDFLAGS、RUSTFLAGS、COOKBOOK_DYNAMICを設定
```

### フローチャート

```mermaid
flowchart TD
    A[DYNAMIC_INIT開始] --> B[autotools_recursive_regenerate定義]
    B --> C{TARGET判定}
    C -->|i586/riscv64gc| D[警告出力]
    D --> E[return - 静的リンクのまま]
    C -->|その他| F[動的リンクモード有効]
    F --> G[COOKBOOK_CONFIGURE_FLAGS設定]
    G --> H[COOKBOOK_CMAKE_FLAGS設定]
    H --> I[COOKBOOK_MESON_FLAGS設定]
    I --> J[LDFLAGS設定]
    J --> K[RUSTFLAGS設定]
    K --> L[COOKBOOK_DYNAMIC=1]
    L --> M[終了]
    E --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-53-1 | i586動的リンク非対応 | i586-unknown-redoxは動的リンクをサポートしない | TARGET=i586-unknown-redox |
| BR-53-2 | riscv64gc動的リンク非対応 | riscv64gc-unknown-redoxは動的リンクをサポートしない | TARGET=riscv64gc-unknown-redox |
| BR-53-3 | デフォルト静的リンク | DYNAMIC_INIT未呼び出し時は静的リンク | DYNAMIC_INIT未実行 |
| BR-53-4 | autoreconf対応 | autoreconfでaclocal設定を使用 | autotools_recursive_regenerate呼び出し時 |

### 計算ロジック

フラグ設定値：

**autotools (configure)**:
```bash
COOKBOOK_CONFIGURE_FLAGS=(
    --host="${GNU_TARGET}"
    --prefix="/usr"
    --enable-shared
    --disable-static
)
```

**CMake**:
```bash
COOKBOOK_CMAKE_FLAGS=(
    -DBUILD_SHARED_LIBS=True
    -DENABLE_SHARED=True
    -DENABLE_STATIC=False
)
```

**Meson**:
```bash
COOKBOOK_MESON_FLAGS=(
    --buildtype release
    --wrap-mode nofallback
    --strip
    -Ddefault_library=shared
    -Dprefix=/usr
)
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | 動的リンク非対応ターゲット | 警告出力後、静的リンクで続行 |

### リトライ仕様

リトライ処理は不要（設定処理のみ）。

## トランザクション仕様

トランザクション管理は行わない。

## パフォーマンス要件

- 即時完了（シェル変数設定のみ）

## セキュリティ考慮事項

- 動的リンクライブラリのロードパス設定（LDFLAGS）が適切であることを確認する必要がある
- rpath-linkの設定はsysrootディレクトリに限定

## 備考

- DYNAMIC_STATIC_INIT関数も提供されており、動的・静的の両方をビルドする場合に使用
- COOKBOOK_VERBOSE環境変数が設定されている場合、デバッグメッセージが出力される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

シェルスクリプトの配列変数と環境変数の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | script.rs | `src/cook/script.rs` | SHARED_PRESCRIPTとBUILD_PRESCRIPTの定義 |

**読解のコツ**: Rustの生文字列リテラル（`r#"..."#`）で定義されたBashスクリプトを読み解く。配列変数`()`とexport文に注目。

#### Step 2: エントリーポイントを理解する

DYNAMIC_INIT関数の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script.rs | `src/cook/script.rs` | SHARED_PRESCRIPT内のDYNAMIC_INIT関数（3-46行目） |

**主要処理フロー**:
1. **3行目**: `function DYNAMIC_INIT {` - 関数定義開始
2. **4-9行目**: `autotools_recursive_regenerate`ヘルパー関数定義
3. **12-17行目**: ターゲット判定（i586/riscv64gcは非対応）
4. **19行目**: デバッグメッセージ出力
5. **21-26行目**: COOKBOOK_CONFIGURE_FLAGS設定
6. **28-32行目**: COOKBOOK_CMAKE_FLAGS設定
7. **34-40行目**: COOKBOOK_MESON_FLAGS設定
8. **43-45行目**: LDFLAGS、RUSTFLAGS、COOKBOOK_DYNAMIC設定

#### Step 3: 呼び出し元を理解する

ビルド処理からどのようにスクリプトが実行されるかを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | full_scriptの構築（418-421行目） |

**主要処理フロー**:
- **418-421行目**: `format!("{}\n{}\n{}\n{}", BUILD_PRESCRIPT, SHARED_PRESCRIPT, script, BUILD_POSTSCRIPT)`でスクリプトを結合
- **342-367行目**: BuildKindに応じたスクリプト生成（`DYNAMIC_INIT\n`が自動挿入）

### プログラム呼び出し階層図

```
build() [cook_build.rs]
    │
    └─ full_script構築
           │
           ├─ BUILD_PRESCRIPT
           │      └─ 基本環境設定
           │
           ├─ SHARED_PRESCRIPT
           │      └─ DYNAMIC_INIT関数定義
           │
           ├─ レシピスクリプト
           │      └─ DYNAMIC_INIT呼び出し
           │
           └─ BUILD_POSTSCRIPT
                  └─ 後処理
```

### データフロー図

```
[入力]                    [処理]                           [出力]

環境変数 ────────▶ DYNAMIC_INIT関数
  TARGET              │
  GNU_TARGET          ▼
  COOKBOOK_SYSROOT   ターゲット判定
                      │
              ┌───────┴───────┐
              ▼               ▼
         非対応ターゲット  対応ターゲット
         (警告出力)         │
                            ▼
                      フラグ設定
                            │
                    ┌───────┼───────┐
                    ▼       ▼       ▼
               CONFIGURE  CMAKE   MESON  ───▶ 環境変数/シェル変数
               FLAGS      FLAGS   FLAGS
                                            LDFLAGS
                                            RUSTFLAGS
                                            COOKBOOK_DYNAMIC
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| script.rs | `src/cook/script.rs` | ソース | DYNAMIC_INIT関数の定義 |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | スクリプト実行の呼び出し元 |
| recipe.toml | 各レシピ | 設定 | DYNAMIC_INIT呼び出しを含むビルドスクリプト |
