# 機能設計書 54-CMakeクロスファイル生成

## 概要

本ドキュメントは、Cookbookビルドシステムにおけるクロスコンパイル用CMakeツールチェインファイル生成機能の設計を記述する。cookbook_cmake関数を通じて、CMakeプロジェクトをRedox OS向けにクロスコンパイルするためのツールチェインファイル（cross_file.cmake）を自動生成する機能を定義する。

### 本機能の処理概要

**業務上の目的・背景**：CMakeは多くのオープンソースプロジェクトで採用されているビルドシステムである。Redox OS向けにCMakeプロジェクトをクロスコンパイルするには、適切なツールチェインファイルを作成し、コンパイラ、リンカ、ライブラリパスなどを正しく設定する必要がある。cookbook_cmake関数はこれらの設定を自動化し、レシピ作成者の負担を軽減する。

**機能の利用シーン**：この機能は以下の場面で利用される。
- CMakeテンプレート（template=cmake）を使用するレシピのビルド時
- カスタムビルドスクリプトでcookbook_cmake関数を呼び出す際
- CMakeプロジェクトのRedox OS向けクロスコンパイル時

**主要な処理内容**：
1. ターゲットOSを判定（Linux/Redox）
2. cross_file.cmakeファイルを生成
3. クロスコンパイラ設定（AR、C、C++コンパイラ）を記述
4. ライブラリ検索パスの設定を記述
5. CC_WRAPPER設定があればコンパイラランチャーを追加
6. CMakeを実行してビルド、インストール

**関連システム・外部連携**：
- CMake：ビルドシステム
- Ninja：ビルドツール（CMakeバックエンド）
- GNUツールチェイン：クロスコンパイラ

**権限による制御**：本機能は権限による制御を行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | template=cmakeでのCMakeプロジェクトビルド |
| 11 | cookbook_redoxerコマンド画面 | 補助機能 | CMakeツールチェインファイル生成 |

## 機能種別

ファイル生成 / ビルド設定

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TARGET | 環境変数 | Yes | ビルドターゲット文字列 | x86_64-unknown-redox等 |
| GNU_TARGET | 環境変数 | Yes | GNU形式のターゲット文字列 | x86_64-unknown-redox等 |
| COOKBOOK_SYSROOT | 環境変数 | Yes | sysrootディレクトリのパス | 有効なディレクトリパス |
| COOKBOOK_SOURCE | 環境変数 | Yes | ソースディレクトリのパス | 有効なディレクトリパス |
| COOKBOOK_STAGE | 環境変数 | Yes | ステージディレクトリのパス | 有効なディレクトリパス |
| COOKBOOK_MAKE_JOBS | 環境変数 | Yes | 並列ジョブ数 | 正の整数 |
| CC_WRAPPER | 環境変数 | No | コンパイララッパー（sccache等） | 有効なコマンドパス |
| COOKBOOK_CMAKE_FLAGS | シェル配列 | No | 追加のCMakeフラグ | CMakeオプション |

### 入力データソース

- 環境変数（cook_build.rsで設定）
- COOKBOOK_CMAKE_FLAGS配列（DYNAMIC_INITやレシピで設定）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cross_file.cmake | ファイル | CMakeツールチェインファイル |
| ビルド成果物 | ファイル | コンパイルされたバイナリ/ライブラリ |

### 出力先

- カレントディレクトリ（build）にcross_file.cmake
- COOKBOOK_STAGEディレクトリにインストール

## 処理フロー

### 処理シーケンス

```
1. システム名を判定
   ├─ linux → SYSTEM_NAME="Linux"
   └─ その他 → SYSTEM_NAME="UnixPaths"
2. cross_file.cmakeを生成
   └─ setコマンドで各種設定を記述
3. CC_WRAPPERの処理
   └─ 設定があればCMAKE_C/CXX_COMPILER_LAUNCHERを追加
4. CMakeを実行
   └─ ツールチェインファイルを指定してNinjaプロジェクト生成
5. Ninjaでビルド
   └─ 並列ジョブ数を指定してビルド
6. インストール
   └─ DESTDIRを指定してステージディレクトリにインストール
```

### フローチャート

```mermaid
flowchart TD
    A[cookbook_cmake開始] --> B{TARGETにlinux含む?}
    B -->|Yes| C[SYSTEM_NAME=Linux]
    B -->|No| D[SYSTEM_NAME=UnixPaths]
    C --> E[cross_file.cmake生成]
    D --> E
    E --> F{CC_WRAPPERあり?}
    F -->|Yes| G[コンパイラランチャー追加]
    F -->|No| H[CMake実行]
    G --> H
    H --> I[Ninjaビルド]
    I --> J[Ninjaインストール]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-54-1 | Linuxターゲット判定 | TARGETの3番目の要素がlinuxの場合、システム名をLinuxとする | cut -d - -f3でlinux判定 |
| BR-54-2 | UnixPathsデフォルト | Linux以外はUnixPathsをシステム名とする | Redoxなど |
| BR-54-3 | クロスコンパイルモード | CMAKE_CROSSCOMPILING=Trueを強制設定 | 常時 |
| BR-54-4 | コンパイラランチャー | CC_WRAPPER設定時にsccache等をランチャーとして設定 | CC_WRAPPER環境変数あり |

### 計算ロジック

生成されるcross_file.cmakeの内容：
```cmake
set(CMAKE_AR ${GNU_TARGET}-ar)
set(CMAKE_CXX_COMPILER ${GNU_TARGET}-g++)
set(CMAKE_C_COMPILER ${GNU_TARGET}-gcc)
set(CMAKE_FIND_ROOT_PATH ${COOKBOOK_SYSROOT})
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
set(CMAKE_PLATFORM_USES_PATH_WHEN_NO_SONAME 1)
set(CMAKE_PREFIX_PATH, ${COOKBOOK_SYSROOT})
set(CMAKE_RANLIB ${GNU_TARGET}-ranlib)
set(CMAKE_SHARED_LIBRARY_SONAME_C_FLAG "-Wl,-soname,")
set(CMAKE_SYSTEM_NAME ${SYSTEM_NAME})
set(CMAKE_SYSTEM_PROCESSOR ${PROCESSOR})
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CMakeエラー | CMake構成失敗 | エラーメッセージを確認しフラグを修正 |
| - | Ninjaエラー | ビルド失敗 | コンパイルエラーを確認 |
| - | インストールエラー | インストール失敗 | パーミッションを確認 |

### リトライ仕様

本機能はリトライを行わない。ビルドスクリプト側でリトライ制御。

## トランザクション仕様

トランザクション管理は行わない。ファイル生成は上書きモード。

## パフォーマンス要件

- ファイル生成は即時完了
- ビルド時間はプロジェクト規模とCOOKBOOK_MAKE_JOBSに依存

## セキュリティ考慮事項

- 生成されるツールチェインファイルはビルドディレクトリ内に限定
- sysrootパスの検証は行わないため、不正なパスが設定される可能性がある

## 備考

- -Wno-devフラグでCMake開発者警告を抑制
- Ninjaをデフォルトジェネレーターとして使用（-GNinja）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CMakeツールチェインファイルの構造と必要な設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | script.rs | `src/cook/script.rs` | BUILD_PRESCRIPT内のcookbook_cmake関数定義 |

**読解のコツ**: CMakeのsetコマンドとcross_file.cmakeの構造を理解しておくと読みやすい。

#### Step 2: エントリーポイントを理解する

cookbook_cmake関数の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script.rs | `src/cook/script.rs` | BUILD_PRESCRIPT内のcookbook_cmake関数（201-245行目） |

**主要処理フロー**:
1. **202-206行目**: ターゲットOS判定（Linux/UnixPaths）
2. **207-221行目**: cross_file.cmake生成（setコマンドでクロスコンパイル設定）
3. **223-227行目**: CC_WRAPPER設定時のコンパイラランチャー追加
4. **229-241行目**: CMake実行（各種フラグとツールチェインファイル指定）
5. **243行目**: Ninjaビルド実行
6. **244行目**: Ninjaインストール実行（DESTDIR指定）

#### Step 3: 呼び出し元を理解する

CMakeテンプレートがどのように処理されるかを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | BuildKind::Cmakeの処理（356-359行目） |
| 3-2 | recipe.rs | `src/recipe.rs` | BuildKind::Cmake定義（114-118行目） |

**主要処理フロー**:
- **cook_build.rs 356-359行目**: CMakeテンプレート時のスクリプト生成（`DYNAMIC_INIT\n{flags}cookbook_cmake`）
- **recipe.rs 114-118行目**: Cmakeビルドタイプの定義とcmakeflagsオプション

### プログラム呼び出し階層図

```
build() [cook_build.rs]
    │
    ├─ BuildKind::Cmake判定
    │      └─ スクリプト生成: "DYNAMIC_INIT\n{flags}cookbook_cmake"
    │
    └─ run_command_stdin(full_script)
           │
           └─ Bashスクリプト実行
                  │
                  └─ cookbook_cmake [script.rs]
                         │
                         ├─ cross_file.cmake生成
                         │
                         ├─ cmake実行
                         │
                         ├─ ninja -j${JOBS}
                         │
                         └─ DESTDIR=${STAGE} ninja install
```

### データフロー図

```
[入力]                        [処理]                         [出力]

環境変数 ────────────▶ cookbook_cmake関数
  TARGET                     │
  GNU_TARGET                 ▼
  COOKBOOK_SYSROOT     ターゲットOS判定
  COOKBOOK_SOURCE            │
  COOKBOOK_STAGE             ▼
  CC_WRAPPER           cross_file.cmake生成 ───▶ cross_file.cmake
                             │
COOKBOOK_CMAKE_FLAGS ───────▶│
                             ▼
                       CMake実行
                             │
                             ▼
                       Ninjaビルド ───────────▶ ビルド成果物
                             │
                             ▼
                       Ninjaインストール ───▶ COOKBOOK_STAGE/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| script.rs | `src/cook/script.rs` | ソース | cookbook_cmake関数の定義 |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | CMakeテンプレート処理の呼び出し元 |
| recipe.rs | `src/recipe.rs` | ソース | BuildKind::Cmakeの定義 |
| recipe.toml | 各レシピ | 設定 | template=cmakeの指定 |
