# 機能設計書 55-Mesonクロスファイル生成

## 概要

本ドキュメントは、Cookbookビルドシステムにおけるクロスコンパイル用Mesonクロスファイル生成機能の設計を記述する。cookbook_meson関数を通じて、MesonプロジェクトをRedox OS向けにクロスコンパイルするためのクロスファイル（cross_file.txt）を自動生成する機能を定義する。

### 本機能の処理概要

**業務上の目的・背景**：Mesonは高速で使いやすいビルドシステムとして人気があり、GNOME関連プロジェクトやその他多くのオープンソースプロジェクトで採用されている。Redox OS向けにMesonプロジェクトをクロスコンパイルするには、適切なクロスファイルを作成し、コンパイラ、リンカ、システム情報などを正しく設定する必要がある。cookbook_meson関数はこれらの設定を自動化し、レシピ作成者の負担を軽減する。

**機能の利用シーン**：この機能は以下の場面で利用される。
- Mesonテンプレート（template=meson）を使用するレシピのビルド時
- カスタムビルドスクリプトでcookbook_meson関数を呼び出す際
- Mesonプロジェクトのクロスコンパイル時

**主要な処理内容**：
1. cross_file.txtファイルを生成
2. [binaries]セクションでコンパイラ、ar、strip、pkg-config等を設定
3. [host_machine]セクションでターゲットシステム情報を設定
4. [paths]セクションでインストールパスを設定
5. [properties]セクションでコンパイラフラグとsysrootを設定
6. 環境変数をunsetしてMesonを実行
7. Ninjaでビルド、インストール

**関連システム・外部連携**：
- Meson：ビルドシステム
- Ninja：ビルドツール（Mesonバックエンド）
- GNUツールチェイン：クロスコンパイラ
- pkg-config：ライブラリ検索

**権限による制御**：本機能は権限による制御を行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | template=mesonでのMesonプロジェクトビルド |
| 11 | cookbook_redoxerコマンド画面 | 補助機能 | Mesonクロスファイル生成 |

## 機能種別

ファイル生成 / ビルド設定

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TARGET | 環境変数 | Yes | ビルドターゲット文字列 | x86_64-unknown-redox等 |
| CC | 環境変数 | Yes | Cコンパイラ | 有効なコンパイラパス |
| CXX | 環境変数 | Yes | C++コンパイラ | 有効なコンパイラパス |
| AR | 環境変数 | Yes | アーカイバ | 有効なコマンドパス |
| STRIP | 環境変数 | Yes | stripコマンド | 有効なコマンドパス |
| PKG_CONFIG | 環境変数 | Yes | pkg-configコマンド | 有効なコマンドパス |
| COOKBOOK_SYSROOT | 環境変数 | Yes | sysrootディレクトリのパス | 有効なディレクトリパス |
| COOKBOOK_SOURCE | 環境変数 | Yes | ソースディレクトリのパス | 有効なディレクトリパス |
| COOKBOOK_STAGE | 環境変数 | Yes | ステージディレクトリのパス | 有効なディレクトリパス |
| CFLAGS | 環境変数 | No | Cコンパイラフラグ | コンパイラオプション |
| CPPFLAGS | 環境変数 | No | C++プリプロセッサフラグ | プリプロセッサオプション |
| LDFLAGS | 環境変数 | No | リンカフラグ | リンカオプション |
| COOKBOOK_MESON_FLAGS | シェル配列 | No | 追加のMesonフラグ | Mesonオプション |

### 入力データソース

- 環境変数（cook_build.rsおよびcross-toolchain経由で設定）
- COOKBOOK_MESON_FLAGS配列（DYNAMIC_INITやレシピで設定）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cross_file.txt | ファイル | Mesonクロスファイル |
| ビルド成果物 | ファイル | コンパイルされたバイナリ/ライブラリ |

### 出力先

- カレントディレクトリ（build）にcross_file.txt
- COOKBOOK_STAGEディレクトリにインストール

## 処理フロー

### 処理シーケンス

```
1. [binaries]セクションを生成
   └─ c, cpp, ar, strip, pkg-config, llvm-config等を設定
2. [host_machine]セクションを生成
   └─ system, cpu_family, cpu, endianを設定
3. [paths]セクションを生成
   └─ prefix, libdir, bindirを設定
4. [properties]セクションを生成
   └─ needs_exe_wrapper, sys_root, c_args, cpp_args, c_link_argsを設定
5. 環境変数をunset
   └─ AR, AS, CC, CXX, LD, NM, OBJCOPY, OBJDUMP, PKG_CONFIG, RANLIB, READELF, STRIP
6. Meson setupを実行
   └─ クロスファイルを指定してビルドディレクトリを構成
7. Ninjaでビルド
8. インストール
```

### フローチャート

```mermaid
flowchart TD
    A[cookbook_meson開始] --> B[binariesセクション生成]
    B --> C[host_machineセクション生成]
    C --> D[pathsセクション生成]
    D --> E[propertiesセクション生成]
    E --> F[cross_file.txt完成]
    F --> G[環境変数unset]
    G --> H[meson setup実行]
    H --> I[Ninjaビルド]
    I --> J[Ninjaインストール]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-55-1 | システム名取得 | TARGETの3番目の要素をsystem名として使用 | cut -d - -f3 |
| BR-55-2 | CPU取得 | TARGETの1番目の要素をcpu/cpu_familyとして使用 | cut -d - -f1 |
| BR-55-3 | エンディアン固定 | endianはlittleを固定値として使用 | 常時 |
| BR-55-4 | 環境変数クリア | Mesonに独自のツールチェイン検出をさせないため環境変数をunset | 常時 |
| BR-55-5 | exe_wrapper必須 | クロスコンパイル時はneeds_exe_wrapper=trueを設定 | 常時 |

### 計算ロジック

生成されるcross_file.txtの内容：
```ini
[binaries]
c = ['compiler1', 'compiler2', ...]
cpp = ['cppcompiler1', 'cppcompiler2', ...]
ar = 'ar_command'
strip = 'strip_command'
pkg-config = 'pkg-config_command'
llvm-config = 'target-llvm-config'
glib-compile-resources = 'glib-compile-resources'
glib-compile-schemas = 'glib-compile-schemas'

[host_machine]
system = 'redox'
cpu_family = 'x86_64'
cpu = 'x86_64'
endian = 'little'

[paths]
prefix = '/usr'
libdir = 'lib'
bindir = 'bin'

[properties]
needs_exe_wrapper = true
sys_root = '/path/to/sysroot'
c_args = ['-I/path/to/include', ...]
cpp_args = ['-I/path/to/include', ...]
c_link_args = ['-L/path/to/lib', ...]
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Mesonエラー | Meson構成失敗 | エラーメッセージを確認しフラグを修正 |
| - | Ninjaエラー | ビルド失敗 | コンパイルエラーを確認 |
| - | インストールエラー | インストール失敗 | パーミッションを確認 |

### リトライ仕様

本機能はリトライを行わない。ビルドスクリプト側でリトライ制御。

## トランザクション仕様

トランザクション管理は行わない。ファイル生成は上書きモード。

## パフォーマンス要件

- ファイル生成は即時完了
- ビルド時間はプロジェクト規模とCOOKBOOK_MAKE_JOBSに依存

## セキュリティ考慮事項

- 生成されるクロスファイルはビルドディレクトリ内に限定
- sysrootパスの検証は行わないため、不正なパスが設定される可能性がある

## 備考

- 環境変数のunsetはMesonのツールチェイン自動検出を防ぐために必要
- printfとsedを使用してコンパイラ配列を適切な形式に変換

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Mesonクロスファイルの構造と必要な設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | script.rs | `src/cook/script.rs` | BUILD_PRESCRIPT内のcookbook_meson関数定義 |

**読解のコツ**: Mesonのクロスファイル形式（INI形式）を理解しておくと読みやすい。[binaries]、[host_machine]、[paths]、[properties]の各セクションの役割を把握する。

#### Step 2: エントリーポイントを理解する

cookbook_meson関数の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script.rs | `src/cook/script.rs` | BUILD_PRESCRIPT内のcookbook_meson関数（255-305行目） |

**主要処理フロー**:
1. **256行目**: `echo "[binaries]" > cross_file.txt` - ファイル作成開始
2. **257-264行目**: binariesセクション（コンパイラ、ツール設定）
3. **266-270行目**: host_machineセクション（ターゲットシステム情報）
4. **272-275行目**: pathsセクション（インストールパス）
5. **277-282行目**: propertiesセクション（sysroot、コンパイラフラグ）
6. **284-295行目**: 環境変数unset（AR、CC、CXX等）
7. **297-302行目**: meson setup実行
8. **303行目**: Ninjaビルド実行
9. **304行目**: Ninjaインストール実行（DESTDIR指定）

#### Step 3: 呼び出し元を理解する

Mesonテンプレートがどのように処理されるかを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | BuildKind::Mesonの処理（360-363行目） |
| 3-2 | recipe.rs | `src/recipe.rs` | BuildKind::Meson定義（119-124行目） |

**主要処理フロー**:
- **cook_build.rs 360-363行目**: Mesonテンプレート時のスクリプト生成（`DYNAMIC_INIT\n{flags}cookbook_meson`）
- **recipe.rs 119-124行目**: Mesonビルドタイプの定義とmesonflagsオプション

### プログラム呼び出し階層図

```
build() [cook_build.rs]
    │
    ├─ BuildKind::Meson判定
    │      └─ スクリプト生成: "DYNAMIC_INIT\n{flags}cookbook_meson"
    │
    └─ run_command_stdin(full_script)
           │
           └─ Bashスクリプト実行
                  │
                  └─ cookbook_meson [script.rs]
                         │
                         ├─ cross_file.txt生成
                         │    ├─ [binaries]
                         │    ├─ [host_machine]
                         │    ├─ [paths]
                         │    └─ [properties]
                         │
                         ├─ 環境変数unset
                         │
                         ├─ meson setup --cross-file
                         │
                         ├─ ninja -j${JOBS}
                         │
                         └─ DESTDIR=${STAGE} ninja install
```

### データフロー図

```
[入力]                        [処理]                         [出力]

環境変数 ────────────▶ cookbook_meson関数
  TARGET                     │
  CC, CXX, AR, STRIP         ▼
  PKG_CONFIG           binariesセクション生成 ──▶ cross_file.txt
  COOKBOOK_SYSROOT           │
  CFLAGS, LDFLAGS      host_machineセクション生成
                             │
COOKBOOK_MESON_FLAGS ───────▶│
                             ▼
                       環境変数unset
                             │
                             ▼
                       meson setup実行
                             │
                             ▼
                       Ninjaビルド ───────────▶ ビルド成果物
                             │
                             ▼
                       Ninjaインストール ───▶ COOKBOOK_STAGE/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| script.rs | `src/cook/script.rs` | ソース | cookbook_meson関数の定義 |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | Mesonテンプレート処理の呼び出し元 |
| recipe.rs | `src/recipe.rs` | ソース | BuildKind::Mesonの定義 |
| recipe.toml | 各レシピ | 設定 | template=mesonの指定 |
