# 機能設計書 56-バイナリストリップ

## 概要

本ドキュメントは、Cookbookビルドシステムにおけるバイナリストリップ機能の設計を記述する。BUILD_POSTSCRIPTの一部として、ビルド済みバイナリからデバッグシンボルを削除し、パッケージサイズを削減する機能を定義する。

### 本機能の処理概要

**業務上の目的・背景**：ビルドされたバイナリファイルにはデバッグ情報が含まれており、これによりファイルサイズが大幅に増加する。Redox OSのパッケージでは、リリース用バイナリからデバッグシンボルを除去することで、ダウンロードサイズと実行時のメモリ使用量を削減している。この処理はビルド後処理（postscript）として自動的に実行され、レシピ作成者は明示的に指定する必要がない。

**機能の利用シーン**：この機能は以下の場面で利用される。
- 全てのレシピビルド完了後（BUILD_POSTSCRIPTとして自動実行）
- COOKBOOK_NOSTRIP環境変数が設定されていない場合に実行
- ステージディレクトリ内のbin/usr/binディレクトリに対して実行

**主要な処理内容**：
1. ステージディレクトリ内のbinおよびusr/binディレクトリを探索
2. COOKBOOK_NOSTRIP環境変数が未設定の場合のみ処理を実行
3. findコマンドでディレクトリ内の通常ファイルを検索
4. GNU_TARGET-stripコマンドでデバッグシンボルを削除

**関連システム・外部連携**：
- GNUツールチェイン：strip（${GNU_TARGET}-strip）コマンド
- findコマンド：ファイル検索

**権限による制御**：本機能は権限による制御を行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | ビルド済みバイナリからのデバッグシンボル削除 |

## 機能種別

ファイル処理 / 後処理（ポストスクリプト）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| COOKBOOK_STAGE | 環境変数 | Yes | ステージディレクトリのパス | 有効なディレクトリパス |
| GNU_TARGET | 環境変数 | Yes | GNU形式のターゲット文字列 | 有効なターゲット形式 |
| COOKBOOK_NOSTRIP | 環境変数 | No | ストリップ無効化フラグ | 設定されていると処理スキップ |

### 入力データソース

- 環境変数（cook_build.rsで設定）
- ステージディレクトリ内のバイナリファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ストリップ済みバイナリ | ファイル | デバッグシンボルを除去したバイナリ |
| 処理ログ | 標準出力 | strip -vによる詳細出力 |

### 出力先

- ステージディレクトリ内のバイナリ（in-place更新）

## 処理フロー

### 処理シーケンス

```
1. 処理対象ディレクトリをループ
   └─ "${COOKBOOK_STAGE}/bin"と"${COOKBOOK_STAGE}/usr/bin"
2. ディレクトリ存在確認
   └─ -d "${dir}"で確認
3. COOKBOOK_NOSTRIPチェック
   └─ -z "${COOKBOOK_NOSTRIP}"で未設定を確認
4. findコマンドでファイル検索
   └─ find "${dir}" -type f
5. stripコマンド実行
   └─ "${GNU_TARGET}-strip" -v {} ';'
```

### フローチャート

```mermaid
flowchart TD
    A[BUILD_POSTSCRIPT開始] --> B[bin, usr/binをループ]
    B --> C{ディレクトリ存在?}
    C -->|No| B
    C -->|Yes| D{COOKBOOK_NOSTRIP?}
    D -->|設定あり| B
    D -->|設定なし| E[findでファイル検索]
    E --> F[stripコマンド実行]
    F --> B
    B -->|ループ完了| G[次の後処理へ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-56-1 | ストリップ対象ディレクトリ | bin/とusr/bin/のみを対象とする | 常時 |
| BR-56-2 | ストリップ無効化 | COOKBOOK_NOSTRIPが設定されている場合はスキップ | COOKBOOK_NOSTRIP環境変数あり |
| BR-56-3 | 通常ファイルのみ | -type fで通常ファイルのみを対象とする | 常時 |
| BR-56-4 | クロスターゲットstrip | GNU_TARGET-stripを使用してクロスコンパイル対応 | 常時 |

### 計算ロジック

処理対象ディレクトリのパターン：
- `${COOKBOOK_STAGE}/bin`
- `${COOKBOOK_STAGE}/usr/bin`

使用するstripコマンド：
- `${GNU_TARGET}-strip -v {file}`

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | stripエラー | 非ELFファイルへのstrip実行 | エラーは出力されるが処理は継続 |
| - | ディレクトリなし | 対象ディレクトリが存在しない | スキップして継続 |

### リトライ仕様

リトライ処理は行わない。stripエラーは無視して次のファイルへ進む。

## トランザクション仕様

トランザクション管理は行わない。ファイルはin-placeで更新される。

## パフォーマンス要件

- 処理時間はバイナリファイル数とサイズに依存
- 並列処理は行わない（findの-execオプション使用）

## セキュリティ考慮事項

- デバッグシンボルを削除することで、バイナリのリバースエンジニアリングが若干困難になる
- 本番環境向けにはストリップを推奨

## 備考

- COOKBOOK_DEBUG環境変数と組み合わせてデバッグビルドを作成可能
- -vオプションにより処理されたファイルが標準出力に表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BUILD_POSTSCRIPTの構造と実行タイミングを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | script.rs | `src/cook/script.rs` | BUILD_POSTSCRIPT定数の定義 |

**読解のコツ**: BUILD_POSTSCRIPTはビルドスクリプトの最後に自動追加されるBashスクリプト。各処理はforループと条件分岐で構成されている。

#### Step 2: エントリーポイントを理解する

バイナリストリップ処理の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script.rs | `src/cook/script.rs` | BUILD_POSTSCRIPT内のストリップ処理（309-316行目） |

**主要処理フロー**:
1. **310行目**: `for dir in "${COOKBOOK_STAGE}/bin" "${COOKBOOK_STAGE}/usr/bin"` - 対象ディレクトリのループ
2. **312行目**: `if [ -d "${dir}" ]` - ディレクトリ存在確認
3. **312行目**: `[ -z "${COOKBOOK_NOSTRIP}" ]` - NOSTRIP環境変数チェック
4. **314行目**: `find "${dir}" -type f -exec "${GNU_TARGET}-strip" -v {} ';'` - findとstrip実行

#### Step 3: 呼び出し元を理解する

BUILD_POSTSCRIPTがどのように実行されるかを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | full_script構築（418-421行目） |

**主要処理フロー**:
- **418-421行目**: `format!("{}\n{}\n{}\n{}", BUILD_PRESCRIPT, SHARED_PRESCRIPT, script, BUILD_POSTSCRIPT)`
- BUILD_POSTSCRIPTはビルドスクリプトの最後に常に追加される

### プログラム呼び出し階層図

```
build() [cook_build.rs]
    │
    └─ run_command_stdin(full_script)
           │
           └─ Bashスクリプト実行
                  │
                  ├─ BUILD_PRESCRIPT
                  │
                  ├─ SHARED_PRESCRIPT
                  │
                  ├─ レシピスクリプト
                  │
                  └─ BUILD_POSTSCRIPT [script.rs]
                         │
                         ├─ バイナリストリップ (309-316行目)
                         │      │
                         │      └─ find -exec ${GNU_TARGET}-strip
                         │
                         ├─ libtoolファイル削除 (318-325行目)
                         │
                         ├─ cargoインストールファイル削除 (327-334行目)
                         │
                         └─ AppStreamメタデータ更新 (336-343行目)
```

### データフロー図

```
[入力]                        [処理]                         [出力]

COOKBOOK_STAGE ───────▶ バイナリストリップ処理
       │                     │
       ▼                     ▼
  bin/            対象ディレクトリ存在確認
  usr/bin/              │
       │          ┌─────┴─────┐
       │          ▼           ▼
       │      存在する     存在しない
       │          │           │
       │          ▼         スキップ
       │    COOKBOOK_NOSTRIP?
       │          │
       │    ┌─────┴─────┐
       │    ▼           ▼
       │  設定なし    設定あり
       │    │           │
       │    ▼         スキップ
       │  findでファイル検索
       │    │
       ▼    ▼
バイナリファイル ──▶ ${GNU_TARGET}-strip -v ──▶ ストリップ済み
                                                 バイナリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| script.rs | `src/cook/script.rs` | ソース | BUILD_POSTSCRIPT定義（バイナリストリップ処理含む） |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | full_script構築（BUILD_POSTSCRIPT含む） |
