# 機能設計書 57-libtoolファイル削除

## 概要

本ドキュメントは、Cookbookビルドシステムにおけるlibtoolファイル削除機能の設計を記述する。BUILD_POSTSCRIPTの一部として、autotoolsビルドで生成される不要な.laファイル（libtoolアーカイブ記述ファイル）を削除し、パッケージをクリーンな状態に保つ機能を定義する。

### 本機能の処理概要

**業務上の目的・背景**：autotoolsを使用するプロジェクトでは、libtool（ライブラリ作成支援ツール）によって.laファイルが生成される。これらのファイルはビルド時のライブラリパス情報を含むが、インストール後は不要であり、クロスコンパイル環境では誤ったパス情報が含まれることで問題を引き起こす可能性がある。この機能はパッケージング前に.laファイルを削除することで、これらの問題を回避する。

**機能の利用シーン**：この機能は以下の場面で利用される。
- 全てのレシピビルド完了後（BUILD_POSTSCRIPTとして自動実行）
- ステージディレクトリ内のlib/usr/libディレクトリに対して実行

**主要な処理内容**：
1. ステージディレクトリ内のlibおよびusr/libディレクトリを探索
2. findコマンドで.laファイルを検索
3. rmコマンドで.laファイルを削除

**関連システム・外部連携**：
- findコマンド：ファイル検索
- rmコマンド：ファイル削除

**権限による制御**：本機能は権限による制御を行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | 不要な.laファイルの削除 |

## 機能種別

ファイル処理 / 後処理（ポストスクリプト）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| COOKBOOK_STAGE | 環境変数 | Yes | ステージディレクトリのパス | 有効なディレクトリパス |

### 入力データソース

- 環境変数（cook_build.rsで設定）
- ステージディレクトリ内の.laファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 処理ログ | 標準出力 | rm -fvによる削除ログ |

### 出力先

- 標準出力（削除されたファイルのパス）

## 処理フロー

### 処理シーケンス

```
1. 処理対象ディレクトリをループ
   └─ "${COOKBOOK_STAGE}/lib"と"${COOKBOOK_STAGE}/usr/lib"
2. ディレクトリ存在確認
   └─ -d "${dir}"で確認
3. findコマンドで.laファイル検索
   └─ find "${dir}" -type f -name '*.la'
4. rmコマンドで削除
   └─ rm -fv {} ';'
```

### フローチャート

```mermaid
flowchart TD
    A[BUILD_POSTSCRIPT - libtool処理] --> B[lib, usr/libをループ]
    B --> C{ディレクトリ存在?}
    C -->|No| B
    C -->|Yes| D[findで*.la検索]
    D --> E[rm -fvで削除]
    E --> B
    B -->|ループ完了| F[次の後処理へ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-57-1 | 削除対象ディレクトリ | lib/とusr/lib/のみを対象とする | 常時 |
| BR-57-2 | 拡張子パターン | *.laパターンにマッチするファイルのみ削除 | 常時 |
| BR-57-3 | 通常ファイルのみ | -type fで通常ファイルのみを対象とする | 常時 |
| BR-57-4 | 強制削除 | rm -fで存在しない場合もエラーにしない | 常時 |

### 計算ロジック

処理対象ディレクトリのパターン：
- `${COOKBOOK_STAGE}/lib`
- `${COOKBOOK_STAGE}/usr/lib`

検索パターン：
- `-name '*.la'`（.laファイルのみ）

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ディレクトリなし | 対象ディレクトリが存在しない | スキップして継続 |

### リトライ仕様

リトライ処理は行わない。

## トランザクション仕様

トランザクション管理は行わない。ファイルは直接削除される。

## パフォーマンス要件

- 処理時間は.laファイル数に依存
- 通常は非常に高速（数ミリ秒）

## セキュリティ考慮事項

- .laファイルにはビルド環境のパス情報が含まれるため、削除することでパス情報の漏洩を防ぐ副次的効果がある

## 備考

- .laファイルはLibtool Archive Descriptionファイル
- autotoolsプロジェクト以外では通常生成されない
- pkg-configの普及により.laファイルの必要性は低下している

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BUILD_POSTSCRIPTの構造とlibtoolファイル削除の位置を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | script.rs | `src/cook/script.rs` | BUILD_POSTSCRIPT定数の定義 |

**読解のコツ**: BUILD_POSTSCRIPTには4つの後処理が含まれている。libtoolファイル削除は2番目の処理。

#### Step 2: エントリーポイントを理解する

libtoolファイル削除処理の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script.rs | `src/cook/script.rs` | BUILD_POSTSCRIPT内のlibtool処理（318-325行目） |

**主要処理フロー**:
1. **319行目**: `for dir in "${COOKBOOK_STAGE}/lib" "${COOKBOOK_STAGE}/usr/lib"` - 対象ディレクトリのループ
2. **321行目**: `if [ -d "${dir}" ]` - ディレクトリ存在確認
3. **323行目**: `find "${dir}" -type f -name '*.la' -exec rm -fv {} ';'` - findと削除実行

#### Step 3: 呼び出し元を理解する

BUILD_POSTSCRIPTがどのように実行されるかを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | full_script構築（418-421行目） |

**主要処理フロー**:
- **418-421行目**: BUILD_POSTSCRIPTはビルドスクリプトの最後に常に追加される

### プログラム呼び出し階層図

```
build() [cook_build.rs]
    │
    └─ run_command_stdin(full_script)
           │
           └─ Bashスクリプト実行
                  │
                  └─ BUILD_POSTSCRIPT [script.rs]
                         │
                         ├─ バイナリストリップ (309-316行目)
                         │
                         ├─ libtoolファイル削除 (318-325行目)  ← ここ
                         │      │
                         │      └─ find -name '*.la' -exec rm -fv
                         │
                         ├─ cargoインストールファイル削除 (327-334行目)
                         │
                         └─ AppStreamメタデータ更新 (336-343行目)
```

### データフロー図

```
[入力]                        [処理]                         [出力]

COOKBOOK_STAGE ───────▶ libtoolファイル削除処理
       │                     │
       ▼                     ▼
  lib/            対象ディレクトリ存在確認
  usr/lib/              │
       │          ┌─────┴─────┐
       │          ▼           ▼
       │      存在する     存在しない
       │          │           │
       │          ▼         スキップ
       │    findで*.la検索
       │          │
       ▼          ▼
 .laファイル ──▶ rm -fv ──▶ 削除ログ（標準出力）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| script.rs | `src/cook/script.rs` | ソース | BUILD_POSTSCRIPT定義（libtoolファイル削除含む） |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | full_script構築（BUILD_POSTSCRIPT含む） |
