# 機能設計書 58-cargoインストールファイル削除

## 概要

本ドキュメントは、Cookbookビルドシステムにおけるcargoインストールファイル削除機能の設計を記述する。BUILD_POSTSCRIPTの一部として、`cargo install`コマンドが生成する管理ファイル（.crates.toml、.crates2.json）を削除し、パッケージをクリーンな状態に保つ機能を定義する。

### 本機能の処理概要

**業務上の目的・背景**：Rustプロジェクトを`cargo install`でインストールすると、インストール先ディレクトリに`.crates.toml`と`.crates2.json`というCargo管理ファイルが生成される。これらのファイルはCargoがインストール済みパッケージを追跡するために使用するが、Redox OSのパッケージシステムでは不要であり、パッケージに含める必要がない。この機能は自動的にこれらのファイルを削除し、パッケージサイズを削減する。

**機能の利用シーン**：この機能は以下の場面で利用される。
- 全てのレシピビルド完了後（BUILD_POSTSCRIPTとして自動実行）
- Cargoテンプレート（template=cargo）を使用したビルド後に特に有効

**主要な処理内容**：
1. .crates.tomlファイルの存在確認と削除
2. .crates2.jsonファイルの存在確認と削除

**関連システム・外部連携**：
- Cargo：Rustパッケージマネージャー（.crates.*ファイルの生成元）
- rmコマンド：ファイル削除

**権限による制御**：本機能は権限による制御を行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | cargo install管理ファイルの削除 |

## 機能種別

ファイル処理 / 後処理（ポストスクリプト）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| COOKBOOK_STAGE | 環境変数 | Yes | ステージディレクトリのパス | 有効なディレクトリパス |

### 入力データソース

- 環境変数（cook_build.rsで設定）
- ステージディレクトリ直下の.crates.*ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 処理ログ | 標準出力 | rm -vによる削除ログ |

### 出力先

- 標準出力（削除されたファイルのパス）

## 処理フロー

### 処理シーケンス

```
1. 処理対象ファイルをループ
   └─ .crates.tomlと.crates2.json
2. ファイル存在確認
   └─ -f "${COOKBOOK_STAGE}/${file}"で確認
3. rmコマンドで削除
   └─ rm -v "${COOKBOOK_STAGE}/${file}"
```

### フローチャート

```mermaid
flowchart TD
    A[BUILD_POSTSCRIPT - cargo処理] --> B[.crates.toml, .crates2.jsonをループ]
    B --> C{ファイル存在?}
    C -->|No| B
    C -->|Yes| D[rm -vで削除]
    D --> B
    B -->|ループ完了| E[次の後処理へ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-58-1 | 削除対象ファイル | .crates.tomlと.crates2.jsonのみを対象 | 常時 |
| BR-58-2 | 存在確認必須 | ファイルが存在する場合のみ削除を実行 | 常時 |
| BR-58-3 | ステージ直下限定 | COOKBOOK_STAGE直下のファイルのみ対象 | 常時 |

### 計算ロジック

削除対象ファイルのパス：
- `${COOKBOOK_STAGE}/.crates.toml`
- `${COOKBOOK_STAGE}/.crates2.json`

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイルなし | 対象ファイルが存在しない | スキップして継続 |

### リトライ仕様

リトライ処理は行わない。

## トランザクション仕様

トランザクション管理は行わない。ファイルは直接削除される。

## パフォーマンス要件

- 即時完了（2ファイルの存在確認と削除のみ）

## セキュリティ考慮事項

- 本機能に特別なセキュリティ考慮事項はない

## 備考

- .crates.tomlはCargo 1.0から使用されているTOML形式の管理ファイル
- .crates2.jsonはCargo 1.41から追加されたJSON形式の管理ファイル
- 両方のファイルが存在する場合があるため、両方を削除対象とする

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BUILD_POSTSCRIPTの構造とcargoファイル削除の位置を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | script.rs | `src/cook/script.rs` | BUILD_POSTSCRIPT定数の定義 |

**読解のコツ**: BUILD_POSTSCRIPTには4つの後処理が含まれている。cargoインストールファイル削除は3番目の処理。

#### Step 2: エントリーポイントを理解する

cargoファイル削除処理の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script.rs | `src/cook/script.rs` | BUILD_POSTSCRIPT内のcargo処理（327-334行目） |

**主要処理フロー**:
1. **328行目**: `for file in .crates.toml .crates2.json` - 対象ファイルのループ
2. **330行目**: `if [ -f "${COOKBOOK_STAGE}/${file}" ]` - ファイル存在確認
3. **332行目**: `rm -v "${COOKBOOK_STAGE}/${file}"` - 削除実行

#### Step 3: 呼び出し元を理解する

BUILD_POSTSCRIPTがどのように実行されるかを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | full_script構築（418-421行目） |

**主要処理フロー**:
- **418-421行目**: BUILD_POSTSCRIPTはビルドスクリプトの最後に常に追加される

### プログラム呼び出し階層図

```
build() [cook_build.rs]
    │
    └─ run_command_stdin(full_script)
           │
           └─ Bashスクリプト実行
                  │
                  └─ BUILD_POSTSCRIPT [script.rs]
                         │
                         ├─ バイナリストリップ (309-316行目)
                         │
                         ├─ libtoolファイル削除 (318-325行目)
                         │
                         ├─ cargoインストールファイル削除 (327-334行目)  ← ここ
                         │      │
                         │      └─ rm -v ${STAGE}/.crates.*
                         │
                         └─ AppStreamメタデータ更新 (336-343行目)
```

### データフロー図

```
[入力]                        [処理]                         [出力]

COOKBOOK_STAGE ───────▶ cargoファイル削除処理
       │                     │
       ▼                     ▼
.crates.toml        対象ファイル存在確認
.crates2.json             │
       │          ┌───────┴───────┐
       │          ▼               ▼
       │      存在する         存在しない
       │          │               │
       │          ▼             スキップ
       │      rm -v実行
       │          │
       ▼          ▼
管理ファイル ──▶ 削除 ──▶ 削除ログ（標準出力）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| script.rs | `src/cook/script.rs` | ソース | BUILD_POSTSCRIPT定義（cargoファイル削除含む） |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | full_script構築（BUILD_POSTSCRIPT含む） |
