# 機能設計書 59-AppStreamメタデータ更新

## 概要

本ドキュメントは、Cookbookビルドシステムにおけるメタデータ更新機能の設計を記述する。BUILD_POSTSCRIPTの一部として、AppStreamメタデータXMLファイルにパッケージ名（pkgname）タグを追加し、パッケージシステムとの連携を可能にする機能を定義する。

### 本機能の処理概要

**業務上の目的・背景**：AppStreamは、Linuxディストリビューションにおいてソフトウェアカタログ情報を標準化するための仕様である。Redox OSでもAppStream形式のメタデータを利用することで、ソフトウェアセンターでのパッケージ表示や検索が可能になる。この機能は、各パッケージのAppStreamメタデータに自動的にpkgnameタグを追加し、パッケージシステムがメタデータとパッケージを正しく紐付けられるようにする。

**機能の利用シーン**：この機能は以下の場面で利用される。
- 全てのレシピビルド完了後（BUILD_POSTSCRIPTとして自動実行）
- AppStreamメタデータ（*.xml）を含むパッケージに対して実行
- metainfoディレクトリに配置されたXMLファイルに対して実行

**主要な処理内容**：
1. ステージディレクトリ内のmetainfoディレクトリを探索
2. findコマンドで.xmlファイルを検索
3. sedコマンドで</component>タグの直前にpkgnameタグを挿入

**関連システム・外部連携**：
- AppStream：ソフトウェアメタデータ仕様
- repo_builder：AppStreamカタログ生成機能
- findコマンド：ファイル検索
- sedコマンド：テキスト置換

**権限による制御**：本機能は権限による制御を行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | メタデータXMLへのpkgnameタグ追加 |

## 機能種別

ファイル処理 / 後処理（ポストスクリプト）/ メタデータ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| COOKBOOK_STAGE | 環境変数 | Yes | ステージディレクトリのパス | 有効なディレクトリパス |
| COOKBOOK_NAME | 環境変数 | Yes | パッケージ名 | 有効なパッケージ名 |

### 入力データソース

- 環境変数（cook_build.rsで設定）
- metainfoディレクトリ内のAppStream XMLファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 更新されたXMLファイル | ファイル | pkgnameタグが追加されたAppStreamメタデータ |

### 出力先

- ステージディレクトリ内のXMLファイル（in-place更新）

## 処理フロー

### 処理シーケンス

```
1. 処理対象ディレクトリをループ
   └─ "${COOKBOOK_STAGE}/share/metainfo"と"${COOKBOOK_STAGE}/usr/share/metainfo"
2. ディレクトリ存在確認
   └─ -d "${dir}"で確認
3. findコマンドで.xmlファイル検索
   └─ find "${dir}" -type f -name '*.xml'
4. sedコマンドでタグ挿入
   └─ sed -i 's|</component>|<pkgname>${COOKBOOK_NAME}</pkgname></component>|g'
```

### フローチャート

```mermaid
flowchart TD
    A[BUILD_POSTSCRIPT - AppStream処理] --> B[share/metainfo, usr/share/metainfoをループ]
    B --> C{ディレクトリ存在?}
    C -->|No| B
    C -->|Yes| D[findで*.xml検索]
    D --> E[sedでpkgname挿入]
    E --> B
    B -->|ループ完了| F[BUILD_POSTSCRIPT完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-59-1 | 対象ディレクトリ | share/metainfoとusr/share/metainfoを対象 | 常時 |
| BR-59-2 | 対象ファイル | *.xmlパターンにマッチするファイルのみ | 常時 |
| BR-59-3 | タグ挿入位置 | </component>タグの直前にpkgnameタグを挿入 | 常時 |
| BR-59-4 | パッケージ名使用 | COOKBOOK_NAME環境変数の値をpkgname値として使用 | 常時 |

### 計算ロジック

処理対象ディレクトリのパターン：
- `${COOKBOOK_STAGE}/share/metainfo`
- `${COOKBOOK_STAGE}/usr/share/metainfo`

sed置換パターン：
```
入力: </component>
出力: <pkgname>${COOKBOOK_NAME}</pkgname></component>
```

実行コマンド：
```bash
sed -i 's|</component>|<pkgname>'"${COOKBOOK_NAME}"'</pkgname></component>|g' {}
```

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ディレクトリなし | 対象ディレクトリが存在しない | スキップして継続 |
| - | sedエラー | XML形式が不正 | エラーは出力されるが処理は継続 |

### リトライ仕様

リトライ処理は行わない。

## トランザクション仕様

トランザクション管理は行わない。ファイルはin-placeで更新される（sed -i）。

## パフォーマンス要件

- 処理時間はXMLファイル数とサイズに依存
- 通常は非常に高速（数ミリ秒）

## セキュリティ考慮事項

- COOKBOOK_NAMEはエスケープ処理されずにXMLに挿入されるため、パッケージ名に不正な文字が含まれないことを前提とする
- パッケージ名は事前にPackageNameとして検証済み

## 備考

- AppStreamメタデータは通常、アップストリームプロジェクトが提供する
- pkgnameタグはディストリビューション固有の拡張であり、AppStream仕様の標準タグではない
- repo_builderがAppStreamカタログ生成時にこのpkgnameを使用する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BUILD_POSTSCRIPTの構造とAppStream処理の位置を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | script.rs | `src/cook/script.rs` | BUILD_POSTSCRIPT定数の定義 |

**読解のコツ**: BUILD_POSTSCRIPTには4つの後処理が含まれている。AppStreamメタデータ更新は最後（4番目）の処理。

#### Step 2: エントリーポイントを理解する

AppStream処理の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script.rs | `src/cook/script.rs` | BUILD_POSTSCRIPT内のAppStream処理（336-343行目） |

**主要処理フロー**:
1. **337行目**: `for dir in "${COOKBOOK_STAGE}/share/metainfo" "${COOKBOOK_STAGE}/usr/share/metainfo"` - 対象ディレクトリのループ
2. **339行目**: `if [ -d "${dir}" ]` - ディレクトリ存在確認
3. **341行目**: `find "${dir}" -type f -name '*.xml' -exec sed -i 's|</component>|<pkgname>'"${COOKBOOK_NAME}"'</pkgname></component>|g' {} ';'` - findとsed実行

#### Step 3: 関連機能を理解する

AppStreamカタログ生成との関連を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo_builder.rs | `src/bin/repo_builder.rs` | AppStreamカタログ生成でのpkgname使用 |

**主要処理フロー**:
- repo_builderがappstreamcliを使用してカタログを生成する際に、pkgnameタグが利用される

### プログラム呼び出し階層図

```
build() [cook_build.rs]
    │
    └─ run_command_stdin(full_script)
           │
           └─ Bashスクリプト実行
                  │
                  └─ BUILD_POSTSCRIPT [script.rs]
                         │
                         ├─ バイナリストリップ (309-316行目)
                         │
                         ├─ libtoolファイル削除 (318-325行目)
                         │
                         ├─ cargoインストールファイル削除 (327-334行目)
                         │
                         └─ AppStreamメタデータ更新 (336-343行目)  ← ここ
                                │
                                └─ find -name '*.xml' -exec sed -i
                                         │
                                         └─ pkgnameタグ挿入
```

### データフロー図

```
[入力]                        [処理]                         [出力]

COOKBOOK_STAGE ───────▶ AppStream処理
COOKBOOK_NAME            │
       │                 ▼
       │          対象ディレクトリ存在確認
       │                 │
       │          ┌──────┴──────┐
       │          ▼             ▼
       │      存在する       存在しない
       │          │             │
       │          ▼           スキップ
       │     findで*.xml検索
       │          │
       ▼          ▼
AppStream XML ──▶ sed置換 ──▶ 更新されたXML
                   │             (pkgname追加)
                   ▼
            </component>
                   ↓
            <pkgname>pkg</pkgname></component>
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| script.rs | `src/cook/script.rs` | ソース | BUILD_POSTSCRIPT定義（AppStream処理含む） |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | full_script構築（BUILD_POSTSCRIPT含む） |
| repo_builder.rs | `src/bin/repo_builder.rs` | ソース | AppStreamカタログ生成（pkgname利用） |
