# 機能設計書 8-ビルド前スクリプト実行

## 概要

本ドキュメントは、Redox OSビルドシステムにおけるソース準備用カスタムスクリプト実行機能の設計を記載する。sourceセクションのscriptによるソース事前処理について詳述する。

### 本機能の処理概要

ビルド前スクリプト実行機能は、ソース取得後・ビルド前にカスタムシェルスクリプトを実行する機能である。autoreconfの実行、configure.acの生成、ファイルの整理など、ビルドに必要な前処理を自動化する。

**業務上の目的・背景**：多くのプロジェクトでは、ソースコードを取得しただけではビルドできず、事前に特定の処理を実行する必要がある。例えば、autotoolsプロジェクトでは`autoreconf -fvi`の実行が必要であり、一部のプロジェクトではconfigureスクリプトの生成が必要である。これらの処理を自動化することで、ビルドプロセス全体を一貫して実行できるようになる。

**機能の利用シーン**：
- autoreconf/autogen.shの実行（autotools系プロジェクト）
- 設定ファイルの生成・修正
- ビルド対象ファイルの整理・移動
- 依存関係チェックスクリプトの実行
- プラットフォーム固有の準備処理

**主要な処理内容**：
1. スクリプト内容の取得（recipe.tomlのsource.script）
2. 共有プリスクリプト（SHARED_PRESCRIPT）の前置
3. bashコマンドによるスクリプト実行
4. エラーハンドリング

**関連システム・外部連携**：
- bashシェル：スクリプト実行環境
- autotools：autoreconf等のビルドツール

**権限による制御**：特になし（シェルコマンドの実行権限が必要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | repo fetchコマンド画面 | API連携 | ソース準備用カスタムスクリプト実行 |

## 機能種別

外部コマンド実行 / 処理自動化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| script | Option<String> | No | 実行するシェルスクリプト | - |
| source_dir | PathBuf | Yes | スクリプトを実行するディレクトリ | ディレクトリが存在すること |

### 入力データソース

- recipe.toml: sourceセクションのscriptフィールド
- script.rs: SHARED_PRESCRIPT定義

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| スクリプト実行結果 | Result<(), String> | 成功/失敗 |

### 出力先

- ファイルシステム：スクリプトによる生成ファイル

## 処理フロー

### 処理シーケンス

```
1. スクリプトの取得
   └─ recipe.tomlのsource.scriptを取得
2. スクリプトが存在する場合のみ実行
3. 実行環境の準備
   ├─ bashコマンドの構築
   ├─ -exオプション（エラー時停止、コマンドエコー）
   └─ カレントディレクトリをsource_dirに設定
4. スクリプトの構築
   ├─ SHARED_PRESCRIPT（共有関数定義）
   └─ 指定されたscript
5. 標準入力からスクリプトを渡して実行
6. 実行結果の返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{scriptが指定されているか}
    B -->|No| C[終了（スクリプトなし）]
    B -->|Yes| D[bashコマンド構築]
    D --> E[SHARED_PRESCRIPT + script を結合]
    E --> F[bash -ex 実行]
    F --> G{実行成功か}
    G -->|Yes| H[終了（成功）]
    G -->|No| I[エラー返却]
    C --> J[終了]
    H --> J
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | bash実行 | bashシェルで実行（-exオプション） | 常時 |
| BR-02 | 共有関数 | SHARED_PRESCRIPTの関数が使用可能 | 常時 |
| BR-03 | カレントディレクトリ | source_dirで実行 | 常時 |
| BR-04 | エラー時停止 | -eオプションによりエラー発生時に停止 | 常時 |

### 計算ロジック

**SHARED_PRESCRIPTで提供される関数**：
- `DYNAMIC_INIT`: 動的リンクビルドの設定を適用
- `DYNAMIC_STATIC_INIT`: 動的・静的両方のビルド設定
- `autotools_recursive_regenerate`: 再帰的にautoreconfを実行
- `GNU_CONFIG_GET`: GNU configファイルをダウンロード

## データベース操作仕様

本機能ではデータベース操作は行わない（シェルスクリプト実行のみ）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 実行失敗 | bashコマンドがエラー終了 | スクリプト内容を確認 |
| - | コマンド不在 | スクリプト内のコマンドが存在しない | 依存ツールをインストール |

### リトライ仕様

リトライは行わない（スクリプトエラーは即時返却）

## トランザクション仕様

特になし（スクリプト実行は元に戻せない）

## パフォーマンス要件

- スクリプト実行時間はスクリプト内容に依存
- autoreconfは数秒〜数十秒程度

## セキュリティ考慮事項

- スクリプト内容の信頼性：recipe.toml内の信頼できるスクリプトのみ実行
- 環境変数の漏洩防止

## 備考

- -exオプションにより、実行されるコマンドがログに出力される
- SHARED_PRESCRIPTはクロスコンパイル設定に便利な関数を提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、スクリプト設定を表現するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | SourceRecipe内のscriptフィールド |

**読解のコツ**:
- scriptはOption<String>型で、シェルスクリプト文字列
- Gitソース、Tarソースの両方でscript指定可能

**主要処理フロー**:
- **51-52行目**: Git sourceのscript
- **64-65行目**: Tar sourceのscript

#### Step 2: 共有関数を理解する

スクリプト内で使用可能な共有関数を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script.rs | `src/cook/script.rs` | SHARED_PRESCRIPT定義 |

**主要処理フロー**:
- **1-79行目**: SHARED_PRESCRIPT
  - DYNAMIC_INIT関数: 動的リンク設定
  - DYNAMIC_STATIC_INIT関数: 両方の設定
  - autotools_recursive_regenerate関数: autoreconf再帰実行
  - GNU_CONFIG_GET関数: config.subダウンロード

#### Step 3: スクリプト実行処理を理解する

スクリプト実行の詳細を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fetch.rs | `src/cook/fetch.rs` | fetch_apply_patches()内のscript実行部分 |

**主要処理フロー**:
- **636-645行目**: scriptの実行
  - bash -exコマンドの構築
  - current_dir(source_dir)の設定
  - SHARED_PRESCRIPT + scriptの結合
  - run_command_stdin()での実行

### プログラム呼び出し階層図

```
fetch(recipe, logger)
    │
    └─ fetch_apply_patches(recipe_dir, patches, script, source_dir, logger)
           │
           └─ if let Some(script) = script
                  │
                  ├─ Command::new("bash")
                  │   ├─ .arg("-ex")
                  │   └─ .current_dir(source_dir)
                  │
                  └─ run_command_stdin(command, full_script, logger)
                         │
                         └─ full_script = SHARED_PRESCRIPT + "\n" + script
                                │
                                ├─ DYNAMIC_INIT()
                                ├─ DYNAMIC_STATIC_INIT()
                                ├─ autotools_recursive_regenerate()
                                └─ GNU_CONFIG_GET()
```

### データフロー図

```
[入力]                       [処理]                              [出力]

recipe.toml
  └─ source.script ──────▶ スクリプト取得 ───────────────────▶ String

script.rs
  └─ SHARED_PRESCRIPT ───▶ 関数定義取得 ─────────────────────▶ String
                                │
                                ▼
                          スクリプト結合 ─────────────────────▶ 完全スクリプト
                                │
                                ▼
                          bash -ex 実行 ──────────────────────▶ 実行結果
                                │
                                ▼
source/
  └─ 修正前ファイル ──────▶ スクリプト処理 ───────────────────▶ 生成/修正ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fetch.rs | `src/cook/fetch.rs` | ソース | スクリプト実行のメインロジック |
| recipe.rs | `src/recipe.rs` | ソース | scriptフィールド定義 |
| script.rs | `src/cook/script.rs` | ソース | SHARED_PRESCRIPT定義 |
| fs.rs | `src/cook/fs.rs` | ソース | run_command_stdin()関数 |
| recipe.toml | 各レシピディレクトリ | 設定 | source.scriptの設定 |
