# 機能設計書 9-Cargoビルド

## 概要

本ドキュメントは、Redox OSビルドシステムにおけるRustプロジェクトをcargo installでビルド・インストールする機能の設計を記載する。template=cargoによるRustパッケージのクロスコンパイルについて詳述する。

### 本機能の処理概要

Cargoビルド機能は、Rustで書かれたプロジェクトをcargo installコマンドを使用してビルドし、ステージディレクトリにインストールする機能である。Redox OS向けのクロスコンパイルを自動的に設定し、依存関係の解決からビルド、インストールまでを一貫して行う。

**業務上の目的・背景**：Redox OSのユーザーランドアプリケーションの多くはRustで書かれている。これらをRedox OS向けにクロスコンパイルするために、適切な環境変数とフラグを設定したcargo installを実行する必要がある。この機能により、Rustプロジェクトのビルドが自動化され、一貫したビルド環境が提供される。

**機能の利用シーン**：
- Redox OS向けRustアプリケーションのビルド
- coreutils、ion shell等のRedox OSコンポーネントのビルド
- サードパーティRustライブラリのビルド

**主要な処理内容**：
1. 依存パッケージのsysroot構築
2. ビルドスクリプトの構築
3. cookbook_cargo関数によるビルド・インストール
4. ビルド後処理（strip、ファイル削除）

**関連システム・外部連携**：
- cargo：Rustのパッケージマネージャ・ビルドシステム
- cookbook_redoxer：クロスコンパイル環境

**権限による制御**：特になし（ファイルシステムの書き込み権限が必要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | repo cookコマンド画面 | API連携 | template=cargoでのRustプロジェクトビルド |

## 機能種別

ビルド処理 / 外部コマンド実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| template | "cargo" | Yes | ビルドテンプレート指定 | - |
| package_path | Option<String> | No | Cargo.tomlがあるサブディレクトリ | - |
| cargoflags | String | No | 追加のcargoフラグ | - |

### 入力データソース

- recipe.toml: buildセクションのtemplate="cargo"と関連フラグ
- source/Cargo.toml: Rustプロジェクト定義

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ビルド成果物 | Files | コンパイルされたバイナリ |
| インストール先 | Directory | stage/usr/bin/等 |

### 出力先

- ファイルシステム：`{レシピディレクトリ}/target/{target}/stage/usr/`

## 処理フロー

### 処理シーケンス

```
1. 依存パッケージのsysroot構築
   └─ 依存pkgarをsysrootディレクトリに展開
2. ビルドスクリプトの構築
   ├─ BUILD_PRESCRIPT（環境変数設定）
   ├─ SHARED_PRESCRIPT（共有関数）
   ├─ DYNAMIC_INIT実行
   └─ cookbook_cargo関数呼び出し
3. cookbook_redoxerによるビルド環境設定
   └─ クロスコンパイル用の環境変数とターゲット設定
4. cargo installの実行
   ├─ --path: ソースディレクトリ
   ├─ --root: ステージディレクトリ
   ├─ --locked: Cargo.lockを使用
   ├─ --no-track: .crates.tomlを作成しない
   └─ -j: 並列ジョブ数
5. ビルド後処理
   ├─ バイナリのstrip
   ├─ .laファイルの削除
   └─ .crates*.tomlの削除
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[sysroot構築]
    B --> C[toolchain構築（非ホストの場合）]
    C --> D[stage.tmp作成]
    D --> E[build dir作成]
    E --> F[ビルドスクリプト構築]
    F --> G[cookbook_redoxer env bash -e 実行]
    G --> H[DYNAMIC_INIT]
    H --> I[cookbook_cargo実行]
    I --> J{ビルド成功か}
    J -->|No| K[エラー返却]
    J -->|Yes| L[BUILD_POSTSCRIPT実行]
    L --> M[オプショナルパッケージ分離]
    M --> N[stage.tmpをstageにリネーム]
    N --> O[auto_deps計算]
    O --> P[終了]
    K --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | DYNAMIC_INIT | 動的リンク設定を適用（ターゲットサポート時） | 常時 |
| BR-02 | --locked | Cargo.lockを使用して再現可能なビルド | 常時 |
| BR-03 | --no-track | cargo install管理ファイルを作成しない | 常時 |
| BR-04 | クロスコンパイル | cookbook_redoxerでターゲット環境設定 | 非Redox環境時 |
| BR-05 | 並列ビルド | COOKBOOK_MAKE_JOBS数で並列実行 | 常時 |

### 計算ロジック

**cookbook_cargo関数**（script.rs）:
```bash
function cookbook_cargo {
    "${COOKBOOK_CARGO}" install \
        --path "${COOKBOOK_SOURCE}/${PACKAGE_PATH}" \
        --root "${COOKBOOK_STAGE}/usr" \
        --locked \
        --no-track \
        ${install_flags} \
        -j "${COOKBOOK_MAKE_JOBS}" "$@"
}
```

## データベース操作仕様

本機能ではデータベース操作は行わない（ファイルシステムとcargoコマンドのみ）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | コンパイルエラー | Rustコードにエラーがある | ソースコードを修正 |
| - | 依存関係エラー | crateが見つからない | cargo fetchを実行 |
| - | リンクエラー | ライブラリが見つからない | 依存パッケージを確認 |

### リトライ仕様

- TUIモードではユーザーにリトライ/スキップ/終了を選択させる

## トランザクション仕様

- stage.tmpへの一時ビルド後にstageへアトミックリネーム
- 失敗時はstage.tmpを削除

## パフォーマンス要件

- 並列ビルドによる高速化（COOKBOOK_MAKE_JOBS）
- 増分ビルド対応（CARGO_TARGET_DIR）

## セキュリティ考慮事項

- Cargo.lockによる依存関係の固定
- crates.ioからの依存取得（信頼性）

## 備考

- Redox環境ではcookbook_redoxerの代わりに直接cargoを使用
- --offlineフラグでオフラインビルド対応
- --debugフラグでデバッグビルド対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Cargoビルド設定を表現するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | BuildKind::Cargo variantの定義 |

**読解のコツ**:
- `#[serde(tag = "template")]`によりtemplate値でビルドタイプが判定される
- template="cargo"でBuildKind::Cargoとしてデシリアライズされる

**主要処理フロー**:
- **99-106行目**: BuildKind::Cargo variant定義
  - package_path: Option<String> - Cargo.tomlのサブディレクトリ
  - cargoflags: String - 追加フラグ

#### Step 2: ビルド処理を理解する

ビルド処理のメインロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cook_build.rs | `src/cook/cook_build.rs` | build()関数のCargo処理部分 |

**主要処理フロー**:
- **342-351行目**: Cargoビルドスクリプトの生成
  - DYNAMIC_INITの呼び出し
  - PACKAGE_PATHの設定
  - cookbook_cargo関数の呼び出し
  - cargoflags の追加

#### Step 3: スクリプト関数を理解する

cookbook_cargo等のヘルパー関数を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | script.rs | `src/cook/script.rs` | BUILD_PRESCRIPT, cookbook_cargo関数 |

**主要処理フロー**:
- **81-306行目**: BUILD_PRESCRIPT
  - **93行目**: CARGO_TARGET_DIRの設定
  - **134-144行目**: cookbook_cargo関数
  - **146-160行目**: cookbook_cargo_examples関数
  - **162-176行目**: cookbook_cargo_packages関数

### プログラム呼び出し階層図

```
build(recipe_dir, source_dir, target_dir, name, recipe, ...)
    │
    ├─ sysroot構築 (build_deps_dir)
    │   └─ pkgar::extract()
    │
    ├─ スクリプト生成
    │   ├─ BuildKind::Cargo処理
    │   │   └─ "DYNAMIC_INIT\nPACKAGE_PATH={} cookbook_cargo {cargoflags}"
    │   │
    │   └─ 環境変数設定
    │       ├─ TARGET
    │       ├─ COOKBOOK_BUILD
    │       ├─ COOKBOOK_SOURCE
    │       ├─ COOKBOOK_SYSROOT
    │       └─ COOKBOOK_MAKE_JOBS
    │
    ├─ cookbook_redoxer実行（非Redox時）
    │   └─ cookbook_redoxer env bash -e
    │
    └─ スクリプト実行
        │
        ├─ BUILD_PRESCRIPT（環境設定）
        │   └─ COOKBOOK_CARGO="${COOKBOOK_REDOXER}"
        │
        ├─ SHARED_PRESCRIPT（共有関数）
        │   └─ DYNAMIC_INIT()
        │
        ├─ cookbook_cargo()
        │   └─ cargo install --path ... --root ... --locked --no-track -j N
        │
        └─ BUILD_POSTSCRIPT（後処理）
            ├─ strip
            ├─ .la削除
            └─ .crates*.toml削除
```

### データフロー図

```
[入力]                       [処理]                              [出力]

recipe.toml
  └─ build.template=cargo ─▶ BuildKind::Cargo判定 ─────────▶ スクリプト生成

source/
  └─ Cargo.toml ────────────▶ cargo install ───────────────▶ コンパイル
  └─ src/*.rs                     │
                                  │
sysroot/                          │
  └─ lib/*.so ──────────────▶ リンク ─────────────────────▶ バイナリ
                                  │
                                  ▼
                            stage/usr/bin/ ────────────────▶ インストール済みバイナリ
                                  │
                                  ▼
                            BUILD_POSTSCRIPT ──────────────▶ strip済みバイナリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cook_build.rs | `src/cook/cook_build.rs` | ソース | ビルドのメインロジック |
| recipe.rs | `src/recipe.rs` | ソース | BuildKind::Cargo定義 |
| script.rs | `src/cook/script.rs` | ソース | BUILD_PRESCRIPT, cookbook_cargo関数 |
| cookbook_redoxer.rs | `src/bin/cookbook_redoxer.rs` | ソース | クロスコンパイル環境設定 |
| recipe.toml | 各レシピディレクトリ | 設定 | build.template="cargo"設定 |
| Cargo.toml | source/ | 設定 | Rustプロジェクト定義 |
