---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-レシピ解析

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値（10ms）の根拠なし
  2. **pkgクレートの詳細仕様**：外部クレートのため完全な検証不可
  3. **バージョン推測の正確性**：限定的なケースでのみ動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/recipe.rs` 18-67行目 - SourceRecipe enum定義
- E-02: `src/recipe.rs` 90-128行目 - BuildKind enum定義
- E-03: `src/recipe.rs` 136-144行目 - BuildRecipe構造体定義
- E-04: `src/recipe.rs` 146-151行目 - PackageRecipe構造体定義
- E-05: `src/recipe.rs` 162-174行目 - Recipe構造体定義
- E-06: `src/recipe.rs` 195-204行目 - CookRecipe構造体定義
- E-07: `src/recipe.rs` 207-216行目 - Recipe::new()関数
- E-08: `src/recipe.rs` 227-260行目 - CookRecipe::new()関数
- E-09: `src/recipe.rs` 262-268行目 - CookRecipe::from_name()関数
- E-10: `src/recipe.rs` 270-283行目 - CookRecipe::from_path()関数
- E-11: `src/recipe.rs` 285-383行目 - new_recursive()関数
- E-12: `src/recipe.rs` 385-401行目 - get_build_deps_recursive()関数
- E-13: `src/recipe.rs` 403-420行目 - get_package_deps_recursive()関数
- E-14: `src/recipe.rs` 441-471行目 - apply_filesystem_config()関数
- E-15: `src/recipe.rs` 70-86行目 - guess_version()関数
- E-16: `src/lib.rs` 9行目 - WALK_DEPTH定数（16）
- E-17: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報
- E-18: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourceRecipeはGit/Tar/Path/SameAsの4種類 | E-01 | ○ |
| C-02 | BuildKindはNone/Remote/Cargo/Configure/Cmake/Meson/Customの7種類 | E-02 | ○ |
| C-03 | BuildRecipeはkind, dependencies, dev_dependenciesを持つ | E-03 | ○ |
| C-04 | PackageRecipeはdependencies, versionを持つ | E-04 | ○ |
| C-05 | Recipeはsource, build, package, optional_packagesを持つ | E-05 | ○ |
| C-06 | CookRecipeはname, dir, recipe, target, is_deps, ruleを持つ | E-06 | ○ |
| C-07 | Recipe::new()でTOMLファイルを読み込みパースする | E-07 | ○ |
| C-08 | CookRecipe::new()でターゲット判定と依存関係変換を行う | E-08 | ○ |
| C-09 | CookRecipe::from_name()でパッケージ名からレシピを検索 | E-09 | ○ |
| C-10 | CookRecipe::from_path()でパスからレシピを読み込み | E-10 | ○ |
| C-11 | new_recursive()で依存関係を再帰的に解析 | E-11 | ○ |
| C-12 | get_build_deps_recursive()でビルド依存関係を取得 | E-12 | ○ |
| C-13 | get_package_deps_recursive()でパッケージ依存関係を取得 | E-13 | ○ |
| C-14 | apply_filesystem_config()でsource/local/binary/ignoreルールを適用 | E-14 | ○ |
| C-15 | guess_version()でTar URLからバージョンを正規表現で抽出 | E-15 | ○ |
| C-16 | 依存関係解析の最大深度は16階層 | E-16 | ○ |
| C-17 | TUIメイン画面との連携がある | E-17 | ○ |
| C-18 | repo fetchコマンドとの連携がある | E-17 | ○ |
| C-19 | repo cookコマンドとの連携がある | E-17 | ○ |
| C-20 | ファイル不在時にFileMissingエラー | E-07 | ○ |
| C-21 | パースエラー時にParseエラー | E-07 | ○ |
| C-22 | serde(untagged)でソースタイプを自動判定 | E-01 | ○ |
| C-23 | serde(tag="template")でビルドタイプを識別 | E-02 | ○ |
| C-24 | ホストパッケージの依存関係はホスト用に変換される | E-08 | ○ |
| C-25 | 単一レシピの解析は10ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（10ms）の根拠が不足
  - 候補：ベンチマークテスト結果 / 実測データ / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造定義は明確にソースコードから確認可能
- 0: 低リスク - エラー処理はソースコードで明確に定義
- 1: 中リスク - パフォーマンス要件は実測による検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] SourceRecipeの4種類が実際のユースケースを網羅しているか確認
- [ ] BuildKindの7種類がビルドテンプレートを網羅しているか確認
- [ ] 依存関係解析の深度16が適切か確認
- [ ] filesystem設定の4つのルール（source/local/binary/ignore）の動作確認
- [ ] パフォーマンス要件の妥当性を実測で確認
