---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-CMakeビルド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **CC_WRAPPERのサポート**：実装確認済みだがドキュメント不足
  2. **パフォーマンス要件**：デフォルト並列数の根拠が不明確
  3. **セキュリティ考慮事項**：設計意図の明文化なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/recipe.rs` 113-118行目 - BuildKind::Cmake定義
- E-02: `src/cook/script.rs` 194-245行目 - cookbook_cmake関数
- E-03: `src/cook/script.rs` 196-200行目 - COOKBOOK_CMAKE_FLAGS デフォルト値
- E-04: `src/cook/script.rs` 27-32行目 - DYNAMIC_INIT内のCMAKE_FLAGS
- E-05: `src/cook/script.rs` 207-221行目 - cross_file.cmake生成
- E-06: `src/cook/script.rs` 223-227行目 - CC_WRAPPER対応
- E-07: `src/cook/cook_build.rs` 356-359行目 - Cmakeビルドスクリプト生成
- E-08: `src/cook/cook_build.rs` 418-422行目 - スクリプト結合と実行
- E-09: `src/cook/fs.rs` 220-252行目 - run_command_stdin関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | template="cmake"でCMakeビルドが選択される | E-01, E-07 | ○ |
| C-02 | cross_file.cmakeが自動生成される | E-05 | ○ |
| C-03 | Ninjaジェネレータが使用される | E-02 (238行目 -GNinja) | ○ |
| C-04 | DESTDIR経由でインストールされる | E-02 (244行目) | ○ |
| C-05 | デフォルトは静的リンク設定 | E-03 | ○ |
| C-06 | DYNAMIC_INITで動的リンクに切替可能 | E-04 | ○ |
| C-07 | cmakeflagsでカスタムフラグを追加可能 | E-01, E-07 | ○ |
| C-08 | TARGETからシステム名を判定する | E-02 (202-206行目) | ○ |
| C-09 | CMAKE_FIND_ROOT_PATHでsysrootを指定 | E-05 (211行目) | ○ |
| C-10 | CC_WRAPPERでccache等をサポート | E-06 | ○ |
| C-11 | /usrがインストールプレフィックス | E-02 (235行目) | ○ |
| C-12 | -Wno-devで警告抑制 | E-02 (239行目) | ○ |
| C-13 | BUILD_PRESCRIPT等が結合される | E-08 | ○ |
| C-14 | bashでスクリプト実行される | E-09 | ○ |
| C-15 | 並列ビルドはCOOKBOOK_MAKE_JOBSで制御 | E-02 (243行目) | ○ |
| C-16 | CMAKE_CROSSCOMPILING=Trueが設定される | E-02 (231行目) | ○ |
| C-17 | GNU_TARGETからコンパイラ名を生成 | E-05 (208-210行目) | ○ |
| C-18 | デフォルト並列数はCPUコア数 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：COOKBOOK_MAKE_JOBSのデフォルト値がCPUコア数であることの根拠がソースコードから直接確認できない
  - 候補：CLI引数処理部分 / config.rs / 呼び出し元のrepo.rs

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CMakeビルドの基本動作は十分にコードで裏付けられている
- 1: 中リスク - パフォーマンス要件のデフォルト値の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] C-18のデフォルト並列数の根拠を確認（config.rsまたはCLI処理部分）
- [ ] cross_file.cmakeの生成内容が実際のクロスコンパイル要件を満たすか確認
- [ ] DYNAMIC_INIT呼び出しの前提条件（動的リンク非対応ターゲット）の説明が十分か確認
