---
generated_at: 2026-01-22 15:35:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-Mesonビルド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/recipe.rs` 119-124行目 - BuildKind::Meson定義
- E-02: `src/cook/script.rs` 247-254行目 - COOKBOOK_MESON_FLAGS デフォルト値
- E-03: `src/cook/script.rs` 34-40行目 - DYNAMIC_INIT内のMESON_FLAGS
- E-04: `src/cook/script.rs` 255-305行目 - cookbook_meson関数
- E-05: `src/cook/script.rs` 256-264行目 - [binaries]セクション生成
- E-06: `src/cook/script.rs` 266-270行目 - [host_machine]セクション生成
- E-07: `src/cook/script.rs` 272-275行目 - [paths]セクション生成
- E-08: `src/cook/script.rs` 277-282行目 - [properties]セクション生成
- E-09: `src/cook/script.rs` 284-295行目 - 環境変数unset処理
- E-10: `src/cook/script.rs` 297-304行目 - meson setup/ninja実行
- E-11: `src/cook/cook_build.rs` 360-363行目 - Mesonビルドスクリプト生成

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | template="meson"でMesonビルドが選択される | E-01, E-11 | ○ |
| C-02 | cross_file.txtが自動生成される | E-04, E-05, E-06, E-07, E-08 | ○ |
| C-03 | [binaries]セクションにコンパイラ情報を含む | E-05 | ○ |
| C-04 | [host_machine]セクションにターゲット情報を含む | E-06 | ○ |
| C-05 | [paths]セクションでインストール先を指定 | E-07 | ○ |
| C-06 | [properties]セクションでsysrootとフラグを設定 | E-08 | ○ |
| C-07 | 環境変数がunsetされる | E-09 | ○ |
| C-08 | デフォルトは静的リンク設定 | E-02 (252行目 -Ddefault_library=static) | ○ |
| C-09 | DYNAMIC_INITで動的リンクに切替可能 | E-03 (38行目 -Ddefault_library=shared) | ○ |
| C-10 | mesonflagsでカスタムフラグを追加可能 | E-01, E-11 | ○ |
| C-11 | buildtypeはrelease | E-02 (249行目), E-03 (35行目) | ○ |
| C-12 | --stripオプションが使用される | E-02 (251行目), E-03 (37行目) | ○ |
| C-13 | --wrap-mode nofallbackが使用される | E-02 (250行目), E-03 (36行目) | ○ |
| C-14 | needs_exe_wrapper = trueが設定される | E-08 (278行目) | ○ |
| C-15 | sys_rootでsysrootパスを指定 | E-08 (279行目) | ○ |
| C-16 | glib-compile-resourcesはホストのものを使用 | E-05 (263行目) | ○ |
| C-17 | llvm-configはターゲット用を指定 | E-05 (262行目) | ○ |
| C-18 | endianはlittleで固定 | E-06 (270行目) | ○ |
| C-19 | meson setup後にninja, ninja installを実行 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Mesonビルドの全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] cross_file.txtの各セクションの内容がMesonのクロスコンパイル仕様に準拠しているか確認
- [ ] 環境変数のunset処理がすべての必要な変数をカバーしているか確認
- [ ] DYNAMIC_STATIC_INIT関数（両方ビルド）の動作も必要に応じて確認
