---
generated_at: 2026-01-22 15:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-カスタムビルド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/recipe.rs` 125-127行目 - BuildKind::Custom定義
- E-02: `src/cook/cook_build.rs` 364行目 - Customスクリプト取得
- E-03: `src/cook/cook_build.rs` 418-422行目 - スクリプト結合
- E-04: `src/cook/cook_build.rs` 369-416行目 - コマンド構築
- E-05: `src/cook/cook_build.rs` 378行目 - bash -exオプション（verbose時）
- E-06: `src/cook/script.rs` 81-306行目 - BUILD_PRESCRIPT定義
- E-07: `src/cook/script.rs` 1-79行目 - SHARED_PRESCRIPT定義
- E-08: `src/cook/script.rs` 308-344行目 - BUILD_POSTSCRIPT定義
- E-09: `src/cook/script.rs` 82-90行目 - PATH設定
- E-10: `src/cook/script.rs` 97-102行目 - CFLAGS、LDFLAGS設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | template="custom"でカスタムビルドが選択される | E-01, E-02 | ○ |
| C-02 | scriptフィールドが必須 | E-01 (scriptフィールドは非Option型) | ○ |
| C-03 | スクリプトは4つのパートを結合して作成 | E-03 | ○ |
| C-04 | bash -eでエラー時即座終了 | E-04 (378行目) | ○ |
| C-05 | verboseモードで-exオプション使用 | E-05 | ○ |
| C-06 | cookbook_redoxer経由でクロスコンパイル環境 | E-04 (385-392行目) | ○ |
| C-07 | Redox上では直接bash実行 | E-04 (379-383行目) | ○ |
| C-08 | BUILD_PRESCRIPTでPATH設定 | E-09 | ○ |
| C-09 | CFLAGS、LDFLAGSが設定される | E-10 | ○ |
| C-10 | cookbook_*関数が利用可能 | E-06 (134-305行目で各関数定義) | ○ |
| C-11 | DYNAMIC_INIT関数が利用可能 | E-07 (3-46行目) | ○ |
| C-12 | BUILD_POSTSCRIPTでストリップ処理 | E-08 (309-316行目) | ○ |
| C-13 | BUILD_POSTSCRIPTで.laファイル削除 | E-08 (318-325行目) | ○ |
| C-14 | BUILD_POSTSCRIPTでcargoファイル削除 | E-08 (327-334行目) | ○ |
| C-15 | BUILD_POSTSCRIPTでAppStreamメタデータ更新 | E-08 (336-343行目) | ○ |
| C-16 | COOKBOOK_MAKE_JOBS変数が利用可能 | E-04 (408行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カスタムビルドの全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] カスタムスクリプトで利用可能な環境変数の一覧が網羅されているか確認
- [ ] SHARED_PRESCRIPTとBUILD_PRESCRIPTの提供する関数が正確に文書化されているか確認
- [ ] セキュリティ考慮事項（任意スクリプト実行のリスク）が十分に説明されているか確認
