---
generated_at: 2026-01-22 15:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-依存関係解決

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/recipe.rs` 136-144行目 - BuildRecipe構造体定義
- E-02: `src/recipe.rs` 146-151行目 - PackageRecipe構造体定義
- E-03: `src/recipe.rs` 195-204行目 - CookRecipe構造体定義
- E-04: `src/recipe.rs` 285-383行目 - new_recursive関数
- E-05: `src/recipe.rs` 385-400行目 - get_build_deps_recursive関数
- E-06: `src/recipe.rs` 403-420行目 - get_package_deps_recursive関数
- E-07: `src/recipe.rs` 228-260行目 - CookRecipe::new関数
- E-08: `src/recipe.rs` 295-296行目 - 再帰深さチェック
- E-09: `src/recipe.rs` 298-300行目 - BTreeSet使用
- E-10: `src/recipe.rs` 231-251行目 - ホストパッケージ変換

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | build.dependenciesでビルド依存を定義 | E-01 (141行目) | ○ |
| C-02 | build.dev-dependenciesで開発依存を定義 | E-01 (142-143行目) | ○ |
| C-03 | package.dependenciesで実行時依存を定義 | E-02 (149行目) | ○ |
| C-04 | get_build_deps_recursiveでビルド依存を再帰取得 | E-05 | ○ |
| C-05 | get_package_deps_recursiveで実行時依存を再帰取得 | E-06 | ○ |
| C-06 | new_recursiveで実際の再帰処理を実行 | E-04 | ○ |
| C-07 | 再帰深さ制限がある | E-08 | ○ |
| C-08 | BTreeSetで重複排除 | E-09 | ○ |
| C-09 | ホストパッケージ時に依存をホスト用に変換 | E-10 | ○ |
| C-10 | 自分自身への依存は除外 | E-07 (234行目 None条件) | ○ |
| C-11 | 依存パッケージは先に配置 | E-04 (320-325, 344-349, 368-373行目) | ○ |
| C-12 | PackageNotFoundエラーを返す | E-04 (302行目 from_name呼び出し) | ○ |
| C-13 | Recursionエラーを返す | E-08 (296行目) | ○ |
| C-14 | collect_selfで自分を結果に含めるか制御 | E-04 (376-379行目) | ○ |
| C-15 | recurse_build_depsでビルド依存の再帰を制御 | E-04 (304-326行目) | ○ |
| C-16 | recurse_dev_build_depsで開発依存の再帰を制御 | E-04 (328-350行目) | ○ |
| C-17 | recurse_package_depsで実行時依存の再帰を制御 | E-04 (352-374行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 依存関係解決の全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] WALK_DEPTHの値（lib.rs）を確認し、適切な深さ制限か検証
- [ ] ホストパッケージ変換ロジックが意図通りに動作するか確認
- [ ] エラーメッセージに依存チェーンが含まれているか確認（append_recursion呼び出し箇所）
