---
generated_at: 2026-01-22 15:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-自動依存関係検出

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/recipe.rs` 500-503行目 - AutoDeps構造体定義
- E-02: `src/cook/cook_build.rs` 574-611行目 - build_auto_deps関数
- E-03: `src/cook/cook_build.rs` 24-154行目 - auto_deps_from_dynamic_linking関数
- E-04: `src/cook/cook_build.rs` 156-168行目 - auto_deps_from_static_package_deps関数
- E-05: `src/cook/cook_build.rs` 37-41行目 - 検索ディレクトリ初期化
- E-06: `src/cook/cook_build.rs` 44-77行目 - ディレクトリ再帰走査
- E-07: `src/cook/cook_build.rs` 84-107行目 - ELF解析とDT_NEEDED抽出
- E-08: `src/cook/cook_build.rs` 111-113行目 - プリインストール除外
- E-09: `src/cook/cook_build.rs` 115-145行目 - pkgarライブラリ検索
- E-10: `src/cook/cook_build.rs` 583-588行目 - キャッシュチェック

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AutoDepsはBTreeSet<PackageName>を持つ | E-01 | ○ |
| C-02 | usr/bin, usr/games, usr/lib, usr/libexecを検索 | E-05 | ○ |
| C-03 | 訪問済みセットで無限ループを防止 | E-06 (48-61行目) | ○ |
| C-04 | objectクレートでELFを解析 | E-07 (84-85行目) | ○ |
| C-05 | DT_NEEDEDエントリを抽出 | E-07 (91-104行目) | ○ |
| C-06 | libc.so.6を除外 | E-08 (111行目) | ○ |
| C-07 | libgcc_s.so.1を除外 | E-08 (111行目) | ○ |
| C-08 | libstdc++.so.6を除外 | E-08 (111行目) | ○ |
| C-09 | pkgarからライブラリ提供元を検索 | E-09 | ○ |
| C-10 | lib/とusr/lib/両方を検索 | E-09 (128行目) | ○ |
| C-11 | Ed25519公開鍵でpkgar検証 | E-09 (116行目) | ○ |
| C-12 | キャッシュファイルの存在と新しさをチェック | E-10 | ○ |
| C-13 | 静的パッケージ依存も解析 | E-04 | ○ |
| C-14 | dynamic_depsとstatic_depsをマージ | E-02 (600-602行目) | ○ |
| C-15 | auto_deps.tomlにキャッシュ保存 | E-02 (607行目) | ○ |
| C-16 | verboseモードでDT_NEEDEDをログ出力 | E-07 (100-102行目) | ○ |
| C-17 | verboseモードでマッチパッケージをログ出力 | E-09 (136-138行目) | ○ |
| C-18 | missingライブラリをverboseモードでログ | E-03 (147-149行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 自動依存関係検出の全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] プリインストール除外リスト（libc, libgcc_s, libstdc++）が適切か確認
- [ ] 検索対象ディレクトリ（usr/bin, usr/lib等）が網羅的か確認
- [ ] ファイルシステムループ検出のテストケース（tests module）の内容を確認
