---
generated_at: 2026-01-22 15:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-sysroot構築

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/cook_build.rs` 180行目 - sysroot_dir定義
- E-02: `src/cook/cook_build.rs` 279-295行目 - build_deps_dir呼び出し
- E-03: `src/cook/cook_build.rs` 511-572行目 - build_deps_dir関数
- E-04: `src/cook/cook_build.rs` 519-530行目 - 鮮度チェック
- E-05: `src/cook/cook_build.rs` 532-538行目 - ディレクトリ構造初期化
- E-06: `src/cook/cook_build.rs` 540-546行目 - シンボリックリンク作成
- E-07: `src/cook/cook_build.rs` 548-563行目 - pkgar展開とタグファイル
- E-08: `src/cook/cook_build.rs` 566行目 - アトミックリネーム
- E-09: `src/cook/fs.rs` 103-113行目 - symlink関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sysrootはtarget_dir.join("sysroot")で決定 | E-01 | ○ |
| C-02 | BuildKind::Remote以外でsysroot構築 | E-02 (279行目) | ○ |
| C-03 | ホストパッケージかどうかでpkgarsを選択 | E-02 (284-288行目) | ○ |
| C-04 | .tagsディレクトリで更新時刻を管理 | E-04 (520行目) | ○ |
| C-05 | ソースまたは依存が新しければ再構築 | E-04 (522-523行目) | ○ |
| C-06 | 未展開パッケージがあれば再構築 | E-04 (524-526行目) | ○ |
| C-07 | sysroot.tmpで構築後にリネーム | E-03 (534行目), E-08 | ○ |
| C-08 | .tags, usr/{bin,include,lib,share}を作成 | E-05 | ○ |
| C-09 | bin -> usr/binのシンボリックリンク作成 | E-06 (545行目) | ○ |
| C-10 | lib -> usr/libのシンボリックリンク作成 | E-06 (545行目) | ○ |
| C-11 | include -> usr/includeのシンボリックリンク作成 | E-06 (545行目) | ○ |
| C-12 | share -> usr/shareのシンボリックリンク作成 | E-06 (545行目) | ○ |
| C-13 | pkgar::extractでパッケージ展開 | E-07 (553-562行目) | ○ |
| C-14 | タグファイルを作成して展開済みを追跡 | E-07 (550-552行目) | ○ |
| C-15 | verboseモードでキャッシュ使用ログ | E-02 (292-294行目) | ○ |
| C-16 | Ed25519公開鍵で検証 | E-07 (548行目 pkey_path) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - sysroot構築の全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] シンボリックリンクの4つ（bin, include, lib, share）がすべて作成されているか確認
- [ ] アトミックリネームの前に例外が発生した場合の挙動を確認
- [ ] ホストパッケージ用のtoolchain構築との分離が正しく行われているか確認
