---
generated_at: 2026-01-22 16:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-ステージディレクトリ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/recipe.rs` 153-159行目 - OptionalPackageRecipe構造体
- E-02: `src/cook/cook_build.rs` 483-498行目 - get_stage_dirs関数
- E-03: `src/cook/cook_build.rs` 247-276行目 - ステージ更新判定
- E-04: `src/cook/cook_build.rs` 424-449行目 - ファイル分離処理
- E-05: `src/cook/cook_build.rs` 464-481行目 - remove_stage_dir関数
- E-06: `src/cook/fs.rs` 66-101行目 - move_dir_all_fn関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OptionalPackageRecipeにname, files, dependenciesがある | E-01 | ○ |
| C-02 | get_stage_dirsでステージパスリストを取得 | E-02 | ○ |
| C-03 | オプショナルパッケージ用のstage.{name}を追加 | E-02 (492-494行目) | ○ |
| C-04 | メインパッケージ用のstageを最後に追加 | E-02 (495-496行目) | ○ |
| C-05 | pkgarファイルの更新時刻でstage_modified計算 | E-03 (248-255行目) | ○ |
| C-06 | ソース、依存より古ければステージ削除 | E-03 (257-266行目) | ○ |
| C-07 | remove_stage_dirでpkgar, toml, filesも削除 | E-05 | ○ |
| C-08 | stage.tmpで構築 | E-03 (316行目) | ○ |
| C-09 | globset::Globでパターンマッチ | E-04 (430行目) | ○ |
| C-10 | move_dir_all_fnでファイル移動 | E-04 (434-445行目), E-06 | ○ |
| C-11 | stage.tmp -> stageへリネーム | E-04 (448行目) | ○ |
| C-12 | COOKBOOK_CROSS_TARGETでパス変更可能 | E-02 (485-490行目) | ○ |
| C-13 | マッチしないファイルはメインに残る | E-04 (436-442行目のNone返却時) | ○ |
| C-14 | 最初にマッチしたパターンのパッケージに移動 | E-04 (437-440行目のループ構造) | ○ |
| C-15 | clean_target時もステージは保持 | E-03 (271-276行目) | ○ |
| C-16 | COOKBOOK_STAGEでビルドスクリプトに渡す | E-03 (400行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ステージディレクトリ管理の全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] globパターンの優先順位（先着順）が意図通りか確認
- [ ] remove_stage_dirで削除される関連ファイル（pkgar, toml, files）が網羅的か確認
- [ ] COOKBOOK_CROSS_TARGETのユースケースと影響を確認
