---
generated_at: 2026-01-22 16:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-pkgarアーカイブ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/package.rs` 15-118行目 - package関数
- E-02: `src/cook/package.rs` 23-33行目 - BuildKind::None処理
- E-03: `src/cook/package.rs` 35-48行目 - 鍵ファイル確認と生成
- E-04: `src/cook/package.rs` 50-57行目 - ステージ更新時刻取得
- E-05: `src/cook/package.rs` 62-70行目 - 更新判定と古いファイル削除
- E-06: `src/cook/package.rs` 72-78行目 - pkgar::create呼び出し
- E-07: `src/cook/package.rs` 81-86行目 - オプショナルパッケージの依存設定
- E-08: `src/cook/package.rs` 120-174行目 - package_toml関数
- E-09: `src/cook/package.rs` 200-212行目 - package_stage_paths関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildKind::Noneはpkgar作成しない | E-02 | ○ |
| C-02 | 鍵ファイルがなければ自動生成 | E-03 (37-38行目の条件, 41-47行目の生成) | ○ |
| C-03 | id_ed25519.tomlに秘密鍵を保存 | E-03 (35行目) | ○ |
| C-04 | id_ed25519.pub.tomlに公開鍵を保存 | E-03 (36行目) | ○ |
| C-05 | modified_allでステージ更新時刻を取得 | E-04 | ○ |
| C-06 | pkgarより新しいstageなら再作成 | E-05 (64行目の条件) | ○ |
| C-07 | 古いpkgar/tomlを削除 | E-05 (65-69行目) | ○ |
| C-08 | pkgar::createでアーカイブ作成 | E-06 | ○ |
| C-09 | オプショナルパッケージはメインに依存 | E-07 (81-82行目) | ○ |
| C-10 | package_tomlでstage.tomlを生成 | E-08 | ○ |
| C-11 | auto_depsをpackage_depsにマージ | E-08 (127-131行目) | ○ |
| C-12 | blake3ハッシュをメタデータに含める | E-08 (150行目) | ○ |
| C-13 | network_size == storage_size | E-08 (163-164行目) | ○ |
| C-14 | source_identifierをメタデータに含める | E-08 (166-168行目) | ○ |
| C-15 | package_stage_pathsで3つのパスを取得 | E-09 | ○ |
| C-16 | COOKBOOK_CROSS_TARGETでパス変更対応 | E-09 (204-209行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - pkgarアーカイブ作成の全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] Ed25519鍵ファイルがリポジトリにコミットされていないか確認（.gitignore）
- [ ] pkgar::createのエラーハンドリングが適切か確認
- [ ] 圧縮未サポート（network_size == storage_size）の影響を確認
