---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-ソース取得（Git）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **GIT_RESET_BRANCHスクリプトの動作確認**：複雑なbash処理
  2. **shallow_clone判定のデフォルト動作**：コード上の実装確認推奨
  3. **更新スキップ判定ロジック**：複数条件の組み合わせ

## 2) 参照した情報（Evidence一覧）

- E-01: `src/recipe.rs` 35-53行目 - SourceRecipe::Git variant定義
- E-02: `src/cook/fetch.rs` 117-406行目 - fetch()関数
- E-03: `src/cook/fetch.rs` 37-115行目 - fetch_offline()関数
- E-04: `src/cook/fetch.rs` 161-317行目 - Git処理ブロック
- E-05: `src/cook/fetch.rs` 171-197行目 - 新規clone処理
- E-06: `src/cook/fetch.rs` 198-249行目 - 既存更新処理
- E-07: `src/cook/fetch.rs` 251-290行目 - checkout処理
- E-08: `src/cook/fetch.rs` 292-312行目 - submodule処理
- E-09: `src/cook/fs.rs` 291-308行目 - get_git_head_rev()関数
- E-10: `src/cook/fs.rs` 336-367行目 - get_git_fetch_rev()関数
- E-11: `src/cook/fs.rs` 371-460行目 - get_git_remote_tracking()関数
- E-12: `src/cook/script.rs` 346-356行目 - GIT_RESET_BRANCHスクリプト
- E-13: `src/config.rs` 135-167行目 - translate_mirror()関数
- E-14: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報
- E-15: `src/cook/fetch.rs` 606-646行目 - fetch_apply_patches()関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourceRecipe::GitはURL、branch、rev等の7フィールドを持つ | E-01 | ○ |
| C-02 | fetch()関数がメインのソース取得処理を行う | E-02 | ○ |
| C-03 | fetch_offline()関数がオフラインモード対応 | E-03 | ○ |
| C-04 | 新規cloneはsource.tmpに一時保存後アトミックリネーム | E-05 | ○ |
| C-05 | git clone --recursiveでサブモジュールも取得 | E-05 | ○ |
| C-06 | --branchオプションでブランチ指定可能 | E-05 | ○ |
| C-07 | --filter=tree:0でshallow clone対応 | E-05 | ○ |
| C-08 | 既存更新時はgit remote set-urlでURL更新 | E-06 | ○ |
| C-09 | git fetch originでリモートから更新取得 | E-06 | ○ |
| C-10 | 更新必要性の判定でHEADとFETCH_HEADを比較 | E-06, E-09, E-10 | ○ |
| C-11 | rev指定時はgit checkout revを実行 | E-07 | ○ |
| C-12 | パッチ/スクリプトがある場合はgit reset --hard実行 | E-07 | ○ |
| C-13 | git submodule sync --recursiveでURL同期 | E-08 | ○ |
| C-14 | git submodule update --init --recursiveで更新 | E-08 | ○ |
| C-15 | get_git_head_rev()でHEADコミットとdetached状態取得 | E-09 | ○ |
| C-16 | get_git_fetch_rev()でFETCH_HEADからコミット取得 | E-10 | ○ |
| C-17 | get_git_remote_tracking()でリモートトラッキング情報取得 | E-11 | ○ |
| C-18 | GIT_RESET_BRANCHスクリプトでブランチをリモートに同期 | E-12 | ○ |
| C-19 | translate_mirror()でURLをミラーに変換 | E-13 | ○ |
| C-20 | TUIメイン画面との連携がある | E-14 | ○ |
| C-21 | repo fetchコマンドとの連携がある | E-14 | ○ |
| C-22 | fetch_apply_patches()でパッチとスクリプトを適用 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特に不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Git操作の各ステップはソースコードで明確に確認可能
- 1: 中リスク - GIT_RESET_BRANCHスクリプトは複雑なbash処理のため動作確認推奨
- 0: 低リスク - ミラーURL変換ロジックはテストコードで検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] shallow_clone=trueの場合の--filter=tree:0オプション動作確認
- [ ] 更新スキップ判定の各条件（detached/ブランチ/リモート名/URL比較）の動作確認
- [ ] GIT_RESET_BRANCHスクリプトの動作確認（特にRedox上での制限）
- [ ] サブモジュール更新時のshallow_cloneオプション適用確認
- [ ] ミラーURL変換が正しく機能することの確認
