---
generated_at: 2026-01-22 16:15:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-パッケージメタデータ生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/package.rs` 120-174行目 - package_toml関数
- E-02: `src/cook/package.rs` 127-131行目 - 依存関係マージ
- E-03: `src/cook/package.rs` 133-153行目 - blake3ハッシュ取得
- E-04: `src/cook/package.rs` 155行目 - fetch_get_source_info呼び出し
- E-05: `src/cook/package.rs` 157-170行目 - Package構造体構築
- E-06: `src/cook/package.rs` 172行目 - serialize_and_write呼び出し
- E-07: `src/cook/package.rs` 176-190行目 - package_version関数
- E-08: `src/recipe.rs` 70-86行目 - SourceRecipe::guess_version

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | auto_depsとpackage_depsをマージ | E-02 | ○ |
| C-02 | 重複を除外してマージ | E-02 (128行目の条件) | ○ |
| C-03 | pkgarからblake3ハッシュを取得 | E-03 (150行目) | ○ |
| C-04 | 公開鍵でpkgarを検証 | E-03 (135-137行目) | ○ |
| C-05 | メタデータからサイズを取得 | E-03 (144-149行目) | ○ |
| C-06 | fetch_get_source_infoでソース識別子取得 | E-04 | ○ |
| C-07 | commit_identifierをメタデータに含める | E-05 (166行目) | ○ |
| C-08 | source_identifierをメタデータに含める | E-05 (167行目) | ○ |
| C-09 | time_identifierをメタデータに含める | E-05 (168行目) | ○ |
| C-10 | nameにはhost.プレフィックスを含めない | E-05 (158行目 without_host()) | ○ |
| C-11 | serialize_and_writeでTOML出力 | E-06 | ○ |
| C-12 | BuildKind::Noneは空バージョン | E-07 (177-178行目) | ○ |
| C-13 | package.version設定済みならその値を使用 | E-07 (179-180行目) | ○ |
| C-14 | ソースURLから正規表現でバージョン推定 | E-07 (181-186行目), E-08 | ○ |
| C-15 | 推定できなければ"TODO"を返す | E-07 (187行目) | ○ |
| C-16 | Tar URLの場合にguess_versionが動作 | E-08 (71-86行目) | ○ |
| C-17 | network_size == storage_size | E-05 (163-164行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パッケージメタデータ生成の全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] バージョン推定の正規表現パターン（\d+\.\d+\.\d+）が十分か確認
- [ ] without_host()によるパッケージ名変換が意図通りか確認
- [ ] source_info.tomlが存在しない場合のエラーハンドリングを確認
