---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-パッケージ署名

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **トランザクション仕様**：推論による記述
  3. **エラーコード体系**：明示的なコード定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/package.rs` - package関数、package_toml関数の実装
- E-02: `src/recipe.rs` - CookRecipe構造体、BuildKind列挙型の定義
- E-03: `src/bin/repo.rs` - CLIエントリーポイント、package呼び出し
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.21の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報
- E-06: `src/cook/fetch.rs` - fetch_get_source_info関数の実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ed25519鍵ペアでパッケージに電子署名を付与 | E-01 (35-48行目), E-04 | ○ |
| C-02 | 秘密鍵・公開鍵が存在しない場合、新規生成 | E-01 (37-48行目) | ○ |
| C-03 | pkgar形式のアーカイブ作成時に署名生成 | E-01 (73-78行目) | ○ |
| C-04 | BuildKind::Noneのメタパッケージは署名対象外 | E-01 (23-33行目), E-02 | ○ |
| C-05 | 秘密鍵ファイルパスはbuild/id_ed25519.toml | E-01 (35行目) | ○ |
| C-06 | 公開鍵ファイルパスはbuild/id_ed25519.pub.toml | E-01 (36行目) | ○ |
| C-07 | ステージディレクトリが更新されている場合のみ再署名 | E-01 (64-70行目) | ○ |
| C-08 | blake3ハッシュをメタデータに記録 | E-01 (150行目) | ○ |
| C-09 | package_toml関数でメタデータファイルを生成 | E-01 (120-174行目) | ○ |
| C-10 | 依存関係情報をパッケージメタデータに含める | E-01 (127-131行目, 165行目) | ○ |
| C-11 | ソース識別情報を取得して記録 | E-01 (155行目), E-06 | ○ |
| C-12 | repo cookコマンドで署名処理が呼び出される | E-03 (589行目), E-05 | ○ |
| C-13 | repo pushコマンドで署名検証が行われる | E-03 (654行目) | ○ |
| C-14 | clean_target設定に応じてステージ不在時の挙動が変わる | E-01 (50-56行目) | ○ |
| C-15 | オプショナルパッケージも署名対象 | E-01 (59-61行目), E-02 (218-224行目) | ○ |
| C-16 | pkgar_keys::SecretKeyFile::newで鍵生成 | E-01 (41行目) | ○ |
| C-17 | パッケージファイルサイズをメタデータに記録 | E-01 (144-150行目) | ○ |
| C-18 | 鍵ペア生成は数ミリ秒程度で完了 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な測定データ
  - 候補：ベンチマークテスト結果 / 実装コメント / 外部ドキュメント
- エラーコードの体系的な定義
  - 候補：エラー定義ファイル / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の実装は明確に確認可能
- 1: 中リスク - パフォーマンス要件は推測値
- 0: 低リスク - セキュリティ考慮事項はコードから推論可能

## 6) レビュアーチェックリスト（最小）
- [ ] pkgar_keysライブラリのEd25519実装が適切か確認
- [ ] 秘密鍵ファイルのパーミッション設定が.gitignoreに含まれているか確認
- [ ] 署名検証のエラーハンドリングが適切か確認
- [ ] パフォーマンス要件の妥当性を実測で検証
