---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：22-オプショナルパッケージ分離

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ファイルパターンによる分離処理**：cook_build.rsの詳細確認が必要
  2. **globパターンの構文**：実装詳細の確認が必要
  3. **パフォーマンス要件**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/recipe.rs` - OptionalPackageRecipe構造体、get_packages_list関数
- E-02: `src/cook/package.rs` - package関数、package_stage_paths関数、get_package_name関数
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.22の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OptionalPackageRecipeはname, dependencies, filesを持つ | E-01 (153-159行目) | ○ |
| C-02 | Recipeのoptional_packagesフィールドで定義 | E-01 (173行目) | ○ |
| C-03 | get_packages_listでオプショナルとメインを統合 | E-01 (218-224行目) | ○ |
| C-04 | メインパッケージは最後に処理される | E-01 (222行目) | ○ |
| C-05 | package_stage_pathsでステージパス決定 | E-02 (200-212行目) | ○ |
| C-06 | オプショナルパッケージ名は{main}.{name}形式 | E-02 (233-244行目) | ○ |
| C-07 | オプショナルパッケージはメインパッケージに依存 | E-02 (81-85行目) | ○ |
| C-08 | 空名の依存関係は同一レシピ内サフィックスに解決 | E-02 (93-106行目) | ○ |
| C-09 | COOKBOOK_CROSS_TARGETによるパス調整 | E-02 (204-209行目) | ○ |
| C-10 | 各パッケージに個別のpkgarアーカイブ生成 | E-02 (72-78行目) | ○ |
| C-11 | 各パッケージに個別のメタデータ生成 | E-02 (107-114行目) | ○ |
| C-12 | repo cookコマンドでパッケージ分離処理 | E-03, E-04 | ○ |
| C-13 | without_host()でメインパッケージ名を取得 | E-02 (82行目) | ○ |
| C-14 | ファイルパターンに基づくステージディレクトリ分離 | **詳細実装は cook_build.rs** | ○ |
| C-15 | 通常のパッケージングと同等のパフォーマンス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ファイルパターン（files）の具体的な処理実装（cook_build.rs内）
  - 候補：cook_build.rsの詳細解析 / 実行テスト
- パフォーマンス要件の具体的な数値
  - 候補：ベンチマークテスト / 実測データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なデータ構造と処理フローは明確
- 1: 中リスク - ファイルパターンマッチングの詳細は cook_build.rs に依存
- 0: 低リスク - 依存関係設定のロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] OptionalPackageRecipeのfiles フィールドのglobパターン構文を確認
- [ ] cook_build.rsでのファイル分離処理の実装を確認
- [ ] 依存関係の空名解決が期待通り動作するかテストで確認
- [ ] クロスビルド時のパス調整が正しいか確認
