---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-古いパッケージ追跡

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - 全ての主張に根拠あり
- 注意事項
  1. **外部ライブラリ依存**：Package::new_recursive_nonstopの動作

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bin/repo_builder.rs` - outdated_packages処理（177-215行目、230-240行目）
- E-02: `src/cook/fetch.rs` - fetch_get_source_info関数（672-679行目）
- E-03: `src/cook/ident.rs` - get_ident関数
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.25の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Package::new_recursive_nonstopでrecipe_listとrecipe_mapを取得 | E-01 (84行目) | ○ |
| C-02 | recipe_mapからErr()のエントリを抽出 | E-01 (177-180行目) | ○ |
| C-03 | エラーメッセージを出力 | E-01 (181-184行目) | ○ |
| C-04 | recipes::findでレシピパス検索 | E-01 (186行目) | ○ |
| C-05 | CookRecipe::from_pathでレシピ読み込み | E-01 (190行目) | ○ |
| C-06 | fetch_get_source_infoでソース識別情報取得 | E-01 (195行目), E-02 | ○ |
| C-07 | 取得成功時はSourceIdentifierをoutdated_packagesに追加 | E-01 (196-197行目) | ○ |
| C-08 | 取得失敗時は"missing_source"をフォールバックとして使用 | E-01 (204-212行目) | ○ |
| C-09 | get_ident()でコミット/タイム識別子を取得 | E-01 (204行目), E-03 | ○ |
| C-10 | 既存repo.tomlのoutdated_packagesを読み込み | E-01 (230行目) | ○ |
| C-11 | ビルド成功パッケージのセットを作成 | E-01 (231-234行目) | ○ |
| C-12 | ビルド成功分をoutdated_packagesから除外 | E-01 (235-239行目) | ○ |
| C-13 | 今回処理しなかったパッケージは既存情報を継承 | E-01 (236行目の条件) | ○ |
| C-14 | repo.tomlのoutdated_packagesセクションに出力 | E-01 (268-271行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の実装は明確に確認可能
- 0: 低リスク - フォールバック処理は適切に実装
- 1: 中リスク - Package::new_recursive_nonstopの外部ライブラリ依存

## 6) レビュアーチェックリスト（最小）
- [ ] Package::new_recursive_nonstopのエラー情報が適切にrecipe_mapに格納されるか確認
- [ ] フォールバック識別子（"missing_source"）の使用が適切か確認
- [ ] ビルド成功分の除外ロジックが正しく動作するか確認
- [ ] 既存outdated_packagesの継承ロジックが正しいか確認
