---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-AppStream生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - 全ての主張に根拠あり
- 注意事項
  1. **外部ツール依存**：appstreamcliコマンドがシステムにインストールされている必要がある

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bin/repo_builder.rs` - AppStream生成処理（91行目、128-130行目、134-174行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.26の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | appstream_sourcesはHashMap<String, PathBuf>で管理 | E-01 (91行目) | ○ |
| C-02 | usr/share/metainfoディレクトリの存在で検出 | E-01 (128行目) | ○ |
| C-03 | 検出されたパッケージをappstream_sourcesに追加 | E-01 (129行目) | ○ |
| C-04 | COOKBOOK_APPSTREAM=true時のみ実行 | E-01 (43行目、135行目) | ○ |
| C-05 | appstream_rootはbuild/{target}/appstream | E-01 (140-143行目) | ○ |
| C-06 | appstream_pkgはrepo-appstream.pkgar | E-01 (144行目) | ○ |
| C-07 | 既存ディレクトリ・ファイルを削除して再作成 | E-01 (146-148行目) | ○ |
| C-08 | appstreamcli composeコマンドを実行 | E-01 (151-153行目) | ○ |
| C-09 | origin=pkgarを指定 | E-01 (154行目) | ○ |
| C-10 | print-report=fullを指定 | E-01 (155行目) | ○ |
| C-11 | result-rootで出力先指定 | E-01 (156行目) | ○ |
| C-12 | 各ソースディレクトリを引数に追加 | E-01 (158-160行目) | ○ |
| C-13 | appstreamcli失敗時はエラー返却 | E-01 (162-166行目) | ○ |
| C-14 | pkgar::createでパッケージ化 | E-01 (168-172行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の実装は明確に確認可能
- 2: 高リスク - appstreamcliへの外部依存（インストール必要、バージョン依存）
- 0: 低リスク - pkgar::createは他機能と共通

## 6) レビュアーチェックリスト（最小）
- [ ] appstreamcliコマンドがシステムにインストールされているか確認
- [ ] appstreamcliのバージョンが互換性があるか確認
- [ ] metainfoファイルの形式がAppStream仕様に準拠しているか確認
- [ ] 生成されたカタログが有効かappstreamcli validateで検証
