---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-cookコマンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - 全ての主張に根拠あり
- 注意事項
  1. **TUIモード**：ratatuiライブラリへの依存

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bin/repo.rs` - main_inner、repo_inner、handle_cook、run_tui_cook、publish_packages関数
- E-02: `src/recipe.rs` - BuildKind列挙型、BuildRecipe構造体
- E-03: `src/config.rs` - CookConfig構造体
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.28の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildKindは7種類（None、Remote、Cargo、Configure、Cmake、Meson、Custom） | E-02 (90-128行目) | ○ |
| C-02 | main_innerでparse_argsとコマンド振り分け | E-01 (182-249行目) | ○ |
| C-03 | TUIモード判定（CI環境変数、STDIN） | E-03 (80-82行目), E-01 (194行目) | ○ |
| C-04 | run_tui_cookでTUI処理 | E-01 (1012-1501行目) | ○ |
| C-05 | Cookerスレッドでhandle_cook実行 | E-01 (1027-1110行目) | ○ |
| C-06 | Fetcherスレッドでhandle_fetch実行 | E-01 (1136-1218行目) | ○ |
| C-07 | handle_cookでcreate_target_dir、build、package実行 | E-01 (568-606行目) | ○ |
| C-08 | nonstop時はhandle_nonstop_fail実行 | E-01 (609-617行目), (225-227行目) | ○ |
| C-09 | publish_packagesでrepo_builder呼び出し | E-01 (357-371行目) | ○ |
| C-10 | is_deps判定でレシピをマーク | E-01 (500行目) | ○ |
| C-11 | clean_target時はステージディレクトリ削除 | E-01 (592-604行目) | ○ |
| C-12 | ログはbuild/logs/{target}/{recipe}.logに保存 | E-01 (332-333行目, 1050行目) | ○ |
| C-13 | COOKBOOK_MAKE_JOBSでジョブ数制御 | E-03 (83-89行目) | ○ |
| C-14 | エラー時にRetry/Skip/Exit選択（TUIモード） | E-01 (1610-1633行目, 1746-1784行目) | ○ |
| C-15 | repo cookコマンドで実行 | E-01 (292-298行目) | ○ |
| C-16 | 依存関係を含めてレシピリスト構築 | E-01 (491-510行目) | ○ |
| C-17 | --filesystemオプションでインストーラ設定指定 | E-01 (386-391行目, 471-489行目) | ○ |
| C-18 | ビルド完了後にpublish_packages呼び出し | E-01 (203行目, 237-238行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の実装は明確に確認可能
- 1: 中リスク - TUIモードはratatuiライブラリに依存
- 0: 低リスク - エラーハンドリングは適切に実装

## 6) レビュアーチェックリスト（最小）
- [ ] TUIモードの動作を確認
- [ ] nonstopモードのエラーハンドリングを確認
- [ ] 依存関係解決が正しく動作するか確認
- [ ] clean_target時のステージ削除が正しいか確認
