---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：29-unfetchコマンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **削除対象の確認**：コード上はunfetchでsource/とtarget/の両方が削除される
  2. **機能一覧との整合性**：機能一覧ではsource/のみ削除と記載

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bin/repo.rs` - repo_inner関数（349行目）、handle_clean関数（619-634行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.29の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | unfetchコマンドはsourceディレクトリを削除 | E-01 (629-632行目), E-02 | ○ |
| C-02 | repo unfetchで実行 | E-01 (349行目) | ○ |
| C-03 | handle_clean関数で削除処理 | E-01 (619-634行目) | ○ |
| C-04 | ディレクトリ存在時のみ削除 | E-01 (626行目, 630行目) | ○ |
| C-05 | fs::remove_dir_allで再帰削除 | E-01 (627行目, 631行目) | ○ |
| C-06 | source/パスはrecipe.dir.join("source") | E-01 (629行目) | ○ |
| C-07 | 削除操作は不可逆 | E-01 (fs::remove_dir_allの特性) | ○ |
| C-08 | unfetchはsource/のみ削除、target/は残す | **コード上は両方削除** | △ |
| C-09 | cleanとの違い：cleanはtarget/を削除 | E-01 (350行目) | ○ |
| C-10 | --allオプションで全レシピ削除可能 | E-01 (450-457行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 機能一覧とコード実装の不整合
  - 機能一覧：「レシピのソースディレクトリを削除する」
  - コード：`handle_clean(recipe, config, true, true)` でsource/とtarget/の両方を削除
  - 候補：仕様確認 / コード修正 / ドキュメント修正

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - unfetchの実際の動作がドキュメント（機能一覧）と異なる可能性
- 0: 低リスク - 削除処理自体は標準的な実装
- 0: 低リスク - エラーハンドリングは適切

## 6) レビュアーチェックリスト（最小）
- [ ] unfetchコマンドの実際の動作を確認（source/のみかsource/+target/か）
- [ ] 機能一覧とコード実装の整合性を確認
- [ ] ユーザーへの影響（target/が消える場合、ビルド成果物が消失）を確認
- [ ] ドキュメントまたはコードの修正が必要か判断
