---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-ソース取得（Tar）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **オフラインモードの動作確認**：特殊な条件分岐
  2. **ハッシュ不一致時の再ダウンロード処理**：ループ構造の確認
  3. **Redox OS上でのtar動作差異**：プラットフォーム固有処理

## 2) 参照した情報（Evidence一覧）

- E-01: `src/recipe.rs` 55-66行目 - SourceRecipe::Tar variant定義
- E-02: `src/cook/fetch.rs` 318-380行目 - Tar処理ブロック
- E-03: `src/cook/fetch.rs` 324-359行目 - ダウンロードとハッシュ検証ループ
- E-04: `src/cook/fetch.rs` 360-378行目 - 展開処理
- E-05: `src/cook/fetch.rs` 21-35行目 - get_blake3()関数
- E-06: `src/blake3.rs` 6-23行目 - blake3_progress()関数
- E-07: `src/blake3.rs` 25-31行目 - blake3_silent()関数
- E-08: `src/cook/fs.rs` 278-288行目 - download_wget()関数
- E-09: `src/cook/fetch.rs` 454-476行目 - fetch_extract_tar()関数
- E-10: `src/cook/fetch.rs` 582-604行目 - fetch_is_patches_newer()関数
- E-11: `src/config.rs` 135-167行目 - translate_mirror()関数
- E-12: `src/recipe.rs` 70-86行目 - guess_version()関数
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourceRecipe::TarはURL、blake3、patches、scriptの4フィールドを持つ | E-01 | ○ |
| C-02 | wgetコマンドでTarをダウンロードする | E-08 | ○ |
| C-03 | BLAKE3ハッシュで整合性を検証する | E-05, E-06, E-07 | ○ |
| C-04 | ハッシュ不一致時は新規DLならエラー、既存なら再ダウンロード | E-03 | ○ |
| C-05 | blake3未指定時は警告を出力する | E-03 | ○ |
| C-06 | tar --extract --strip-components=1で展開する | E-09 | ○ |
| C-07 | --no-same-ownerオプションを使用する（非Redox） | E-09 | ○ |
| C-08 | source.tmpに一時展開後アトミックリネーム | E-04 | ○ |
| C-09 | パッチファイルがsourceより新しい場合は再展開 | E-10 | ○ |
| C-10 | translate_mirror()でURLをミラーに変換 | E-11 | ○ |
| C-11 | guess_version()でURLからバージョンを抽出可能 | E-12 | ○ |
| C-12 | repo fetchコマンドとの連携がある | E-13 | ○ |
| C-13 | source.tar.tmpに一時保存後リネーム | E-08 | ○ |
| C-14 | BLAKE3は256ビット（64文字16進数）出力 | E-06, E-07 | ○ |
| C-15 | 大きなファイルではプログレスバー表示 | E-06 | ○ |
| C-16 | Redox OS上ではtarコマンドの引数が異なる | E-09 | ○ |
| C-17 | オフラインモードではsource.tar存在確認とblake3検証のみ | E-02 | ○ |
| C-18 | wget --continueで中断したダウンロードを継続可能 | E-08 | ○ |
| C-19 | fetch_apply_patches()でパッチとスクリプトを適用 | E-02 | ○ |
| C-20 | source_identifierはblake3ハッシュ値を使用 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特に不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - BLAKE3ハッシュ検証ロジックは明確
- 1: 中リスク - ダウンロード+検証ループ（while）の終了条件確認推奨
- 0: 低リスク - tar展開処理は標準的なコマンド使用

## 6) レビュアーチェックリスト（最小）
- [ ] blake3未指定時の警告メッセージが適切か確認
- [ ] ハッシュ不一致時の再ダウンロードループが無限ループにならないか確認
- [ ] --strip-components=1が想定通り動作するか確認
- [ ] Redox OS上でのtar動作差異が正しく処理されるか確認
- [ ] オフラインモードでのblake3検証動作確認
