---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-cleanコマンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. **特になし** - 全ての主張に根拠あり
- 注意事項
  1. **unfetchとの違い**：unfetchは両方削除、cleanはtarget/のみ

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bin/repo.rs` - repo_inner関数（350行目）、handle_clean関数（619-634行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.30の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cleanコマンドはtargetディレクトリを削除 | E-01 (625-628行目), E-02 | ○ |
| C-02 | repo cleanで実行 | E-01 (350行目) | ○ |
| C-03 | handle_clean関数で削除処理 | E-01 (619-634行目) | ○ |
| C-04 | ディレクトリ存在時のみ削除 | E-01 (626行目) | ○ |
| C-05 | fs::remove_dir_allで再帰削除 | E-01 (627行目) | ○ |
| C-06 | target/パスはrecipe.dir.join("target") | E-01 (625行目) | ○ |
| C-07 | 削除操作は不可逆 | E-01 (fs::remove_dir_allの特性) | ○ |
| C-08 | cleanはtarget/のみ削除、source/は残す | E-01 (350行目: source=false, target=true) | ○ |
| C-09 | unfetchとの違い：unfetchは両方削除 | E-01 (349行目: source=true, target=true) | ○ |
| C-10 | --allオプションで全レシピ削除可能 | E-01 (404行目, 450-457行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 削除処理自体は標準的な実装
- 0: 低リスク - エラーハンドリングは適切
- 0: 低リスク - unfetchとの違いがコード上で明確

## 6) レビュアーチェックリスト（最小）
- [ ] cleanコマンドの実際の動作を確認（target/のみ削除されるか）
- [ ] source/が保持されることを確認
- [ ] unfetchとの動作の違いを確認
- [ ] --allオプションの動作を確認
