---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-treeコマンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cook/tree.rs` 12-17行目（WalkTreeEntry列挙型）
- E-02: `src/cook/tree.rs` 19-36行目（display_tree_entry関数）
- E-03: `src/cook/tree.rs` 38-107行目（walk_tree_entry関数）
- E-04: `src/cook/tree.rs` 109-124行目（display_pkg_fn関数）
- E-05: `src/cook/tree.rs` 166-174行目（format_size関数）
- E-06: `src/bin/repo.rs` 735-766行目（handle_tree関数）
- E-07: `src/bin/repo.rs` 205-206行目（handle_tree呼び出し）
- E-08: `src/cook/tree.rs` 56-63行目（pkgar存在確認）
- E-09: `src/cook/tree.rs` 72-74行目（サイズ累積）
- E-10: `src/cook/tree.rs` 77-86行目（依存関係取得）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WalkTreeEntryは4つの状態を持つ | E-01 | ○ |
| C-02 | display_tree_entryが表示のエントリーポイント | E-02 | ○ |
| C-03 | walk_tree_entryで再帰的にツリーを走査 | E-03 | ○ |
| C-04 | display_pkg_fnが各ノードの表示を担当 | E-04 | ○ |
| C-05 | format_sizeでサイズを人間可読形式に変換 | E-05 | ○ |
| C-06 | handle_tree関数がコマンドのメイン処理 | E-06 | ○ |
| C-07 | main_innerからhandle_treeが呼ばれる | E-07 | ○ |
| C-08 | pkgarファイル不在時はNotBuilt状態 | E-08 | ○ |
| C-09 | 訪問済みパッケージはDeduped状態 | E-08 | ○ |
| C-10 | Built状態でのみサイズを累積 | E-09 | ○ |
| C-11 | stage.tomlから依存関係を取得 | E-10 | ○ |
| C-12 | stage.tomlがなければrecipe.tomlを使用 | E-10 | ○ |
| C-13 | サイズ単位はB/KiB/MiB/GiB/TiB | E-05 | ○ |
| C-14 | 1024進数でサイズを計算 | E-05 | ○ |
| C-15 | ツリー記号は最後かどうかで分岐 | E-04 | ○ |
| C-16 | 合計サイズとパッケージ数をサマリー出力 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張がソースコードで確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] WalkTreeEntryの4状態の処理が正しく記載されているか確認
- [ ] format_size関数の計算ロジックが正確か確認
- [ ] 再帰処理の終了条件が正しく記載されているか確認
