---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：33-findコマンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **C-10**：pkg::recipes::find関数の内部実装

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bin/repo.rs` 353行目（CliCommand::Find処理）
- E-02: `src/bin/repo.rs` 102-104行目（is_informational関数）
- E-03: `src/bin/repo.rs` 545-548行目（verbose抑制処理）
- E-04: `src/recipe.rs` 196-204行目（CookRecipe構造体定義）
- E-05: `src/recipe.rs` 262-268行目（from_name関数）
- E-06: `src/recipe.rs` 263-264行目（recipes::find呼び出し）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | findコマンドはレシピディレクトリパスを出力する | E-01 | ○ |
| C-02 | CookRecipe.dirにパスが格納される | E-04 | ○ |
| C-03 | from_name関数でレシピ情報を取得 | E-05 | ○ |
| C-04 | recipes::findでディレクトリを検索 | E-06 | ○ |
| C-05 | findは情報コマンドとして分類される | E-02 | ○ |
| C-06 | 情報コマンドはverbose出力が抑制される | E-03 | ○ |
| C-07 | displayメソッドでパスを文字列化 | E-01 | ○ |
| C-08 | println!でパスを出力 | E-01 | ○ |
| C-09 | パッケージが見つからない場合はエラー | E-05 | ○ |
| C-10 | pkg::recipes::findがディレクトリを検索 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- pkg::recipesクレートのfind関数の実装詳細
  - 候補：pkgクレートのソースコード / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能が単純でほとんどの処理が確認可能
- 1: 中リスク - 外部クレート依存部分の詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] CliCommand::Find分岐の処理が正しく記載されているか確認
- [ ] is_informational関数の分類が正確か確認
- [ ] pkg::recipes::find関数の動作を外部ドキュメントで確認
