---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-並列ビルドTUI

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bin/repo.rs` 812-836行目（TuiApp構造体）
- E-02: `src/bin/repo.rs` 772-780行目（RecipeStatus列挙型）
- E-03: `src/bin/repo.rs` 782-794行目（StatusUpdate列挙型）
- E-04: `src/bin/repo.rs` 1754-1758行目（FailurePrompt構造体）
- E-05: `src/bin/repo.rs` 194-203行目（TUIモード判定）
- E-06: `src/bin/repo.rs` 1012-1501行目（run_tui_cook関数）
- E-07: `src/bin/repo.rs` 1023-1110行目（Cookerスレッド）
- E-08: `src/bin/repo.rs` 1136-1218行目（Fetcherスレッド）
- E-09: `src/bin/repo.rs` 1121-1129行目（入力イベントスレッド）
- E-10: `src/bin/repo.rs` 1234-1243行目（レイアウト構築）
- E-11: `src/bin/repo.rs` 1247-1271行目（Fetch Queueパネル）
- E-12: `src/bin/repo.rs` 1274-1340行目（Cook Queueパネル）
- E-13: `src/bin/repo.rs` 1356-1443行目（Logパネル）
- E-14: `src/bin/repo.rs` 1635-1707行目（draw_prompt関数）
- E-15: `src/bin/repo.rs` 1517-1597行目（handle_main_event関数）
- E-16: `src/bin/repo.rs` 1610-1633行目（handle_prompt_input関数）
- E-17: `src/bin/repo.rs` 1021行目（TICK_RATE定義）
- E-18: `src/bin/repo.rs` 1746-1752行目（PromptOption列挙型）
- E-19: `src/config.rs` 80-82行目（TUIデフォルト設定）
- E-20: `src/bin/repo.rs` 1225-1226行目（スピナー定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TuiAppがUI状態を管理 | E-01 | ○ |
| C-02 | RecipeStatusは6つの状態を持つ | E-02 | ○ |
| C-03 | StatusUpdateでスレッド間通信 | E-03 | ○ |
| C-04 | FailurePromptでエラーダイアログ表示 | E-04 | ○ |
| C-05 | CI環境変数でTUIモードを判定 | E-19 | ○ |
| C-06 | run_tui_cookがTUIメイン処理 | E-06 | ○ |
| C-07 | Cookerスレッドでビルド処理 | E-07 | ○ |
| C-08 | Fetcherスレッドでソース取得 | E-08 | ○ |
| C-09 | 入力イベントスレッドでキー入力処理 | E-09 | ○ |
| C-10 | 3分割レイアウトで表示 | E-10 | ○ |
| C-11 | Fetch Queueパネルがある | E-11 | ○ |
| C-12 | Cook Queueパネルがある | E-12 | ○ |
| C-13 | Logパネルがある | E-13 | ○ |
| C-14 | draw_promptでダイアログ描画 | E-14 | ○ |
| C-15 | handle_main_eventでキーイベント処理 | E-15 | ○ |
| C-16 | handle_prompt_inputでプロンプト入力処理 | E-16 | ○ |
| C-17 | TICK_RATEは100ms | E-17 | ○ |
| C-18 | PromptOptionはRetry/Skip/Exitの3つ | E-18 | ○ |
| C-19 | スピナーアニメーションを表示 | E-20 | ○ |
| C-20 | fetchとcookは並列実行 | E-07, E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張がソースコードで確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] TuiApp構造体のフィールドが正しく説明されているか確認
- [ ] スレッド間通信のStatusUpdateの各バリアントが正確か確認
- [ ] キーバインドが実際のhandle_main_eventと一致するか確認
- [ ] プロンプトの選択肢とprompting値の対応が正確か確認
