---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-ビルドログ出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cook/pty.rs` 32行目（PtyOut型定義）
- E-02: `src/cook/pty.rs` 34-57行目（setup_pty関数）
- E-03: `src/cook/pty.rs` 111-153行目（openpty関数）
- E-04: `src/cook/pty.rs` 18-29行目（log_to_pty!マクロ）
- E-05: `src/bin/repo.rs` 1038-1050行目（ログファイルパス構築）
- E-06: `src/bin/repo.rs` 1042行目（ログディレクトリ作成）
- E-07: `src/bin/repo.rs` 1046-1050行目（ログファイルオープン）
- E-08: `src/bin/repo.rs` 1057-1081行目（PTYリーダースレッド）
- E-09: `src/bin/repo.rs` 1083-1104行目（パイプリーダースレッド）
- E-10: `src/cook/pty.rs` 303-311行目（UnixMasterPty/UnixSlavePty構造体）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PtyOutはOption<(&mut UnixSlavePty, &mut PipeWriter)>型 | E-01 | ○ |
| C-02 | setup_pty関数でPTYペアを作成 | E-02 | ○ |
| C-03 | openpty関数でmaster/slaveペアを作成 | E-03 | ○ |
| C-04 | log_to_pty!マクロでログ出力 | E-04 | ○ |
| C-05 | ログファイルはbuild/logs/{target}/{package}.log | E-05 | ○ |
| C-06 | create_dir_allでログディレクトリを再帰作成 | E-06 | ○ |
| C-07 | File::createでログファイルをオープン | E-07 | ○ |
| C-08 | PTYリーダースレッドで出力を収集 | E-08 | ○ |
| C-09 | パイプリーダースレッドでログを収集 | E-09 | ○ |
| C-10 | UnixMasterPtyからリーダーを取得 | E-02, E-10 | ○ |
| C-11 | loggerがNoneの場合はstderrに出力 | E-04 | ○ |
| C-12 | パイプはstd::io::pipeで作成 | E-02 | ○ |
| C-13 | 子プロセスはPTYをstdout/stderrとして起動 | E-08 | ○ |
| C-14 | リアルタイムでログを収集・書き込み | E-08, E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張がソースコードで確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] PtyOut型の定義が正しく説明されているか確認
- [ ] setup_pty関数の処理フローが正確か確認
- [ ] log_to_pty!マクロの動作が正しく記載されているか確認
- [ ] ログファイルパスの構築が正確か確認
