---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-オフラインモード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/config.rs` 89行目（CookConfig.offlineフィールド）
- E-02: `src/config.rs` 91-92行目（COOKBOOK_OFFLINE環境変数）
- E-03: `src/bin/repo.rs` 392行目（--offlineオプション解析）
- E-04: `src/cook/fetch.rs` 37-115行目（fetch_offline関数）
- E-05: `src/cook/fetch.rs` 41-45行目（BuildKind::None処理）
- E-06: `src/cook/fetch.rs` 46-49行目（BuildKind::Remote処理）
- E-07: `src/cook/fetch.rs` 74-77行目（Gitソース確認）
- E-08: `src/cook/fetch.rs` 83-108行目（Tarソース確認）
- E-09: `src/cook/fs.rs` 268-276行目（offline_check_exists関数）
- E-10: `src/cook/script.rs` 128-132行目（COOKBOOK_OFFLINE伝播）
- E-11: `src/recipe.rs` 92-128行目（BuildKind列挙型）
- E-12: `src/recipe.rs` 20-67行目（SourceRecipe列挙型）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CookConfig.offlineでオフラインモードを管理 | E-01 | ○ |
| C-02 | COOKBOOK_OFFLINE環境変数で有効化可能 | E-02 | ○ |
| C-03 | --offlineオプションで有効化可能 | E-03 | ○ |
| C-04 | fetch_offline関数でオフラインfetchを実行 | E-04 | ○ |
| C-05 | BuildKind::Noneはsource不要 | E-05 | ○ |
| C-06 | BuildKind::Remoteはoffline_mode=trueで呼び出し | E-06 | ○ |
| C-07 | Gitソースは既存source dirを確認 | E-07 | ○ |
| C-08 | Tarソースはsource.tarまたはsource dirを確認 | E-08 | ○ |
| C-09 | offline_check_existsで存在確認 | E-09 | ○ |
| C-10 | Cargoに--offlineフラグを伝播 | E-10 | ○ |
| C-11 | 環境変数は"1"で有効化 | E-02 | ○ |
| C-12 | blake3検証はオフラインでも実行 | E-08 | ○ |
| C-13 | BuildKindは6種類 | E-11 | ○ |
| C-14 | SourceRecipeは4種類 | E-12 | ○ |
| C-15 | ソース不在時はエラー終了 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張がソースコードで確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] fetch_offline関数の各BuildKind/SourceRecipeの処理が正確か確認
- [ ] offline_check_exists関数のエラーメッセージが正確か確認
- [ ] Cargoへの--offlineフラグ伝播が正確か確認
- [ ] 環境変数COOKBOOK_OFFLINEの判定ロジックが正確か確認
